import { KArea } from './KArea';
import { KDimension } from './KDimension';
import { KViewPort } from './KViewPort';
import { IRichGraphicsConst } from './IRichGraphics';
import { RichGraphicsUtil } from './RichGraphicsUtil';
import { K2DFigureType } from '../geom/K2DFigureType';
//module jp.kitec.kwt
/**
 * @author matsuzaki
 **/
export class AbstractRichGraphics {
    ///**
    // * コサインの360度のテーブル **/
    //static COS_TABLE: Array<number> = new Array(360);
    ///**
    // * サインの360度のテーブル **/
    //static SIN_TABLE: Array<number> = new Array(360);
    //private static $init_AbstractRichGraphics_863_flg : Boolean = $init_AbstractRichGraphics_863();
    //private static function $init_AbstractRichGraphics_863() : Boolean {{
    //        for (var s : number = 0; s < 360; s++) {
    //            AbstractRichGraphics.COS_TABLE[s] = Math.cos((s) * AbstractRichGraphics.RAD);
    //            AbstractRichGraphics.SIN_TABLE[s] = Math.sin((s) * AbstractRichGraphics.RAD);
    //        }
    //    }
    //    return true;
    //}
    /****/
    constructor() {
        this.mViewPort = new KViewPort();
        this.mDimension = new KDimension();
    }
    /**
     * ビューポートの設定
     * @param vp
    **/
    setViewPort(vp) {
        this.mViewPort = vp;
    }
    /**
     * ビューポートの取得
     * @return
    **/
    getViewPort() {
        return this.mViewPort;
    }
    setSize(w, h) {
        this.mDimension.width = w;
        this.mDimension.height = h;
    }
    getSize() {
        return new KDimension(this.mDimension);
    }
    /**
     * @return the dotPerLen**/
    getDotPerLen() {
        return this.mDotPerLen;
    }
    /**
     * ビューの設定
     * @param x1
     * @param y1
     * @param x2
     * @param y2
    **/
    setView(x1, y1, x2, y2, d = this.mDimension) {
        var vp = this.getViewPort();
        vp.setX1(x1 < x2 ? x1 : x2);
        vp.setX2(x1 < x2 ? x2 : x1);
        vp.setY1(y1 < y2 ? y1 : y2);
        vp.setY2(y1 < y2 ? y2 : y1);
        this.updateViewScale(d);
    }
    /**
     * 画面中心の移動
     * @param cx
     * @param cy
    **/
    setViewCenter(cx, cy) {
        var vp = this.getViewPort();
        vp.setViewCenter(cx, cy);
        this.updateViewScale(this.mDimension);
    }
    /**
     * 描画範囲を返します。
     * @return
    **/
    getDrawArea() {
        var a = new KArea();
        a.maximize();
        a.updateMinMax(this.devToRealX(0), this.devToRealY(0));
        a.updateMinMax(this.devToRealX(this.mDimension.width), this.devToRealY(this.mDimension.height));
        return a;
    }
    /**
     * 実座標から画面座標へ（ｘ）
     * @param x	実座標値
     * @return	デバイス座標値
    **/
    realToDevX(x) {
        if (this.mDimension == null)
            return 0;
        return this.getViewPort().realToDevX(this.mDimension, x);
    }
    /**
     * 実座標から画面座標へ（ｙ）
     * @param y	実座標値
     * @return	デバイス座標値
    **/
    realToDevY(y) {
        if (this.mDimension == null)
            return 0;
        return this.getViewPort().realToDevY(this.mDimension, y);
    }
    /**
     * 実座標から画面座標へ（ｘ）
     * @param x	実座標値
     * @return	デバイス座標値
    **/
    realToDevXd(x) {
        if (this.mDimension == null)
            return 0;
        return this.getViewPort().realToDevXd(this.mDimension, x);
    }
    /**
     * 実座標から画面座標へ（ｙ）
     * @param y	実座標値
     * @return	デバイス座標値
    **/
    realToDevYd(y) {
        if (this.mDimension == null)
            return 0;
        return this.getViewPort().realToDevYd(this.mDimension, y);
    }
    /**
     * 画面座標から実座標へ（ｘ）
     * @param x	デバイス座標値
     * @return		実座標値
    **/
    devToRealX(x) {
        if (this.mDimension == null)
            return 0;
        return this.getViewPort().devToRealX(this.mDimension, x);
    }
    /**
     * 画面座標から実座標へ（ｙ）
     * @param y	デバイス座標値
     * @return		実座標値
    **/
    devToRealY(y) {
        if (this.mDimension == null)
            return 0;
        return this.getViewPort().devToRealY(this.mDimension, y);
    }
    /**
     * 1ドットの長さを更新**/
    updateViewScale(d) {
        if (d == null)
            return;
        this.mDotPerLen = this.getViewPort().dotPerLen(d);
    }
    drawPolygon(poly, lt) {
        if (poly == null || poly.length == 0)
            return;
        this.pathInit(IRichGraphicsConst.WIND_EVEN_ODD);
        for (var i = 0; i < poly.length; i++) {
            var p = poly[i];
            if (i == 0)
                this.pathMoveTo(p.getX(), p.getY(), null);
            else
                this.pathLineTo(p.getX(), p.getY(), null);
        }
        this.pathClose();
        this.drawPath(lt);
        this.pathClear();
    }
    drawFillPolygon(poly, lt) {
        if (poly == null || poly.length == 0)
            return;
        this.pathInit(IRichGraphicsConst.WIND_EVEN_ODD);
        for (var i = 0; i < poly.length; i++) {
            var p = poly[i];
            if (i == 0)
                this.pathMoveTo(p.getX(), p.getY(), null);
            else
                this.pathLineTo(p.getX(), p.getY(), null);
        }
        this.pathClose();
        this.fillPath(lt);
        this.pathClear();
    }
    drawPolyLine(poly, lt) {
        if (poly == null || poly.length == 0)
            return;
        this.pathInit(IRichGraphicsConst.WIND_EVEN_ODD);
        for (var i = 0; i < poly.length; i++) {
            var p = poly[i];
            if (i == 0)
                this.pathMoveTo(p.getX(), p.getY(), null);
            else
                this.pathLineTo(p.getX(), p.getY(), null);
        }
        this.drawPath(lt);
        this.pathClear();
    }
    isInCanvas(x, y) {
        if (x < 0 || x > this.mDimension.width)
            return false;
        if (y < 0 || y > this.mDimension.height)
            return false;
        return true;
    }
    getx(x, y, la) {
        var xx;
        if (la == null) {
            xx = this.realToDevXd(x);
        }
        else {
            xx = this.realToDevXd(la.getGlobalX(x, y));
        }
        return xx;
    }
    gety(x, y, la) {
        var yy;
        if (la == null) {
            yy = this.realToDevYd(y);
        }
        else {
            yy = this.realToDevYd(la.getGlobalY(x, y));
        }
        return yy;
    }
    pathAdd(col, la) {
        if (col.length < 2)
            return;
        var f1 = col[0];
        var f2 = col[1];
        var x1;
        var y1;
        if (RichGraphicsUtil.isSame2D(f1.getX1(), f1.getY1(), f2.getX1(), f2.getY1()) || RichGraphicsUtil.isSame2D(f1.getX1(), f1.getY1(), f2.getX2(), f2.getY2())) {
            x1 = f1.getX2();
            y1 = f1.getY2();
        }
        else {
            x1 = f1.getX1();
            y1 = f1.getY1();
        }
        this.pathMoveTo(x1, y1, la);
        for (var i = 0; i < col.length; i++) {
            f1 = col[i];
            f2 = col[i + 1];
            var startflip = false;
            if (RichGraphicsUtil.isSame2D(f1.getX1(), f1.getY1(), f2.getX1(), f2.getY1())
                || RichGraphicsUtil.isSame2D(f1.getX1(), f1.getY1(), f2.getX2(), f2.getY2()))
                startflip = true;
            if (f1.getType() === K2DFigureType.ARC_CW
                || f1.getType() === K2DFigureType.ARC_CCW) {
                var arc = f1;
                var r = arc.getRadius();
                var cx = arc.getCX();
                var cy = arc.getCY();
                var p1a = RichGraphicsUtil.getAngle2D(cx, cy, arc.getX1(), arc.getY1());
                var p2a = RichGraphicsUtil.getAngle2D(cx, cy, arc.getX2(), arc.getY2());
                var angl = p2a - p1a;
                while (angl < 0)
                    angl += 360;
                if (arc.isCw())
                    angl = -(360 - angl);
                if (startflip)
                    angl = -angl;
                this.pathArc(cx, cy, r, r, startflip ? p2a : p1a, angl, la);
            }
            else {
                if (startflip) {
                    this.pathLineTo(f1.getX1(), f1.getY1(), la);
                }
                else {
                    this.pathLineTo(f1.getX2(), f1.getY2(), la);
                }
            }
        }
    }
    /**
     * 円弧パスの追加
     * anglが負の場合は時計回り。
     * @param xc
     * @param yc
     * @param ra
     * @param ss
     * @param ee
     * @param la
     * @author kawae
     * @since 2006/01/18
    **/
    //pathArc(xc: number, yc: number, ra: number, startangl: number, angl: number, la: KLocalAxis): void {
    //    this.pathArc(xc, yc, ra, ra, startangl, angl, la);
    //}
    pathArc(cx, cy, r, h, startAngle, arcAngle, la) {
        var div = 4;
        var width = r * 2.0;
        var height = h * 2.0;
        var ath = arcAngle * Math.PI / 180.0;
        var theta = ath / div;
        var cos = Math.cos(theta);
        var sin = Math.sin(theta);
        var x = new Array(4);
        var y = new Array(4);
        x[0] = x[1] = 1.0;
        y[0] = 0.0;
        x[3] = cos;
        y[3] = sin;
        x[2] = (8.0 * Math.cos(theta / 2) - (x[0] + 3 * x[1] + x[3])) / 3;
        y[2] = y[3] - (-x[2] + x[3]) / (-Math.tan(theta));
        y[1] = (8.0 * Math.sin(theta / 2) - (y[0] + 3 * y[2] + y[3])) / 3;
        var stheta = startAngle * Math.PI / 180.0;
        var scos = Math.cos(stheta);
        var ssin = Math.sin(stheta);
        var xtmp = new Array(4);
        var ytmp = new Array(4);
        for (var j__0 = 0; j__0 < 4; j__0++) {
            xtmp[j__0] = x[j__0] * scos - y[j__0] * ssin;
            ytmp[j__0] = x[j__0] * ssin + y[j__0] * scos;
            x[j__0] = xtmp[j__0];
            y[j__0] = ytmp[j__0];
        }
        var aspect = height / width;
        if (isNaN(aspect))
            aspect = 1;
        this.pathMoveTo((r * x[0]) + cx, (r * y[0]) * aspect + cy, la);
        for (var i = 0; i < div; i++) {
            this.pathCurveTo((r * x[1]) + cx, (r * y[1]) * aspect + cy, (r * x[2]) + cx, (r * y[2]) * aspect + cy, (r * x[3]) + cx, (r * y[3]) * aspect + cy, la);
            for (var j__1 = 1; j__1 < 4; j__1++) {
                xtmp[j__1] = x[j__1] * cos - y[j__1] * sin;
                ytmp[j__1] = x[j__1] * sin + y[j__1] * cos;
                x[j__1] = xtmp[j__1];
                y[j__1] = ytmp[j__1];
            }
        }
    }
}
/**
 * 1rad
 **/
AbstractRichGraphics.RAD = Math.PI / 180;
//# sourceMappingURL=AbstractRichGraphics.js.map