// *** Environment setup code ***
//var arguments_ = [];
var ENVIRONMENT_IS_NODE = typeof process === 'object';
var ENVIRONMENT_IS_WEB = typeof window === 'object';
var ENVIRONMENT_IS_WORKER = typeof importScripts === 'function';
var ENVIRONMENT_IS_SHELL = !ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_NODE && !ENVIRONMENT_IS_WORKER;
export var print;
export var printErr;
if (ENVIRONMENT_IS_NODE) {
    // Expose functionality in the same simple way that the shells work
    // Note that we pollute the global namespace here, otherwise we break in node
    print = function (x) {
        process['stdout'].write(x + '\n');
    };
    printErr = function (x) {
        process['stderr'].write(x + '\n');
    };
}
else if (ENVIRONMENT_IS_SHELL) {
}
else if (ENVIRONMENT_IS_WEB) {
    print = printErr = function (x) {
        console.log(x);
    };
}
else if (ENVIRONMENT_IS_WORKER) {
}
else {
    throw 'Unknown runtime environment. Where are we?';
}
function globalEval(x) {
    eval.call(null, x);
}
//if (typeof load == 'undefined' && typeof read != 'undefined') {
//  this['load'] = function(f) {
//    globalEval(read(f));
//  };
//}
if (typeof printErr === 'undefined') {
    printErr = function () { };
}
if (typeof print === 'undefined') {
    print = printErr;
}
//# sourceMappingURL=init.js.map