/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;

public final class RuntimeLog {
    private static ArrayList logListeners = new ArrayList(5);
    private static ArrayList queuedMessages = new ArrayList(5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLogListener(ILogListener listener) {
        ArrayList arrayList = logListeners;
        synchronized (arrayList) {
            boolean firstListener = logListeners.size() == 0;
            logListeners.remove(listener);
            logListeners.add(listener);
            if (firstListener) {
                Iterator i = queuedMessages.iterator();
                while (i.hasNext()) {
                    try {
                        IStatus recordedMessage = (IStatus)i.next();
                        listener.logging(recordedMessage, "org.eclipse.core.runtime");
                    }
                    catch (Exception e) {
                        RuntimeLog.handleException(e);
                    }
                    catch (LinkageError e) {
                        RuntimeLog.handleException(e);
                    }
                }
                queuedMessages.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLogListener(ILogListener listener) {
        ArrayList arrayList = logListeners;
        synchronized (arrayList) {
            logListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contains(ILogListener listener) {
        ArrayList arrayList = logListeners;
        synchronized (arrayList) {
            return logListeners.contains(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(IStatus status) {
        ILogListener[] listeners;
        ArrayList arrayList = logListeners;
        synchronized (arrayList) {
            listeners = logListeners.toArray(new ILogListener[logListeners.size()]);
            if (listeners.length == 0) {
                queuedMessages.add(status);
                return;
            }
        }
        for (int i = 0; i < listeners.length; ++i) {
            try {
                listeners[i].logging(status, "org.eclipse.core.runtime");
                continue;
            }
            catch (Exception e) {
                RuntimeLog.handleException(e);
                continue;
            }
            catch (LinkageError e) {
                RuntimeLog.handleException(e);
            }
        }
    }

    private static void handleException(Throwable e) {
        if (!(e instanceof OperationCanceledException)) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEmpty() {
        ArrayList arrayList = logListeners;
        synchronized (arrayList) {
            return logListeners.size() == 0;
        }
    }
}

