/*
 * Decompiled with CFR 0.152.
 */
package nethome5.doc;

import nethome5.doc.DefaultProject;
import nethome5.doc.HistoryManager;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.DefaultOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.runtime.IStatus;

public class DefaultProjectHistoryManager<T extends DefaultProject<T>>
implements HistoryManager<T> {
    private T mProject;
    private ObjectUndoContext mHistoryContext = new ObjectUndoContext((Object)this);
    private IOperationHistory mHistory = new DefaultOperationHistory();

    public DefaultProjectHistoryManager(int histnum) {
        this.mHistory.setLimit((IUndoContext)this.mHistoryContext, histnum);
    }

    @Override
    public void setDocument(T project) {
        this.mProject = project;
    }

    @Override
    public void flushHistory() {
        this.mHistory.dispose((IUndoContext)this.mHistoryContext, true, true, false);
    }

    @Override
    public boolean undo() {
        boolean flag = false;
        try {
            IStatus result = this.mHistory.undo((IUndoContext)this.mHistoryContext, null, null);
            if (!result.isOK()) {
                flag = false;
            } else {
                ((DefaultProject)this.mProject).refreshPresentation();
                flag = true;
            }
        }
        catch (ExecutionException e) {
            flag = false;
        }
        if (flag) {
            ((DefaultProject)this.mProject).setSaved(false);
        }
        return flag;
    }

    @Override
    public boolean redo() {
        boolean flag = false;
        try {
            IStatus result = this.mHistory.redo((IUndoContext)this.mHistoryContext, null, null);
            if (!result.isOK()) {
                flag = false;
            } else {
                ((DefaultProject)this.mProject).refreshPresentation();
                flag = true;
            }
        }
        catch (ExecutionException e) {
            flag = false;
        }
        if (flag) {
            ((DefaultProject)this.mProject).setSaved(false);
        }
        return flag;
    }

    @Override
    public void addHistory(IUndoableOperation op) {
        try {
            op.addContext((IUndoContext)this.mHistoryContext);
            this.mHistory.execute(op, null, null);
            ((DefaultProject)this.mProject).setSaved(false);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasUndo() {
        return this.mHistory.canUndo((IUndoContext)this.mHistoryContext);
    }

    @Override
    public boolean hasRedo() {
        return this.mHistory.canRedo((IUndoContext)this.mHistoryContext);
    }

    @Override
    public void setMaxHistory(int num) {
        this.mHistory.setLimit((IUndoContext)this.mHistoryContext, num);
    }
}

