/*
 * Decompiled with CFR 0.152.
 */
package nethome5.doc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jp.kitec.lib.util.tree.ObjectFolder;
import nethome5.doc.DocumentFactory;
import nethome5.doc.HistoryManager;
import nethome5.doc.Model;
import nethome5.doc.Presentation;
import nethome5.doc.Project;
import nethome5.doc.ProjectEvent;
import nethome5.doc.ProjectListener;
import org.eclipse.core.commands.operations.IUndoableOperation;

public class DefaultProject<T extends DefaultProject<T>>
implements Project {
    protected Model mModel;
    protected Map<Object, Presentation> mPresentations;
    protected HistoryManager<T> mHistoryManager;
    protected boolean mSaved;
    protected ArrayList<ProjectListener> mListeners;

    public DefaultProject(HistoryManager<T> history) {
        this.mHistoryManager = history;
        this.mHistoryManager.setDocument(this);
        this.mPresentations = new HashMap<Object, Presentation>();
        this.mListeners = new ArrayList();
        this.setSaved(true);
    }

    @Override
    public Model getModel() {
        return this.mModel;
    }

    @Override
    public void setModel(Model model) {
        this.mModel = model;
    }

    @Override
    public ObjectFolder save() {
        ObjectFolder of = new ObjectFolder("DATA");
        return of;
    }

    @Override
    public void load(ObjectFolder rootf, DocumentFactory docFactory) {
    }

    @Override
    public Presentation getPresentation(Object key) {
        if (this.mPresentations.containsKey(key)) {
            return this.mPresentations.get(key);
        }
        return null;
    }

    @Override
    public Presentation setPresentation(Object key, Presentation p) {
        return this.mPresentations.put(key, p);
    }

    @Override
    public void refreshPresentation() {
        for (Presentation p : this.mPresentations.values()) {
            p.update(this.mModel);
            p.refreshPresentation();
        }
    }

    @Override
    public void setSaved(boolean changed) {
        this.mSaved = changed;
    }

    @Override
    public boolean isSaved() {
        return this.mSaved;
    }

    @Override
    public void flushHistory() {
        this.mHistoryManager.flushHistory();
    }

    @Override
    public boolean undo() {
        return this.mHistoryManager.undo();
    }

    @Override
    public boolean redo() {
        return this.mHistoryManager.redo();
    }

    @Override
    public void addHistory(IUndoableOperation op) {
        this.mHistoryManager.addHistory(op);
    }

    @Override
    public boolean hasUndo() {
        return this.mHistoryManager.hasUndo();
    }

    @Override
    public boolean hasRedo() {
        return this.mHistoryManager.hasRedo();
    }

    @Override
    public void setMaxHistory(int num) {
        this.mHistoryManager.setMaxHistory(num);
    }

    @Override
    public void addProjectListener(ProjectListener l) {
        if (l == null) {
            return;
        }
        if (this.mListeners.contains(l)) {
            return;
        }
        this.mListeners.add(l);
    }

    @Override
    public void removeProjectListener(ProjectListener l) {
        this.mListeners.remove(l);
    }

    @Override
    public void fireProjectChanged(Object source) {
        ProjectEvent e = new ProjectEvent(source, this);
        int size = this.mListeners.size();
        for (int i = size - 1; i >= 0; --i) {
            this.mListeners.get(i).projectChanged(e);
        }
    }
}

