/*
 * Decompiled with CFR 0.152.
 */
package nethome5.doc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;

public class CopyBuffer {
    protected boolean mCutMode;
    private ArrayList<Object> mCopyBuffer = new ArrayList();

    public void clearBuffer() {
        this.mCopyBuffer.clear();
    }

    public boolean hasCopyBuffer() {
        return !this.mCopyBuffer.isEmpty();
    }

    public boolean isCutMode() {
        return this.mCutMode;
    }

    public boolean addCutBuffer(Object target) {
        if (target != null) {
            this.mCutMode = true;
            if (!this.mCopyBuffer.contains(target)) {
                this.mCopyBuffer.add(target);
            }
            return true;
        }
        return false;
    }

    public boolean addCopyBuffer(Object target) {
        return this.addCopyBuffer(target, true);
    }

    public boolean addCopyBuffer(Object target, boolean serialize) {
        if (target == null) {
            return false;
        }
        Object o = null;
        if (serialize) {
            try {
                ByteArrayOutputStream baus = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baus);
                oos.writeObject(target);
                oos.close();
                baus.close();
                o = baus.toByteArray();
            }
            catch (Exception e) {
                return false;
            }
        } else {
            o = target;
        }
        this.mCutMode = false;
        if (!this.mCopyBuffer.contains(o)) {
            this.mCopyBuffer.add(o);
        }
        return true;
    }

    public List<Object> getCopyElements() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < this.mCopyBuffer.size(); ++i) {
            Object o = this.mCopyBuffer.get(i);
            Object target = null;
            if (o instanceof byte[]) {
                try {
                    ByteArrayInputStream bis = new ByteArrayInputStream((byte[])o);
                    ObjectInputStream ois = new ObjectInputStream(bis);
                    target = ois.readObject();
                }
                catch (Exception e) {
                    target = o;
                }
            } else {
                target = o;
            }
            if (target == null) continue;
            result.add(target);
        }
        return result;
    }
}

