/*
 * Decompiled with CFR 0.152.
 */
package nethome.text;

import java.io.Serializable;
import jp.kitec.lib.kwt.KColor;
import jp.kitec.lib.util.UtilString;
import jp.kitec.lib.util.tree.ObjectFolder;
import jp.kitec.lib.util.tree.ObjectNode;
import nethome.text.ITextFormat;

public class GenericTextFormat
implements ITextFormat,
Serializable {
    private String fontName = "RyuminPro-Light";
    private boolean italic = false;
    private double fontSize = 6.0;
    private boolean underLine = false;
    private KColor textColor = KColor.BLACK;
    private KColor backColor = KColor.WHITE;

    @Override
    public KColor getBackColor() {
        return this.backColor;
    }

    @Override
    public KColor getTextColor() {
        return this.textColor;
    }

    @Override
    public String getFontName() {
        return this.fontName;
    }

    @Override
    public int getFontStyle() {
        if (this.italic) {
            return 2;
        }
        return 0;
    }

    @Override
    public double getFontSize() {
        return this.fontSize;
    }

    @Override
    public boolean isUnderLine() {
        return this.underLine;
    }

    @Override
    public void setBackColor(KColor c) {
        this.backColor = c;
    }

    @Override
    public void setTextColor(KColor c) {
        this.textColor = c;
    }

    @Override
    public void setFontName(String name) {
        this.fontName = name;
    }

    @Override
    public void setFontStyle(int style) {
        this.italic = (2 & style) == 2;
    }

    @Override
    public void setFontSize(double size) {
        this.fontSize = size;
    }

    @Override
    public void setUnderLine(boolean state) {
        this.underLine = state;
    }

    @Override
    public void setFormat(ITextFormat f) {
        if (f == null) {
            return;
        }
        this.setBackColor(f.getBackColor());
        this.setTextColor(f.getTextColor());
        this.setFontName(f.getFontName());
        this.setFontSize(f.getFontSize());
        this.setFontStyle(f.getFontStyle());
        this.setUnderLine(f.isUnderLine());
    }

    @Override
    public boolean isSameTextFormat(ITextFormat tf) {
        if (UtilString.isDiff((String)this.getFontName(), (String)tf.getFontName())) {
            return false;
        }
        if (this.getFontStyle() != tf.getFontStyle()) {
            return false;
        }
        if (Math.abs(this.getFontSize() - tf.getFontSize()) > 0.001) {
            return false;
        }
        if (KColor.isDiff((KColor)this.getTextColor(), (KColor)tf.getTextColor())) {
            return false;
        }
        if (KColor.isDiff((KColor)this.getBackColor(), (KColor)tf.getBackColor())) {
            return false;
        }
        return this.isUnderLine() == tf.isUnderLine();
    }

    public static void readData(ObjectFolder node, GenericTextFormat t) throws Exception {
        if (node == null) {
            return;
        }
        ObjectNode on = node.getNode("textfont");
        if (ObjectNode.isStringObject((ObjectNode)on)) {
            t.fontName = ObjectNode.getNodeString((ObjectNode)on);
        }
        if (ObjectNode.isDoubleObject((ObjectNode)(on = node.getNode("textsize")))) {
            t.fontSize = ObjectNode.getNodeDouble((ObjectNode)on);
        }
        if (ObjectNode.isBoolObject((ObjectNode)(on = node.getNode("underline")))) {
            t.underLine = ObjectNode.getNodeBool((ObjectNode)on);
        }
        if (ObjectNode.isIntObject((ObjectNode)(on = node.getNode("textstyle")))) {
            t.setFontStyle(Integer.valueOf((String)on.getObject()));
        }
        if ((on = node.getNode("textcolor")) != null) {
            t.textColor = KColor.decode((String)ObjectNode.getNodeString((ObjectNode)on));
        }
        if ((on = node.getNode("backcolor")) != null) {
            t.backColor = KColor.decode((String)ObjectNode.getNodeString((ObjectNode)on));
        }
    }

    @Override
    public void save(ObjectFolder savenode) {
        if (savenode == null) {
            return;
        }
        savenode.setName("TEXTFORMAT");
        ObjectFolder.addNodeDouble((ObjectFolder)savenode, (String)"textsize", (double)this.fontSize);
        ObjectFolder.addNodeString((ObjectFolder)savenode, (String)"textfont", (String)this.fontName);
        ObjectFolder.addNodeInt((ObjectFolder)savenode, (String)"textstyle", (int)this.getFontStyle());
        ObjectFolder.addNodeBool((ObjectFolder)savenode, (String)"underline", (boolean)this.underLine);
        if (this.textColor != null) {
            ObjectFolder.addNodeString((ObjectFolder)savenode, (String)"textcolor", (String)this.textColor.encode());
        }
        if (this.backColor != null) {
            ObjectFolder.addNodeString((ObjectFolder)savenode, (String)"backcolor", (String)this.backColor.encode());
        }
    }
}

