/*
 * Decompiled with CFR 0.152.
 */
package nethome.text;

import java.io.Serializable;
import jp.kitec.lib.util.StringUtil;
import jp.kitec.lib.util.tree.ObjectFolder;
import jp.kitec.lib.util.tree.ObjectNode;
import nethome.text.ITextLayout;
import nethome.text.TextLayout;

public class GenericTextLayout
implements ITextLayout,
Serializable {
    private TextLayout.VerDirection vDirectionYoko = TextLayout.VerDirection.TB;
    private TextLayout.HorDirection hDirectionYoko = TextLayout.HorDirection.LR;
    private TextLayout.VerDirection vDirectionTate = TextLayout.VerDirection.TB;
    private TextLayout.HorDirection hDirectionTate = TextLayout.HorDirection.RL;
    protected TextLayout.Alignment lineAlignment = TextLayout.Alignment.TOP;
    protected TextLayout.Alignment charAlignment = TextLayout.Alignment.TOP;
    protected TextLayout.TextDirection textDirection = TextLayout.TextDirection.HOR;
    protected TextLayout.TextLineAutoTurn autoTurn = TextLayout.TextLineAutoTurn.ON;
    protected double marginTop = 1.0;
    protected double marginBot = 1.0;
    protected double marginLeft = 1.0;
    protected double marginRight = 1.0;
    protected double fixLineSpacePoint = 2.0;
    protected boolean autoSpacing = true;
    protected double autoSpaceRatio = 0.6f;

    @Override
    public TextLayout.TextLineAutoTurn getAutoTurn() {
        return this.autoTurn;
    }

    @Override
    public TextLayout.Alignment getCharAlignment() {
        return this.charAlignment;
    }

    @Override
    public TextLayout.HorDirection getHorDirectionTate() {
        return this.hDirectionTate;
    }

    @Override
    public TextLayout.HorDirection getHorDirectionYoko() {
        return this.hDirectionYoko;
    }

    @Override
    public TextLayout.Alignment getLineAlignment() {
        return this.lineAlignment;
    }

    @Override
    public TextLayout.TextDirection getTextDirection() {
        return this.textDirection;
    }

    @Override
    public TextLayout.VerDirection getVertDirectionTate() {
        return this.vDirectionTate;
    }

    @Override
    public TextLayout.VerDirection getVertDirectionYoko() {
        return this.vDirectionYoko;
    }

    @Override
    public void setAutoTurn(TextLayout.TextLineAutoTurn autoTurn) {
        this.autoTurn = autoTurn;
    }

    @Override
    public void setCharAlignment(TextLayout.Alignment charAlignment) {
        this.charAlignment = charAlignment;
    }

    @Override
    public void setHorDirectionTate(TextLayout.HorDirection hDirectionTate) {
        this.hDirectionTate = hDirectionTate;
    }

    @Override
    public void setHorDirectionYoko(TextLayout.HorDirection hDirectionYoko) {
        this.hDirectionYoko = hDirectionYoko;
    }

    @Override
    public void setLayout(ITextLayout layout) {
        if (layout == null) {
            return;
        }
        this.setAutoTurn(layout.getAutoTurn());
        this.setCharAlignment(layout.getCharAlignment());
        this.setHorDirectionTate(layout.getHorDirectionTate());
        this.setHorDirectionYoko(layout.getHorDirectionYoko());
        this.setLineAlignment(layout.getLineAlignment());
        this.setTextDirection(layout.getTextDirection());
        this.setVertDirectionTate(layout.getVertDirectionTate());
        this.setVertDirectionYoko(layout.getVertDirectionYoko());
        this.setMargin(layout.getTopMargin(), layout.getBottomMargin(), layout.getLeftMargin(), layout.getRightMargin());
        this.setAutoLineSpacing(layout.isAutoLineSpacing());
        this.setFixLineSpaceInPoint(layout.getFixLineSpaceInPoint());
        this.setAutoLineSpaceRatio(layout.getAutoLineSpaceRatio());
    }

    @Override
    public void setLineAlignment(TextLayout.Alignment lineAlignment) {
        this.lineAlignment = lineAlignment;
    }

    @Override
    public void setTextDirection(TextLayout.TextDirection textDirection) {
        this.textDirection = textDirection;
    }

    @Override
    public void setVertDirectionTate(TextLayout.VerDirection vDirectionTate) {
        this.vDirectionTate = vDirectionTate;
    }

    @Override
    public void setVertDirectionYoko(TextLayout.VerDirection vDirectionYoko) {
        this.vDirectionYoko = vDirectionYoko;
    }

    @Override
    public void setMargin(double top, double bot, double left, double right) {
        this.marginTop = top;
        this.marginBot = bot;
        this.marginLeft = left;
        this.marginRight = right;
    }

    @Override
    public double getTopMargin() {
        return this.marginTop;
    }

    @Override
    public double getBottomMargin() {
        return this.marginBot;
    }

    @Override
    public double getLeftMargin() {
        return this.marginLeft;
    }

    @Override
    public double getRightMargin() {
        return this.marginRight;
    }

    @Override
    public void loadLayout(ObjectFolder savenode) {
        double[] margin;
        ObjectNode on = savenode.getNode("textDirection");
        if (on != null) {
            this.textDirection = (TextLayout.TextDirection)((Object)this.getEnum(TextLayout.TextDirection.class, on));
        }
        if ((on = savenode.getNode("turn")) != null) {
            this.autoTurn = (TextLayout.TextLineAutoTurn)((Object)this.getEnum(TextLayout.TextLineAutoTurn.class, on));
        }
        if ((on = savenode.getNode("alignChar")) != null) {
            this.charAlignment = (TextLayout.Alignment)((Object)this.getEnum(TextLayout.Alignment.class, on));
        }
        if ((on = savenode.getNode("alignLine")) != null) {
            this.lineAlignment = (TextLayout.Alignment)((Object)this.getEnum(TextLayout.Alignment.class, on));
        }
        if ((on = savenode.getNode("dirHorTate")) != null) {
            this.hDirectionTate = (TextLayout.HorDirection)((Object)this.getEnum(TextLayout.HorDirection.class, on));
        }
        if ((on = savenode.getNode("dirHorYoko")) != null) {
            this.hDirectionYoko = (TextLayout.HorDirection)((Object)this.getEnum(TextLayout.HorDirection.class, on));
        }
        if ((on = savenode.getNode("dirVerTate")) != null) {
            this.vDirectionTate = (TextLayout.VerDirection)((Object)this.getEnum(TextLayout.VerDirection.class, on));
        }
        if ((on = savenode.getNode("dirVerYoko")) != null) {
            this.vDirectionYoko = (TextLayout.VerDirection)((Object)this.getEnum(TextLayout.VerDirection.class, on));
        }
        if ((on = savenode.getNode("margin")) != null && (margin = StringUtil.parseDouble((String)ObjectFolder.getNodeString((ObjectNode)on))) != null && margin.length >= 4) {
            this.marginTop = margin[0];
            this.marginBot = margin[1];
            this.marginLeft = margin[2];
            this.marginRight = margin[3];
        }
        if ((on = savenode.getNode("autoSpacing")) != null) {
            this.autoSpacing = ObjectFolder.getNodeBool((ObjectNode)on);
        }
        if ((on = savenode.getNode("fixLineSpace")) != null) {
            this.fixLineSpacePoint = ObjectFolder.getNodeDouble((ObjectNode)on);
        }
        if ((on = savenode.getNode("autoLineSpaceRatio")) != null) {
            this.autoSpaceRatio = ObjectFolder.getNodeDouble((ObjectNode)on);
        }
        if (savenode.getNode("autoSpacing") == null) {
            this.setAutoLineSpacing(false);
            this.setFixLineSpaceInPoint(1.5);
        }
    }

    @Override
    public void saveLayout(ObjectFolder savenode) {
        ObjectFolder.addNodeString((ObjectFolder)savenode, (String)"textDirection", (String)this.textDirection.name());
        ObjectFolder.addNodeString((ObjectFolder)savenode, (String)"turn", (String)this.autoTurn.name());
        ObjectFolder.addNodeString((ObjectFolder)savenode, (String)"alignChar", (String)this.charAlignment.name());
        ObjectFolder.addNodeString((ObjectFolder)savenode, (String)"alignLine", (String)this.lineAlignment.name());
        ObjectFolder.addNodeString((ObjectFolder)savenode, (String)"dirHorTate", (String)this.hDirectionTate.name());
        ObjectFolder.addNodeString((ObjectFolder)savenode, (String)"dirHorYoko", (String)this.hDirectionYoko.name());
        ObjectFolder.addNodeString((ObjectFolder)savenode, (String)"dirVerTate", (String)this.vDirectionTate.name());
        ObjectFolder.addNodeString((ObjectFolder)savenode, (String)"dirVerYoko", (String)this.vDirectionYoko.name());
        StringBuilder sb = new StringBuilder();
        sb.append(this.marginTop);
        sb.append(",");
        sb.append(this.marginBot);
        sb.append(",");
        sb.append(this.marginLeft);
        sb.append(",");
        sb.append(this.marginRight);
        ObjectFolder.addNodeString((ObjectFolder)savenode, (String)"margin", (String)sb.toString());
        ObjectFolder.addNodeBool((ObjectFolder)savenode, (String)"autoSpacing", (boolean)this.autoSpacing);
        ObjectFolder.addNodeDouble((ObjectFolder)savenode, (String)"fixLineSpace", (double)this.fixLineSpacePoint);
        ObjectFolder.addNodeDouble((ObjectFolder)savenode, (String)"autoLineSpaceRatio", (double)this.autoSpaceRatio);
    }

    private <E extends Enum> E getEnum(Class<? extends Enum> e, ObjectNode on) {
        try {
            return (E)Enum.valueOf(e, ObjectFolder.getNodeString((ObjectNode)on));
        }
        catch (Exception e1) {
            return (E)e.getEnumConstants()[0];
        }
    }

    @Override
    public double getFixLineSpaceInPoint() {
        return this.fixLineSpacePoint;
    }

    @Override
    public boolean isAutoLineSpacing() {
        return this.autoSpacing;
    }

    @Override
    public void setAutoLineSpacing(boolean state) {
        this.autoSpacing = state;
    }

    @Override
    public void setFixLineSpaceInPoint(double point) {
        this.fixLineSpacePoint = point;
    }

    @Override
    public void setAutoLineSpaceRatio(double ratio) {
        this.autoSpaceRatio = ratio;
    }

    @Override
    public double getAutoLineSpaceRatio() {
        return this.autoSpaceRatio;
    }
}

