/*
 * Decompiled with CFR 0.152.
 */
package nethome5.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import jp.kitec.lib.kwt.CursorManager;
import jp.kitec.lib.kwt.IRichGraphics;
import jp.kitec.lib.kwt.KArea;
import jp.kitec.lib.kwt.KCursor;
import jp.kitec.lib.kwt.KDimension;
import jp.kitec.lib.kwt.KFill;
import jp.kitec.lib.kwt.KPopupMenu;
import jp.kitec.lib.kwt.KRichGraphics;
import jp.kitec.lib.kwt.KViewPort;
import jp.kitec.lib.util.AdapterUtils;
import jp.kitec.lib.util.tree.ObjectFolder;
import nethome5.doc.Document;
import nethome5.doc.IDrawable;
import nethome5.doc.Project;
import nethome5.doc.ProjectEvent;
import nethome5.doc.ProjectListener;
import nethome5.presentation.GeometryPresentation;
import nethome5.presentation.PresentationLayer;
import nethome5.presentation.WorkSheet;
import nethome5.presentation.primitive.Geometry;
import nethome5.ui.CanvasBase;
import nethome5.ui.ICanvas2D;

public class Canvas2D
extends CanvasBase
implements ICanvas2D,
MouseListener,
MouseMotionListener,
MouseWheelListener,
ProjectListener {
    protected boolean mDispGrid = true;
    protected KPopupMenu mPopup;
    protected Point mCurrentMouse;
    protected Point mPopUpPos;
    protected boolean mNeedImageUpdate = true;
    protected List<String> mPermanentLayers;
    protected List<String> mTemporaryLayers;
    protected boolean mDispContext = false;
    protected short mDrawMode = 0;

    public Canvas2D() {
        this.setLayout(null);
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.mPopup = new KPopupMenu();
        this.mPopUpPos = new Point(0, 0);
        this.mCurrentMouse = new Point();
        this.setFocusable(true);
        this.mPermanentLayers = new ArrayList<String>();
        this.mTemporaryLayers = new ArrayList<String>();
        this.mPermanentLayers.add("SHEET");
        this.mPermanentLayers.add("MAIN");
        this.mTemporaryLayers.add("SELECT");
        this.mTemporaryLayers.add("TR");
    }

    public void setDocument(Document d) {
        this.mDoc = d;
        this.mAbstCanvas.setViewPort(this.getViewPort());
        this.resetView();
        d.getProject().addProjectListener((ProjectListener)this);
    }

    public Document getDocument() {
        return this.mDoc;
    }

    public Project getProject() {
        return this.mDoc.getProject();
    }

    public List<String> getPermanentLayers() {
        return this.mPermanentLayers;
    }

    public void setPermanentLayers(List<String> permanentLayers) {
        this.mPermanentLayers = permanentLayers;
    }

    public List<String> getTemporaryLayers() {
        return this.mTemporaryLayers;
    }

    public void setTemporaryLayers(List<String> temporaryLayers) {
        this.mTemporaryLayers = temporaryLayers;
    }

    protected GeometryPresentation getPresentation() {
        Project prj = this.getProject();
        if (prj == null) {
            return null;
        }
        return (GeometryPresentation)prj.getPresentation((Object)"Geometry");
    }

    protected PresentationLayer getLayer(String key) {
        GeometryPresentation presentation = this.getPresentation();
        if (presentation == null) {
            return null;
        }
        return presentation.getLayer((Object)key);
    }

    public void setCursor(KCursor c) {
        super.setCursor(CursorManager.getInstance().getCursor(c));
    }

    public void showContext(int x, int y) {
        KPopupMenu pi = this.getPopupMenu();
        this.mPopUpPos.setLocation(x, y);
        if (pi != null) {
            pi.show((Component)this, x, y);
        }
        this.mDispContext = true;
    }

    public KPopupMenu getPopupMenu() {
        return this.mPopup;
    }

    public Point getPopupPos() {
        return this.mPopUpPos;
    }

    public void endContext() {
        this.mDispContext = false;
        this.requestFocus();
    }

    public boolean isShowContext() {
        return this.mDispContext;
    }

    public KDimension getKSize() {
        return new KDimension(this.getSize().width, this.getSize().height);
    }

    public void save(ObjectFolder of) {
    }

    public void load(ObjectFolder of) {
    }

    public void updateView() {
        this.mAbstCanvas.setViewPort(this.getViewPort());
        this.updateImage();
        this.repaint();
    }

    public KViewPort getViewPort() {
        return this.mAbstCanvas.getViewPort();
    }

    public void setZoomAsScale(double f) {
        KViewPort vp = this.mAbstCanvas.getViewPort();
        KDimension size = this.mAbstCanvas.getSize();
        GeometryPresentation gp = this.getPresentation();
        if (vp != null && size != null && gp != null) {
            double module = gp.getWorkSheet().getModule();
            KArea a = gp.getWorkSheet().getArea();
            double defw = a.maxX + module - (a.minX - module);
            double defh = a.maxY + module - (a.minY - module);
            double rw = defw / (double)size.width;
            double rh = defh / (double)size.height;
            double wx = module / 10.0;
            double wy = module / 10.0;
            if (rw > rh) {
                wx = defw * 100.0 / f / 2.0;
            } else {
                wy = defh * 100.0 / f / 2.0;
            }
            this.mAbstCanvas.setView(vp.getCx() - wx, vp.getCy() - wy, vp.getCx() + wx, vp.getCy() + wy);
        }
    }

    public int getZoomRatio() {
        double cp;
        double len;
        double defh;
        double rh;
        KViewPort vp = this.getViewPort();
        if (vp == null) {
            return 0;
        }
        KDimension size = this.mAbstCanvas.getSize();
        if (size == null) {
            return 100;
        }
        GeometryPresentation gp = this.getPresentation();
        if (gp == null) {
            return 0;
        }
        KArea a = gp.getWorkSheet().getArea();
        double module = gp.getWorkSheet().getModule();
        double defw = a.maxX + module - (a.minX - module);
        double rw = defw / (double)size.width;
        if (rw > (rh = (defh = a.maxY + module - (a.minY - module)) / (double)size.height)) {
            double x1 = this.mAbstCanvas.devToRealX(0.0);
            double x2 = this.mAbstCanvas.devToRealX((double)size.width);
            len = x2 - x1;
            cp = defw;
        } else {
            double y1 = this.mAbstCanvas.devToRealY((double)size.height);
            double y2 = this.mAbstCanvas.devToRealY(0.0);
            len = y2 - y1;
            cp = defh;
        }
        return (int)(cp / len * 100.0);
    }

    public WorkSheet getWorkSheet() {
        GeometryPresentation gp = this.getPresentation();
        if (gp == null) {
            return null;
        }
        return gp.getWorkSheet();
    }

    public void resetView() {
        KViewPort vp = this.getViewPort();
        if (vp != null) {
            GeometryPresentation gp = this.getPresentation();
            if (gp == null) {
                return;
            }
            double module = gp.getWorkSheet().getModule();
            KArea a = gp.getWorkSheet().getArea();
            vp.resetViewPort(a.minX, a.minY, a.maxX, a.maxY, module);
            this.mAbstCanvas.setView(vp.getX1(), vp.getY1(), vp.getX2(), vp.getY2(), this.mAbstCanvas.getSize());
            this.updateImage();
            this.repaint();
        }
    }

    public void setDispGrid(boolean b) {
        this.mDispGrid = b;
        this.updateImage();
        this.repaint();
    }

    public boolean isDispGrid() {
        return this.mDispGrid;
    }

    public void setDrawMode(short b) {
        this.mDrawMode = b;
    }

    public short getDrawMode() {
        return this.mDrawMode;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.mDoc == null) {
            return;
        }
        this.createOffGraphics();
        if (this.mNeedImageUpdate || this.isChangeCanvasSize()) {
            this.updateImageBuffer();
            this.mNeedImageUpdate = false;
        }
        this.mAbstCanvas.updateViewScale(this.mAbstCanvas.getSize());
        this.drawPlan();
        this.mAbstCanvas.setGC(this.mOffGraphics);
        if (this.mCommandDispatcher.getActiveMaskCommand() != null) {
            this.mCommandDispatcher.getActiveMaskCommand().drawCommand((IRichGraphics)this.mAbstCanvas);
        }
        if (this.mCommandDispatcher.getMouseCommand() != null) {
            this.mCommandDispatcher.getMouseCommand().drawCommand((IRichGraphics)this.mAbstCanvas);
        }
        super.paintComponent(this.mOffGraphics);
        this.mAbstCanvas.setGC(null);
        g.drawImage(this.mOffImage, 0, 0, this);
    }

    protected void drawLayer(PresentationLayer l, IRichGraphics rg) {
        for (Geometry g : l.getPrims()) {
            IDrawable d = (IDrawable)AdapterUtils.getAdapter((Object)g, IDrawable.class);
            if (d == null) continue;
            d.draw(rg);
        }
    }

    protected void drawPlan() {
        this.mAbstCanvas.setGC(this.mOffGraphics);
        this.paintCurrentBuffer(this.mAbstCanvas);
        for (String key : this.mTemporaryLayers) {
            PresentationLayer sl = this.getLayer(key);
            if (sl == null || !sl.isVisible()) continue;
            this.drawLayer(sl, (IRichGraphics)this.mAbstCanvas);
        }
        this.mAbstCanvas.setGC(null);
    }

    protected void createOffGraphics() {
        this.mAbstCanvas.setSize(this.getSize().width, this.getSize().height);
        KDimension size = this.mAbstCanvas.getSize();
        if (this.mOffImage == null || this.mOffImage.getWidth(this) != size.width || this.mOffImage.getHeight(this) != size.height) {
            if (this.mOffGraphics != null) {
                this.mOffGraphics.dispose();
            }
            if (this.mOffImage != null) {
                this.mOffImage.flush();
            }
            this.mOffImage = this.createImage(size.width, size.height);
            this.mOffGraphics = this.mOffImage.getGraphics();
        }
    }

    @Override
    public void updateImage() {
        this.mNeedImageUpdate = true;
    }

    protected synchronized void updateImageBuffer() {
        KDimension size = this.mAbstCanvas.getSize();
        if (size == null) {
            return;
        }
        this.mAbstCanvas.updateViewScale(size);
        this.ensureBufferImage();
        this.mAbstCanvas.setGC(this.mBufferGraphics);
        this.mAbstCanvas.setColor((KFill)this.mBackColor);
        double x1 = this.mAbstCanvas.devToRealX(-1.0);
        double y1 = this.mAbstCanvas.devToRealY(-1.0);
        double x2 = this.mAbstCanvas.devToRealX((double)(size.width + 2));
        double y2 = this.mAbstCanvas.devToRealY((double)(size.height + 2));
        this.mAbstCanvas.drawFillRect(x1, y1, x2, y2, null);
        GeometryPresentation presentation = this.getPresentation();
        if (presentation != null) {
            presentation.setSize(size);
            presentation.refreshPresentation();
            for (String key : this.mPermanentLayers) {
                PresentationLayer sl = presentation.getLayer((Object)key);
                if (sl == null || !this.mDispGrid || !sl.isVisible()) continue;
                this.drawLayer(sl, (IRichGraphics)this.mAbstCanvas);
            }
        }
        this.mAbstCanvas.setGC(null);
    }

    public void paintCurrentBuffer(KRichGraphics g) {
        g.drawBufferImage(this.mBufferImage);
    }

    public Point getCurrentMousePos() {
        return this.mCurrentMouse;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getUnitsToScroll() < 0) {
            this.mCommandDispatcher.mouseWheelUp(e.getX(), e.getY(), e.getModifiers());
        } else {
            this.mCommandDispatcher.mouseWheelDown(e.getX(), e.getY(), e.getModifiers());
        }
    }

    public void updateCurrentMousePos(int x, int y, int modifiers) {
        this.mCurrentMouse.x = x;
        this.mCurrentMouse.y = y;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.requestFocusInWindow();
        if (this.mCommandDispatcher.mouseClicked(e.getX(), e.getY(), e.getModifiers())) {
            e.consume();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.mCommandDispatcher.mousePressed(e.getX(), e.getY(), e.getModifiers())) {
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.mCommandDispatcher.mouseReleased(e.getX(), e.getY(), e.getModifiers())) {
            e.consume();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.mCommandDispatcher.mouseDragged(e.getX(), e.getY(), e.getModifiers())) {
            e.consume();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.mCommandDispatcher.mouseMoved(e.getX(), e.getY(), e.getModifiers())) {
            e.consume();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.mCommandDispatcher.mouseEntered(e.getX(), e.getY(), e.getModifiers())) {
            e.consume();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.mCommandDispatcher.mouseExited(e.getX(), e.getY(), e.getModifiers())) {
            e.consume();
        }
    }

    public void keyPress(KeyEvent e) {
        if (this.mCommandDispatcher.keyPress(e.getKeyCode(), e.getModifiers())) {
            e.consume();
        }
    }

    public void keyRelease(KeyEvent e) {
        if (this.mCommandDispatcher.keyRelease(e.getKeyCode(), e.getModifiers())) {
            e.consume();
        }
    }

    public void projectChanged(ProjectEvent e) {
        this.updateImage();
        this.repaint();
    }
}

