/*
 * Decompiled with CFR 0.152.
 */
package nethome.ui.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import jp.kitec.kwt.KCursor;
import jp.kitec.kwt.KCursorManager;
import jp.kitec.kwt.KToolkit;
import jp.kitec.lib.gui.event.CallBackListener;
import nethome.ui.gui.NethomeDialogComponent;

public class BasicDialog
extends Dialog
implements NethomeDialogComponent {
    protected int mCloseState = 1;
    private int mX;
    private int mY;
    private CallBackListener mCloseCallBack;
    private Component mInitFocus = null;

    public BasicDialog(Frame f, String name, boolean b) {
        super(f, name, b);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                BasicDialog.this.setVisible(false);
            }

            @Override
            public void windowOpened(WindowEvent e) {
                if (BasicDialog.this.mInitFocus != null) {
                    BasicDialog.this.mInitFocus.requestFocus();
                }
            }
        });
    }

    public void setInitFocus(Component c) {
        this.mInitFocus = c;
    }

    public void addCloseCallBack(CallBackListener cb) {
        this.mCloseCallBack = cb;
    }

    public void waitMode(boolean wait) {
        if (wait) {
            this.setCursor(KCursorManager.getCursor((KCursor)KCursor.CURSOR_WAIT));
        } else {
            this.setCursor(KCursorManager.getCursor((KCursor)KCursor.CURSOR_DEF));
        }
    }

    protected void appendKeyListener(Object o, KeyListener l) {
        if (o instanceof Container) {
            Container c = (Container)o;
            c.addKeyListener(l);
            if (c.getComponentCount() != 0) {
                Component[] cc;
                Component[] componentArray = cc = c.getComponents();
                int n = cc.length;
                int n2 = 0;
                while (n2 < n) {
                    Component element = componentArray[n2];
                    this.appendKeyListener(element, l);
                    ++n2;
                }
            }
        } else if (o instanceof Component) {
            ((Component)o).addKeyListener(l);
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (!b && this.mCloseCallBack != null) {
            this.mCloseCallBack.actionCallBack((Object)this);
        }
        super.setVisible(b);
    }

    public void setVisible(boolean b, boolean centering) {
        if (b && centering) {
            Point p = ((Frame)this.getParent()).getLocation();
            Dimension d = ((Frame)this.getParent()).getSize();
            this.mX = p.x + (d.width - this.getSize().width) / 2;
            this.mY = p.y + (d.height - this.getSize().height) / 2;
            this.setLocation(this.mX, this.mY);
        }
        this.setVisible(b);
    }

    public void setVisible(boolean b, boolean centering, Container c) {
        if (b && centering) {
            Point p1 = ((Frame)this.getParent()).getLocationOnScreen();
            Point p = c.getLocationOnScreen();
            this.mX = p.x - this.getSize().width;
            if (this.mX < 0) {
                this.mX = 0;
            }
            this.mY = (p1.y + p.y) / 2;
            this.setLocation(this.mX, this.mY);
        }
        this.setVisible(b);
    }

    public void setVisible(boolean b, Container c) {
        if (b) {
            Point p = c.getLocationOnScreen();
            p.x -= this.getSize().width / 2;
            p.y -= this.getSize().height / 2;
            p.x = p.x < 0 ? 0 : p.x;
            p.y = p.y < 0 ? 0 : p.y;
            this.setLocation(p);
            this.setVisible(true);
        } else {
            this.setVisible(b);
        }
    }

    public void setVisible(boolean b, Container f, int i) {
        int y;
        int x;
        Dimension scr = KToolkit.getScreenSize();
        Point p = f.getLocationOnScreen();
        Dimension d = f.getSize();
        if (i == 0) {
            x = p.x + (d.width - this.getSize().width) / 2;
            y = p.y + (d.height - this.getSize().height) / 2;
        } else if (i == 1) {
            x = p.x + d.width - this.getSize().width;
            y = p.y;
        } else if (i == 2) {
            x = p.x;
            y = p.y;
        } else if (i == 3) {
            x = p.x;
            y = p.y + d.height - this.getSize().height;
        } else {
            x = p.x + d.width - this.getSize().width;
            y = p.y + d.height - this.getSize().height;
        }
        if (x > scr.width || x + this.getSize().width > scr.width) {
            x = scr.width - this.getSize().width;
        }
        if (x < 0) {
            x = 0;
        }
        if (y > scr.height || y + this.getSize().height > scr.height) {
            y = scr.height - this.getSize().height;
        }
        if (y < 0) {
            y = 0;
        }
        int xx = x > 0 ? x : 0;
        int yy = y > 0 ? y : 0;
        this.setLocation(xx, yy);
        super.setVisible(b);
    }

    public int getCloseState() {
        return this.mCloseState;
    }

    @Override
    public void enableExecButton(boolean b) {
    }

    @Override
    public void actionCancel() {
    }

    @Override
    public void actionOK() {
    }
}

