/*
 * Decompiled with CFR 0.152.
 */
package nethome.ui.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JPanel;
import jp.kitec.kwt.KToolkit;
import nethome.NethomeLookAndFeel;
import nethome.ui.gui.NethomeCommonDialogControl;

public class NethomeCommonDialog
extends JDialog {
    public static final int POS_CENTER = 0;
    public static final int POS_NE = 1;
    public static final int POS_NW = 2;
    public static final int POS_SW = 3;
    public static final int POS_SE = 4;
    protected boolean mChanged;
    protected Container mPanel;
    protected Window mParentFrame;
    protected NethomeCommonDialogControl mControl;
    protected Object mButtonExec;
    protected Object mButtonCancel;

    public NethomeCommonDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        this.init(owner);
    }

    public NethomeCommonDialog(Dialog owner, String title, boolean modal) {
        super(owner, title, modal);
        this.init(owner);
    }

    private void init(Window f) {
        this.mParentFrame = f;
        this.mChanged = false;
        this.setLayout(new BorderLayout());
        this.mControl = new NethomeCommonDialogControl();
        this.mPanel = new JPanel(new BorderLayout(NethomeLookAndFeel.DIALOG_INSET_LEN, NethomeLookAndFeel.DIALOG_INSET_LEN));
        ((JPanel)this.mPanel).setBorder(BorderFactory.createLineBorder(NethomeLookAndFeel.DIALOG_AROUND_COLOR, NethomeLookAndFeel.DIALOG_INSET_LEN));
        this.mPanel.setBackground(NethomeLookAndFeel.DIALOG_AROUND_COLOR);
        this.add((Component)this.mPanel, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                NethomeCommonDialog.this.initRequest();
            }
        });
    }

    protected void initRequest() {
        if (this.mControl != null) {
            this.mControl.requestFocus();
        }
    }

    public void setUI(Component innercomp) {
        if (innercomp != null) {
            this.mPanel.add(innercomp, "Center");
            innercomp.setBackground(NethomeLookAndFeel.DIALOG_INNER_COLOR);
        }
        if (this.mControl.getComponentCount() != 0) {
            this.mPanel.add((Component)this.mControl, "South");
        }
        this.pack();
    }

    public boolean isChanged() {
        return this.mChanged;
    }

    public void setVisible(boolean b, Component f, int i) {
        int y;
        int x;
        Dimension scr = KToolkit.getScreenSize();
        Point p = f.getLocationOnScreen();
        Dimension d = new Dimension(f.getWidth(), f.getHeight());
        if (i == 0) {
            x = p.x + (d.width - this.getSize().width) / 2;
            y = p.y + (d.height - this.getSize().height) / 2;
        } else if (i == 1) {
            x = p.x + d.width - this.getSize().width;
            y = p.y;
        } else if (i == 2) {
            x = p.x;
            y = p.y;
        } else if (i == 3) {
            x = p.x;
            y = p.y + d.height - this.getSize().height;
        } else {
            x = p.x + d.width - this.getSize().width;
            y = p.y + d.height - this.getSize().height;
        }
        if (x > scr.width || x + this.getSize().width > scr.width) {
            x = scr.width - this.getSize().width;
        }
        if (x < 0) {
            x = 0;
        }
        if (y > scr.height || y + this.getSize().height > scr.height) {
            y = scr.height - this.getSize().height;
        }
        if (y < 0) {
            y = 0;
        }
        int xx = x > 0 ? x : 0;
        int yy = y > 0 ? y : 0;
        this.setLocation(xx, yy);
        super.setVisible(b);
    }
}

