/*
 * Decompiled with CFR 0.152.
 */
package nethome5.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import jp.kitec.lib.kwt.CursorManager;
import jp.kitec.lib.kwt.IRichGraphics;
import jp.kitec.lib.kwt.KArea;
import jp.kitec.lib.kwt.KCursor;
import jp.kitec.lib.kwt.KDimension;
import jp.kitec.lib.kwt.KFill;
import jp.kitec.lib.kwt.KPopupMenu;
import jp.kitec.lib.kwt.KRichGraphics;
import jp.kitec.lib.kwt.KViewPort;
import jp.kitec.lib.util.tree.ObjectFolder;
import nethome5.doc.Document;
import nethome5.doc.DocumentEvent;
import nethome5.doc.DocumentListener;
import nethome5.doc.Project;
import nethome5.geom.WorkSheet;
import nethome5.ui.CanvasBase;
import nethome5.ui.CanvasDrawer;
import nethome5.ui.DefaultCanvasDrawer;
import nethome5.ui.DefaultDrawData;
import nethome5.ui.ICanvas2D;

public class Canvas2D
extends CanvasBase
implements ICanvas2D,
MouseListener,
MouseMotionListener,
MouseWheelListener,
DocumentListener {
    protected boolean mDispGrid = true;
    protected KPopupMenu mPopup;
    protected Point mCurrentMouse;
    protected Point mPopUpPos;
    protected boolean mNeedImageUpdate = true;
    protected CanvasDrawer mDrawer;
    protected DefaultDrawData mDrawData;
    protected boolean mDispContext = false;
    protected short mDrawMode = 0;

    public Canvas2D() {
        this.setLayout(null);
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.mPopup = new KPopupMenu();
        this.mPopUpPos = new Point(0, 0);
        this.mCurrentMouse = new Point();
        this.setFocusable(true);
        this.mDrawer = new DefaultCanvasDrawer();
        this.mDrawData = new DefaultDrawData();
    }

    public void setDocument(Document d) {
        this.mDoc = d;
        this.mAbstCanvas.setViewPort(this.getViewPort());
        this.resetView();
        d.addDocumentListener((DocumentListener)this);
    }

    public Document getDocument() {
        return this.mDoc;
    }

    public Project getProject() {
        return this.mDoc.getProject();
    }

    public void setCursor(KCursor c) {
        super.setCursor(CursorManager.getInstance().getCursor(c));
    }

    public void showContext(int x, int y) {
        KPopupMenu pi = this.getPopupMenu();
        this.mPopUpPos.setLocation(x, y);
        if (pi != null) {
            pi.show((Component)this, x, y);
        }
        this.mDispContext = true;
    }

    public KPopupMenu getPopupMenu() {
        return this.mPopup;
    }

    public Point getPopupPos() {
        return this.mPopUpPos;
    }

    public void endContext() {
        this.mDispContext = false;
        this.requestFocus();
    }

    public boolean isShowContext() {
        return this.mDispContext;
    }

    public KDimension getKSize() {
        return new KDimension(this.getSize().width, this.getSize().height);
    }

    public void save(ObjectFolder of) {
    }

    public void load(ObjectFolder of) {
    }

    public void updateView() {
        this.mAbstCanvas.setViewPort(this.getViewPort());
        this.updateImage();
        this.repaint();
    }

    public KViewPort getViewPort() {
        return this.mAbstCanvas.getViewPort();
    }

    public void setZoomAsScale(double f) {
        Project prj = this.mDoc.getProject();
        KViewPort vp = this.mAbstCanvas.getViewPort();
        KDimension size = this.mAbstCanvas.getSize();
        if (vp != null && size != null) {
            double module = prj.getCurrentLayer().getWorkSheet().getModule();
            KArea a = prj.getCurrentLayer().getWorkSheet().getArea();
            double defw = a.maxX + module - (a.minX - module);
            double defh = a.maxY + module - (a.minY - module);
            double rw = defw / (double)size.width;
            double rh = defh / (double)size.height;
            double wx = module / 10.0;
            double wy = module / 10.0;
            if (rw > rh) {
                wx = defw * 100.0 / f / 2.0;
            } else {
                wy = defh * 100.0 / f / 2.0;
            }
            this.mAbstCanvas.setView(vp.getCx() - wx, vp.getCy() - wy, vp.getCx() + wx, vp.getCy() + wy);
        }
    }

    public int getZoomRatio() {
        double cp;
        double len;
        double defh;
        double rh;
        KViewPort vp = this.getViewPort();
        if (vp == null) {
            return 0;
        }
        Project prj = this.mDoc.getProject();
        KDimension size = this.mAbstCanvas.getSize();
        if (size == null) {
            return 100;
        }
        KArea a = prj.getCurrentLayer().getWorkSheet().getArea();
        double module = prj.getCurrentLayer().getWorkSheet().getModule();
        double defw = a.maxX + module - (a.minX - module);
        double rw = defw / (double)size.width;
        if (rw > (rh = (defh = a.maxY + module - (a.minY - module)) / (double)size.height)) {
            double x1 = this.mAbstCanvas.devToRealX(0.0);
            double x2 = this.mAbstCanvas.devToRealX((double)size.width);
            len = x2 - x1;
            cp = defw;
        } else {
            double y1 = this.mAbstCanvas.devToRealY((double)size.height);
            double y2 = this.mAbstCanvas.devToRealY(0.0);
            len = y2 - y1;
            cp = defh;
        }
        return (int)(cp / len * 100.0);
    }

    public WorkSheet getWorkSheet() {
        Project prj = this.mDoc.getProject();
        if (prj != null) {
            return prj.getCurrentLayer().getWorkSheet();
        }
        return null;
    }

    public void resetView() {
        KViewPort vp = this.getViewPort();
        if (vp != null) {
            Project prj = this.mDoc.getProject();
            double module = prj.getCurrentLayer().getWorkSheet().getModule();
            KArea a = prj.getCurrentLayer().getWorkSheet().getArea();
            vp.resetViewPort(a.minX, a.minY, a.maxX, a.maxY, module);
            this.mAbstCanvas.setView(vp.getX1(), vp.getY1(), vp.getX2(), vp.getY2(), this.mAbstCanvas.getSize());
            this.updateImage();
            this.repaint();
        }
    }

    public void setDispGrid(boolean b) {
        this.mDispGrid = b;
        this.updateImage();
        this.repaint();
    }

    public boolean isDispGrid() {
        return this.mDispGrid;
    }

    public void setDrawMode(short b) {
        this.mDrawMode = b;
    }

    public short getDrawMode() {
        return this.mDrawMode;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.mDoc == null) {
            return;
        }
        this.createOffGraphics();
        if (this.mNeedImageUpdate || this.isChangeCanvasSize()) {
            this.updateImageBuffer();
            this.mNeedImageUpdate = false;
        }
        this.mAbstCanvas.updateViewScale(this.mAbstCanvas.getSize());
        this.drawPlan();
        this.mAbstCanvas.setGC(this.mOffGraphics);
        if (this.mCommandDispatcher.getActiveMaskCommand() != null) {
            this.mCommandDispatcher.getActiveMaskCommand().drawCommand((IRichGraphics)this.mAbstCanvas);
        }
        if (this.mCommandDispatcher.getMouseCommand() != null) {
            this.mCommandDispatcher.getMouseCommand().drawCommand((IRichGraphics)this.mAbstCanvas);
        }
        super.paintComponent(this.mOffGraphics);
        this.mAbstCanvas.setGC(null);
        g.drawImage(this.mOffImage, 0, 0, this);
    }

    protected void drawPlan() {
        if (this.isChangeCanvasSize()) {
            this.updateImage();
        }
        this.mAbstCanvas.setGC(this.mOffGraphics);
        this.paintCurrentBuffer(this.mAbstCanvas);
        this.mDrawer.drawDynamic((Object)this.mDrawData, (IRichGraphics)this.mAbstCanvas);
        this.mAbstCanvas.setGC(null);
    }

    protected void createOffGraphics() {
        this.mAbstCanvas.setSize(this.getSize().width, this.getSize().height);
        KDimension size = this.mAbstCanvas.getSize();
        if (this.mOffImage == null || this.mOffImage.getWidth(this) != size.width || this.mOffImage.getHeight(this) != size.height) {
            if (this.mOffGraphics != null) {
                this.mOffGraphics.dispose();
            }
            if (this.mOffImage != null) {
                this.mOffImage.flush();
            }
            this.mOffImage = this.createImage(size.width, size.height);
            this.mOffGraphics = this.mOffImage.getGraphics();
        }
    }

    @Override
    public void updateImage() {
        this.mNeedImageUpdate = true;
    }

    protected synchronized void updateImageBuffer() {
        KDimension size = this.mAbstCanvas.getSize();
        if (size == null) {
            return;
        }
        this.mAbstCanvas.updateViewScale(size);
        if (this.mBufferImage != null && this.mBufferGraphics != null) {
            int w = this.mBufferImage.getWidth(this);
            int h = this.mBufferImage.getHeight(this);
            if (size.width != w || size.height != h) {
                this.mBufferImage.flush();
                this.mBufferGraphics.dispose();
                this.mBufferGraphics = null;
                this.mBufferImage = null;
            }
        }
        if (this.mBufferImage == null) {
            this.mBufferImage = this.createImage(size.width, size.height);
            this.mBufferGraphics = this.mBufferImage.getGraphics();
        }
        this.mAbstCanvas.setGC(this.mBufferGraphics);
        this.mAbstCanvas.setColor((KFill)this.mBackColor);
        double x1 = this.mAbstCanvas.devToRealX(-1.0);
        double y1 = this.mAbstCanvas.devToRealY(-1.0);
        double x2 = this.mAbstCanvas.devToRealX((double)(size.width + 2));
        double y2 = this.mAbstCanvas.devToRealY((double)(size.height + 2));
        this.mAbstCanvas.drawFillRect(x1, y1, x2, y2, null);
        this.mDrawData.setDispGrid(this.mDispGrid);
        this.mDrawData.setDrawMode(this.mDrawMode);
        this.mDrawer.draw((Object)this.mDrawData, (IRichGraphics)this.mAbstCanvas);
        this.mAbstCanvas.setGC(null);
    }

    public void paintCurrentBuffer(KRichGraphics g) {
        g.drawBufferImage(this.mBufferImage);
    }

    public Point getCurrentMousePos() {
        return this.mCurrentMouse;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getUnitsToScroll() < 0) {
            this.mCommandDispatcher.mouseWheelUp(e.getX(), e.getY(), e.getModifiers());
        } else {
            this.mCommandDispatcher.mouseWheelDown(e.getX(), e.getY(), e.getModifiers());
        }
    }

    public void updateCurrentMousePos(int x, int y, int modifiers) {
        this.mCurrentMouse.x = x;
        this.mCurrentMouse.y = y;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.requestFocusInWindow();
        this.mCommandDispatcher.mouseClicked(e.getX(), e.getY(), e.getModifiers());
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mCommandDispatcher.mousePressed(e.getX(), e.getY(), e.getModifiers());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mCommandDispatcher.mouseReleased(e.getX(), e.getY(), e.getModifiers());
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mCommandDispatcher.mouseDragged(e.getX(), e.getY(), e.getModifiers());
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mCommandDispatcher.mouseMoved(e.getX(), e.getY(), e.getModifiers());
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mCommandDispatcher.mouseEntered(e.getX(), e.getY(), e.getModifiers());
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mCommandDispatcher.mouseExited(e.getX(), e.getY(), e.getModifiers());
    }

    public void keyPress(KeyEvent e) {
        this.mCommandDispatcher.keyPress(e.getKeyCode(), e.getModifiers());
    }

    public void keyRelease(KeyEvent e) {
        this.mCommandDispatcher.keyRelease(e.getKeyCode(), e.getModifiers());
    }

    public void documentChanged(DocumentEvent e) {
        this.updateImage();
        this.repaint();
    }
}

