/*
 * Decompiled with CFR 0.152.
 */
package nethome.ui.command;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jp.kitec.lib.kwt.IRichGraphics;
import jp.kitec.lib.kwt.KColor;
import jp.kitec.lib.kwt.KFill;
import nethome.geom.util.ToolMath;
import nethome.ui.Canvas2D;
import nethome.ui.ICanvas2D;
import nethome.ui.MainComponent;
import nethome.ui.command.Command;
import nethome.ui.command.CommandUtil;

public class ComViewZoomArea
extends Command
implements ActionListener {
    private int mStartX;
    private int mStartY;
    private int mMouseX;
    private int mMouseY;
    double x1;
    double y1;
    double x2;
    double y2;
    private boolean mSet = false;

    public void play() {
        CommandUtil.setActiveUI(this.mComponent, true);
        MainComponent mc = MainComponent.getInstance();
        Canvas2D can = mc.getActiveCanvas();
        if (can == null) {
            return;
        }
        can.setCursor(ICanvas2D.MOUSE_CROSS);
    }

    private void set() {
        this.play();
        MainComponent mc = MainComponent.getInstance();
        Canvas2D can = mc.getActiveCanvas();
        if (can == null) {
            return;
        }
        this.mSet = false;
        can.repaint();
    }

    public void end() {
        CommandUtil.setActiveUI(this.mComponent, false);
        this.y2 = 0.0;
        this.x2 = 0.0;
        this.y1 = 0.0;
        this.x1 = 0.0;
        MainComponent mc = MainComponent.getInstance();
        Canvas2D can = mc.getActiveCanvas();
        if (can == null) {
            return;
        }
        can.setCursor(ICanvas2D.MOUSE_DEF);
    }

    public void mouseMove(int x, int y, int mod) {
    }

    public void mousePress(int x, int y, int mod) {
        MainComponent mc = MainComponent.getInstance();
        Canvas2D can = mc.getActiveCanvas();
        if (can == null) {
            return;
        }
        this.mSet = true;
        this.mStartX = this.mMouseX = x;
        this.mStartY = this.mMouseY = y;
        this.x1 = this.x2 = can.mAbstCanvas.devToRealX((double)this.mStartX);
        this.y1 = this.y2 = can.mAbstCanvas.devToRealY((double)this.mStartY);
    }

    public void mouseDrag(int x, int y, int mod) {
        MainComponent mc = MainComponent.getInstance();
        Canvas2D can = mc.getActiveCanvas();
        if (can == null) {
            return;
        }
        this.mMouseX = x;
        this.mMouseY = y;
        this.x2 = can.mAbstCanvas.devToRealX((double)this.mMouseX);
        this.y2 = can.mAbstCanvas.devToRealY((double)this.mMouseY);
        can.repaint();
    }

    public void mouseRelease(int x, int y, int mod) {
        this.gogo();
        this.mSet = false;
    }

    private void gogo() {
        MainComponent mc = MainComponent.getInstance();
        Canvas2D can = mc.getActiveCanvas();
        if (can == null) {
            return;
        }
        if (Math.abs(this.mMouseX - this.mStartX) > 10 && Math.abs(this.mMouseY - this.mStartY) > 10) {
            can.mAbstCanvas.setView(this.x1, this.y1, this.x2, this.y2);
            can.updateImage();
            can.repaint();
            can.updateViewControl();
            mc.updateUserInterface();
        }
        if (!this.mContinue) {
            can.setMouseCommand(null);
        }
        can.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MainComponent mc = MainComponent.getInstance();
        Canvas2D can = mc.getActiveCanvas();
        if (can == null) {
            return;
        }
        can.setMouseCommand(this);
        this.set();
    }

    public void drawCommand(IRichGraphics d) {
        if (this.mSet) {
            d.setColor((KFill)KColor.RED);
            if (!ToolMath.isSame2D((double)this.x1, (double)this.y1, (double)this.x2, (double)this.y2)) {
                d.drawRect(this.x1, this.y1, this.x2, this.y2, IRichGraphics.LINE_1);
            }
        }
    }
}

