/*
 * Decompiled with CFR 0.152.
 */
package nethome.ui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.JPanel;
import jp.kitec.lib.gui.event.AccelKey;
import jp.kitec.lib.io.FileSystem;
import jp.kitec.lib.kwt.CursorManager;
import jp.kitec.lib.kwt.KCursor;
import jp.kitec.lib.kwt.util.ImageTool;
import jp.kitec.richui.TipsMessage;
import nethome.NethomeLookAndFeel;
import nethome.UserInfo;
import nethome.doc.CopyBuffer;
import nethome.doc.Document;
import nethome.doc.Project;
import nethome.lib.ObjectLibrary;
import nethome.ui.Canvas2D;
import nethome.ui.CommandManager;
import nethome.ui.GuiCreator;
import nethome.ui.ICanvas2D;
import nethome.ui.MainApplication;
import nethome.ui.NethomeRuntime;
import nethome.ui.NoDefaultKeyListener;
import nethome.ui.ProjectList;
import nethome.ui.command.Command;
import nethome.ui.gui.NethomeDialog;
import nethome.ui.gui.NethomeDialogInnerComponent;
import nethome.ui.gui.WindowContainer;
import nethome.ui.gui.WindowSystemClient;

public class MainComponent
extends JPanel
implements KeyListener {
    private static final long serialVersionUID = 1L;
    private static MainComponent mMc = null;
    private MainApplication mManApp;
    private TipsMessage mStatusBar;
    private WindowContainer mWindowContainer;
    private GuiCreator mGuiCreator;
    private ProjectList mProjectList;
    private UserInfo mUserInfo;
    private ImageTool mImageTool;
    private CopyBuffer mCopyBuffer;
    private CardLayout mCardLayout;

    public static MainComponent createInstance(MainApplication app) {
        mMc = new MainComponent(app);
        return mMc;
    }

    public static void clearInstance() {
        if (mMc != null) {
            mMc.removeAll();
        }
        mMc = null;
    }

    public static MainComponent getInstance() {
        return mMc;
    }

    private MainComponent(MainApplication app) {
        mMc = this;
        this.mManApp = app;
        this.mUserInfo = new UserInfo();
        this.mCopyBuffer = new CopyBuffer();
        MainComponent.mMc.mCardLayout = new CardLayout();
        this.setLayout(MainComponent.mMc.mCardLayout);
    }

    public void init(GuiCreator gc, WindowContainer wc, String titleImageName) {
        this.mImageTool = new ImageTool(this.mManApp.getImageObserver());
        this.mGuiCreator = gc;
        this.mWindowContainer = wc;
        this.mProjectList = new ProjectList(this.mWindowContainer);
        if (this.mGuiCreator == null) {
            return;
        }
        this.mGuiCreator.createInterface(this, this.mWindowContainer, CommandManager.getInstance().getCommandCollection(), titleImageName);
        this.appendKeyListener(this);
    }

    public void clearCurrentProject() {
        Canvas2D can = this.getActiveCanvas();
        if (can != null) {
            Project prj = can.getProject();
            prj.documentRefresh();
        }
    }

    public Document getActiveDocument() {
        Canvas2D can = this.getActiveCanvas();
        if (can == null) {
            return null;
        }
        return can.getDocument();
    }

    public Canvas2D getActiveCanvas() {
        WindowSystemClient c = this.mWindowContainer.getActiveClient();
        if (c != null) {
            return (Canvas2D)c.getCanvas();
        }
        return null;
    }

    public void setActiveCanvas(Canvas2D can) {
        WindowSystemClient newactive = null;
        newactive = this.mProjectList.setActiveProject((ICanvas2D)can);
        if (newactive != null) {
            this.mWindowContainer.update(newactive, false);
            this.updateUserInterface();
        }
    }

    public Project getActiveProject() {
        Canvas2D can = this.getActiveCanvas();
        if (can == null) {
            return null;
        }
        Project prj = can.getProject();
        return prj;
    }

    public void registerLibrary(String key, ObjectLibrary lib) {
        NethomeRuntime.getInstance().registerLibrary(key, lib);
    }

    public ObjectLibrary getLibrary(String key) {
        return NethomeRuntime.getInstance().getLibrary(key);
    }

    public FileSystem getFileSystem() {
        return NethomeRuntime.getInstance().getFileSystem();
    }

    public ProjectList getProjectList() {
        return this.mProjectList;
    }

    public WindowContainer getWindowContainer() {
        return this.mWindowContainer;
    }

    public UserInfo getUserInfo() {
        return this.mUserInfo;
    }

    public GuiCreator getGuiCreator() {
        return this.mGuiCreator;
    }

    public void registerAccel(AccelKey c) {
        CommandManager.getInstance().registerAccel(c);
    }

    public AccelKey getAccel(KeyEvent e) {
        return this.getAccel(e.getKeyCode(), e.getModifiers());
    }

    public AccelKey getAccel(int keycode, int modifiers) {
        return CommandManager.getInstance().getAccel(keycode, modifiers);
    }

    public void registerMaskEvent(Command m, int i) {
        CommandManager.getInstance().registerMaskEvent(m, i);
    }

    public Command getMaskCommand(int mod) {
        return CommandManager.getInstance().getMaskCommand(mod);
    }

    public List<Command> getCommandCollection() {
        return CommandManager.getInstance().getCommandCollection();
    }

    public <T extends Command> T getCommand(Class<T> c) {
        return (T)CommandManager.getInstance().getCommand(c);
    }

    public void block() {
        this.setEnabled(false);
    }

    public void unblock() {
        this.setEnabled(true);
    }

    public Class<? extends MainApplication> getMainClass() {
        return this.mManApp.getClass();
    }

    public MainApplication getApplication() {
        return this.mManApp;
    }

    public void preFrameClose() {
        List<Command> v = this.getCommandCollection();
        int i = 0;
        while (i < v.size()) {
            Command c = v.get(i);
            c.frameClosing();
            ++i;
        }
    }

    public boolean doModal(Frame parent, Object tc, int type, boolean resize, String title, boolean center) {
        return this.doModal(parent, tc, type, resize, title, null, center, -1, -1);
    }

    public boolean doModal(Frame parent, Object tc, int type, boolean resize, String title, Component req, boolean center) {
        return this.doModal(parent, tc, type, resize, title, null, center, -1, -1);
    }

    public boolean doModal(Frame parent, Object tc, int type, boolean resize, String title, Component req, boolean center, int w, int h) {
        if (parent == null) {
            parent = this.getParentFrame();
        }
        NethomeDialog td = new NethomeDialog(parent, tc, type, NethomeLookAndFeel.DIALOG_AROUND_COLOR);
        if (tc instanceof NethomeDialogInnerComponent) {
            ((NethomeDialogInnerComponent)tc).setParentDialog(td);
        }
        td.setInitFocus(req);
        td.setTitle(title);
        td.setResizable(resize);
        if (w > 0 && h > 0) {
            td.setSize(w, h);
        }
        this.block();
        if (center) {
            td.setVisible(true, true);
        } else {
            td.setVisible(true, true, this.getActiveCanvas());
        }
        this.unblock();
        boolean closeState = td.getCloseState() == 0;
        td.dispose();
        return closeState;
    }

    public Dialog doModeless(Frame parent, Object tc, int type, int pos, boolean resize, String title, Component req, boolean center, int w, int h) {
        NethomeDialog td = new NethomeDialog(parent, tc, type, NethomeLookAndFeel.DIALOG_AROUND_COLOR);
        td.setModal(false);
        td.setInitFocus(req);
        td.setTitle(title);
        td.setResizable(resize);
        if (w > 0 && h > 0) {
            td.setSize(w, h);
        } else {
            td.pack();
        }
        if (pos >= 0) {
            td.setVisible(true, parent, pos);
        } else if (center) {
            td.setVisible(true, true);
        } else {
            td.setVisible(true, true, this.getActiveCanvas());
        }
        return td;
    }

    public void appendKeyListener(Object o) {
        if (o.getClass().isAnnotationPresent(NoDefaultKeyListener.class)) {
            return;
        }
        if (o instanceof Container) {
            Component[] cc;
            Container c = (Container)o;
            c.addKeyListener(this);
            if (c.getComponentCount() != 0 && (cc = c.getComponents()) != null) {
                Component[] componentArray = cc;
                int n = cc.length;
                int n2 = 0;
                while (n2 < n) {
                    Component element = componentArray[n2];
                    this.appendKeyListener(element);
                    ++n2;
                }
            }
        } else if (o instanceof Component) {
            Component c = (Component)o;
            c.addKeyListener(this);
        }
    }

    public ImageTool getImageTool() {
        return this.mImageTool;
    }

    public static void updateLayout() {
        MainComponent c = MainComponent.getInstance();
        if (c != null) {
            MainComponent.updateLayout(c);
            ((Component)c).validate();
            ((Component)c).doLayout();
        }
    }

    public static void updateLayout(Object o) {
        if (o instanceof Container) {
            Component[] cc;
            Container c = (Container)o;
            c.invalidate();
            if (c.getComponentCount() != 0 && (cc = c.getComponents()) != null) {
                Component[] componentArray = cc;
                int n = cc.length;
                int n2 = 0;
                while (n2 < n) {
                    Component element = componentArray[n2];
                    MainComponent.updateLayout(element);
                    ++n2;
                }
            }
        } else if (o instanceof Component) {
            Component c = (Component)o;
            c.invalidate();
        }
    }

    public Frame getParentFrame() {
        return this.mManApp.getParentFrame();
    }

    public TipsMessage getTipsMessage() {
        return this.mStatusBar;
    }

    public void setTipsMessage(TipsMessage statusBar) {
        this.mStatusBar = statusBar;
    }

    public void initUserInterface() {
        CommandManager.getInstance().initUserInterface();
    }

    public void updateUserInterface() {
        CommandManager.getInstance().updateUserInterface();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        Canvas2D can = this.getActiveCanvas();
        if (can != null) {
            can.keyPress(e);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        Canvas2D can = this.getActiveCanvas();
        if (can != null) {
            can.keyRelease(e);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public CopyBuffer getCopyBuffer() {
        return this.mCopyBuffer;
    }

    public void addPage(String pagename, Component page) {
        this.add(page, pagename);
    }

    public void changePage(String pagename) {
        this.mCardLayout.show(this, pagename);
    }

    public Component getActivePage() {
        Component[] c = this.getComponents();
        if (c != null) {
            Component[] componentArray = c;
            int n = c.length;
            int n2 = 0;
            while (n2 < n) {
                Component element = componentArray[n2];
                if (element.isVisible()) {
                    return element;
                }
                ++n2;
            }
        }
        return null;
    }

    public void setCursor(KCursor ct) {
        Cursor c = CursorManager.getInstance().getCursor(ct);
        this.setCursor(c);
    }

    @Override
    public void setCursor(Cursor c) {
        Component[] cc;
        super.setCursor(c);
        if (this.getComponentCount() != 0 && (cc = this.getComponents()) != null) {
            Component[] componentArray = cc;
            int n = cc.length;
            int n2 = 0;
            while (n2 < n) {
                Component element = componentArray[n2];
                this.setCursor(c, element);
                ++n2;
            }
        }
    }

    public void setCursor(Cursor cur, Object o) {
        if (o instanceof Container) {
            Component[] cc;
            Container c = (Container)o;
            c.setCursor(cur);
            if (c.getComponentCount() != 0 && (cc = c.getComponents()) != null) {
                Component[] componentArray = cc;
                int n = cc.length;
                int n2 = 0;
                while (n2 < n) {
                    Component element = componentArray[n2];
                    this.setCursor(cur, element);
                    ++n2;
                }
            }
        } else if (o instanceof Component) {
            Component c = (Component)o;
            c.setCursor(cur);
        }
    }
}

