/*
 * Decompiled with CFR 0.152.
 */
package nethome.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JPanel;
import jp.kitec.lib.kwt.KColor;
import jp.kitec.lib.kwt.KFont;
import jp.kitec.lib.kwt.KRichGraphics;
import nethome.doc.Document;
import nethome.ui.CanvasCommandDispatcher;
import nethome.ui.ICanvas2D;
import nethome.ui.ICanvasBase;
import nethome.ui.command.Command;

public abstract class CanvasBase
extends JPanel
implements ICanvasBase,
ICanvas2D {
    private static final long serialVersionUID = 1L;
    protected Document mDoc = null;
    protected CanvasCommandDispatcher mCommandDispatcher = null;
    protected static final KFont mDefFont = KFont.getFont((String)"Dialog", (int)0, (double)12.0);
    protected KColor mBackColor = KColor.WHITE;
    protected Graphics mBufferGraphics;
    protected Image mBufferImage;
    protected Graphics mOffGraphics;
    protected Image mOffImage;
    public KRichGraphics mAbstCanvas = new KRichGraphics();

    public CanvasBase() {
        this.setBackground(Color.white);
        this.setOpaque(false);
        this.mCommandDispatcher = new CanvasCommandDispatcher((ICanvas2D)this);
    }

    public Command getMouseCommand() {
        return this.mCommandDispatcher.getMouseCommand();
    }

    public void setNullCommand(Command c) {
        this.mCommandDispatcher.setNullCommand(c);
    }

    public void setArrowKeyCommand(Command m) {
        this.mCommandDispatcher.setArrowKeyCommand(m);
    }

    public void clearMaskCommand() {
        this.mCommandDispatcher.clearMaskCommand();
    }

    public void setViewControlCommand(Command c) {
        this.mCommandDispatcher.setViewControlCommand(c);
    }

    public Command getViewControlCommand() {
        return this.mCommandDispatcher.getViewControlCommand();
    }

    public void updateViewControl() {
        this.mCommandDispatcher.updateViewControl();
    }

    public void setMouseCommand(Command c) {
        this.mCommandDispatcher.setMouseCommand(c);
        this.repaint();
    }

    public double getXdotlength(int dot) {
        return (double)dot / this.mAbstCanvas.getDotPerLen();
    }

    public void updateImage() {
    }

    protected boolean isChangeCanvasSize() {
        if (this.mBufferImage == null || this.mBufferGraphics == null) {
            return true;
        }
        return this.mAbstCanvas.getSize().width != this.mBufferImage.getWidth(this) || this.mAbstCanvas.getSize().height != this.mBufferImage.getHeight(this);
    }
}

