/*
 * Decompiled with CFR 0.152.
 */
package nethome.ui.command;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import nethome.ui.Canvas2D;
import nethome.ui.ICanvas2D;
import nethome.ui.MainComponent;
import nethome.ui.command.Command;
import nethome.ui.command.CommandUtil;

public class ComViewMove
extends Command
implements ActionListener {
    private int mX;
    private int mY;
    private double mCx;
    private double mCy;
    protected boolean mPres = false;

    public void play() {
        CommandUtil.setActiveUI(this.mComponent, true);
        MainComponent mc = MainComponent.getInstance();
        Canvas2D can = mc.getActiveCanvas();
        if (can == null) {
            return;
        }
        can.setCursor(ICanvas2D.MOUSE_MOVE);
    }

    public void end() {
        CommandUtil.setActiveUI(this.mComponent, false);
        MainComponent mc = MainComponent.getInstance();
        Canvas2D can = mc.getActiveCanvas();
        if (can == null) {
            return;
        }
        if (this.mPres) {
            this.mPres = false;
            can.setDrawMode((short)0);
            can.updateImage();
            can.repaint();
        }
        can.setCursor(ICanvas2D.MOUSE_DEF);
    }

    public void mouseMove(int x, int y, int mod) {
    }

    public void mousePress(int x, int y, int mod) {
        this.mPres = true;
        MainComponent mc = MainComponent.getInstance();
        Canvas2D can = mc.getActiveCanvas();
        if (can == null) {
            return;
        }
        this.mX = x;
        this.mY = y;
        this.mCx = can.mAbstCanvas.getViewPort().getCx();
        this.mCy = can.mAbstCanvas.getViewPort().getCy();
        can.setDrawMode((short)2);
        can.updateImage();
        can.repaint();
    }

    public void mouseDrag(int x, int y, int mod) {
        MainComponent mc = MainComponent.getInstance();
        Canvas2D can = mc.getActiveCanvas();
        if (can == null) {
            return;
        }
        can.setCursor(ICanvas2D.MOUSE_MOVE);
        double xx = can.mAbstCanvas.devToRealX((double)x);
        double yy = can.mAbstCanvas.devToRealY((double)y);
        can.mAbstCanvas.setViewCenter(this.mCx - (xx - can.mAbstCanvas.devToRealX((double)this.mX)), this.mCy - (yy - can.mAbstCanvas.devToRealY((double)this.mY)));
        can.updateImage();
        can.repaint();
        can.updateViewControl();
    }

    public void mouseRelease(int x, int y, int mod) {
        if (!this.mPres) {
            return;
        }
        MainComponent mc = MainComponent.getInstance();
        Canvas2D can = mc.getActiveCanvas();
        if (can == null) {
            return;
        }
        can.setDrawMode((short)0);
        can.updateImage();
        this.mPres = false;
        if (!this.mContinue) {
            can.setMouseCommand(null);
        }
        can.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MainComponent mc = MainComponent.getInstance();
        Canvas2D can = mc.getActiveCanvas();
        if (can == null) {
            return;
        }
        can.setMouseCommand(this);
        this.play();
    }
}

