/*
 * Decompiled with CFR 0.152.
 */
package nethome5.servlet;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import javax.servlet.ServletConfig;
import jp.kitec.lib.util.ObjectFolderUtil;
import jp.kitec.lib.util.tree.ObjectFolder;
import jp.kitec.lib.util.tree.ObjectNode;
import nethome5.servlet.FileCreateServlet;
import option.io.pdfcommon.command.PdfCommandParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PDFCreateServlet
extends FileCreateServlet {
    private static final Log mLog = LogFactory.getLog(PDFCreateServlet.class);

    @Override
    protected String configFileType() {
        return "pdf";
    }

    @Override
    public void init(ServletConfig config) {
        super.init(config);
        Collection fileTypeFolders = ObjectFolderUtil.findChildFolders((ObjectFolder)mConfigFolder, (String)"pdf");
        if (fileTypeFolders.isEmpty()) {
            return;
        }
        ObjectFolder fileTypeFolder = (ObjectFolder)fileTypeFolders.iterator().next();
        Collection configFolders = ObjectFolderUtil.findChildFolders((ObjectFolder)fileTypeFolder, (String)"format");
        boolean preload = true;
        String encoding = "UTF-8";
        if (configFolders.size() > 0) {
            ObjectNode encodingNode;
            ObjectFolder configFolder = (ObjectFolder)configFolders.iterator().next();
            ObjectNode preloadNode = ObjectFolderUtil.findChildNode((ObjectFolder)configFolder, (String)"preload");
            if (preloadNode != null) {
                preload = preloadNode.getBool();
            }
            if ((encodingNode = ObjectFolderUtil.findChildNode((ObjectFolder)configFolder, (String)"encoding")) != null) {
                encoding = encodingNode.getString();
            }
        }
        if (preload) {
            PdfCommandParser.loadFormat((File)new File(mContextRootRealDir), (String)encoding);
        }
    }

    @Override
    protected synchronized void createFile(Map<String, byte[]> commandData, String fileName, String inputDir, String outputDir) {
        String result = new PdfCommandParser(commandData, inputDir, outputDir, null, fileName).createPdf();
        if (result == null) {
            throw new RuntimeException("pdf creation failed");
        }
    }
}

