/*
 * Decompiled with CFR 0.152.
 */
package nethome.util;

import java.util.Collection;
import javax.servlet.http.HttpServletResponse;
import jp.kitec.lib.util.ObjectFolderUtil;
import jp.kitec.lib.util.tree.ObjectFolder;
import jp.kitec.lib.util.tree.ObjectNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NethomeXmlUtil {
    public static final String CONFIG_PATH = "nethome.xml";
    private static final Log mLog = LogFactory.getLog(NethomeXmlUtil.class);

    public static boolean matchUserAgent(ObjectFolder parentFolder, String userAgent) {
        Collection folders = ObjectFolderUtil.findChildFolders((ObjectFolder)parentFolder, (int)1, (String)"userAgent");
        for (ObjectFolder folder : folders) {
            ObjectNode valueNode = folder.findNode("value");
            if (!userAgent.matches(valueNode.getObject().toString())) continue;
            mLog.info((Object)("matched userAgent[" + valueNode.getObject().toString() + "]"));
            return true;
        }
        return false;
    }

    public static boolean matchRemove(ObjectFolder parentFolder) {
        Collection folders = ObjectFolderUtil.findChildFolders((ObjectFolder)parentFolder, (int)1, (String)"remove");
        ObjectFolder folder = (ObjectFolder)folders.iterator().next();
        ObjectNode valueNode = folder.findNode("value");
        return Boolean.valueOf(valueNode.getObject().toString()) != false;
    }

    public static void settingContentType(ObjectFolder parentFolder, HttpServletResponse response) {
        Collection folders = ObjectFolderUtil.findChildFolders((ObjectFolder)parentFolder, (int)1, (String)"contentType");
        if (folders.isEmpty()) {
            return;
        }
        ObjectFolder folder = (ObjectFolder)folders.iterator().next();
        ObjectNode valueNode = folder.findNode("value");
        String value = ObjectNode.getNodeString((ObjectNode)valueNode);
        response.setContentType(value);
        mLog.info((Object)("ContentType[" + value + "]"));
    }

    public static void settingHeader(ObjectFolder parentFolder, HttpServletResponse response, String fileName) {
        Collection folders = ObjectFolderUtil.findChildFolders((ObjectFolder)parentFolder, (int)1, (String)"header");
        for (ObjectFolder folder : folders) {
            ObjectNode nameNode = folder.findNode("name");
            ObjectNode valueNode = folder.findNode("value");
            ObjectNode addFileNameNode = folder.findNode("addFileName");
            String name = ObjectNode.getNodeString((ObjectNode)nameNode);
            boolean addFileName = Boolean.parseBoolean(ObjectNode.getNodeString((ObjectNode)addFileNameNode));
            String value = String.valueOf(ObjectNode.getNodeString((ObjectNode)valueNode)) + (addFileName ? fileName : "");
            response.setHeader(name, value);
        }
    }
}

