/*
 * Decompiled with CFR 0.152.
 */
package nethome.servlet;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.kitec.lib.io.FileIOUtil;
import jp.kitec.lib.util.CompressData;
import jp.kitec.lib.util.HttpIOUtil;
import jp.kitec.lib.util.ObjectFolderUtil;
import jp.kitec.lib.util.StringUtil;
import jp.kitec.lib.util.UniqueNameUtil;
import jp.kitec.lib.util.tree.ObjectFolder;
import jp.kitec.lib.util.tree.ObjectNode;
import nethome.servlet.AbstractFileIOServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class FileCreateServlet
extends AbstractFileIOServlet {
    private static final Log mLog = LogFactory.getLog(FileCreateServlet.class);
    private Charset charsetUTF8 = Charset.forName("UTF-8");

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        out.println("<html><head><title>CHECK</title></head><body>REQ_ URI:" + request.getRequestURI() + "<br></body></html>");
        out.flush();
    }

    @Override
    protected void process(HttpServletRequest request, HttpServletResponse response) {
        boolean compress;
        byte[] recieveData = HttpIOUtil.receiveBytes((HttpServletRequest)request);
        byte[] sendData = null;
        Map<String, byte[]> commandData = this.extractCommandData(recieveData);
        if (commandData != null) {
            String fileType = null;
            String fileOutputDirName = null;
            if (StringUtil.isEmpty((String)this.configFileType())) {
                fileType = this.getValue(commandData, "suffix");
                fileType = StringUtil.emptyToZeroString((String)fileType).replaceAll("\\.", "");
                fileOutputDirName = this.createFileOutputDirName(mConfigFolder, mContextRootRealDir, fileType);
            } else {
                fileType = this.configFileType();
                fileType = StringUtil.emptyToZeroString((String)fileType).replaceFirst("\\.", "");
                fileOutputDirName = mFileOutputDirName;
            }
            FilenamePair fileName = this.createFileName(fileType, commandData);
            if (!this.isValidFileName(fileName.servername) || !this.isValidFileName(fileName.clientname)) {
                this.processInvalidFileName(request, response);
                return;
            }
            this.createFile(commandData, fileName.servername, mContextRootRealDir, fileOutputDirName);
            sendData = fileName.clientname.getBytes(this.charsetUTF8);
        }
        String strCompress = this.getValue(commandData, "_compress");
        boolean magic = compress = "1".equals(strCompress);
        if (compress) {
            sendData = CompressData.compress(sendData);
        }
        HttpIOUtil.sendBytes((HttpServletResponse)response, (byte[])sendData, (boolean)compress, (boolean)magic);
    }

    protected Map<String, byte[]> extractCommandData(byte[] receiveData) {
        HashMap<String, byte[]> commandData = null;
        if (receiveData != null) {
            try {
                commandData = new HashMap<String, byte[]>();
                ByteArrayInputStream bis = new ByteArrayInputStream(receiveData);
                DataInputStream is = new DataInputStream(bis);
                int mapSize = is.readInt();
                int i = 0;
                while (i < mapSize) {
                    String key = this.readString(is);
                    int size = is.readInt();
                    byte[] data = new byte[size];
                    int l = is.read(data);
                    if (l != size) {
                        throw new IOException("length mismatch " + size + "/" + l);
                    }
                    commandData.put(key, data);
                    ++i;
                }
            }
            catch (IOException e) {
                mLog.error((Object)e);
                commandData = null;
            }
        }
        mLog.debug((Object)("commandData[" + commandData + "]"));
        return commandData;
    }

    protected String readString(DataInputStream is) throws IOException {
        int length = is.readInt();
        byte[] bytes = new byte[length];
        int l = is.read(bytes);
        if (l != length) {
            throw new IOException("length mismatch " + length + "/" + l);
        }
        return new String(bytes, this.charsetUTF8);
    }

    protected FilenamePair createFileName(String fileType, Map<String, byte[]> commandData) {
        Collection fileTypeFolders = ObjectFolderUtil.findChildFolders((ObjectFolder)mConfigFolder, (String)fileType);
        if (fileTypeFolders.isEmpty()) {
            return null;
        }
        ObjectFolder fileTypeFolder = (ObjectFolder)fileTypeFolders.iterator().next();
        Collection configFolders = ObjectFolderUtil.findChildFolders((ObjectFolder)fileTypeFolder, (String)"name");
        if (configFolders.isEmpty()) {
            return null;
        }
        ObjectFolder configFolder = (ObjectFolder)configFolders.iterator().next();
        String prefix = ObjectNode.getNodeString((ObjectNode)configFolder.findNode("prefix"));
        String suffix = ObjectNode.getNodeString((ObjectNode)configFolder.findNode("suffix"));
        UniqueNameUtil.UniqueNameInfo uniqueNameInfo = UniqueNameUtil.createUniqueNameInfo((String)prefix, (String)suffix);
        return new FilenamePair(UniqueNameUtil.createUniqueName((UniqueNameUtil.UniqueNameInfo)uniqueNameInfo), UniqueNameUtil.createRequestName((UniqueNameUtil.UniqueNameInfo)uniqueNameInfo));
    }

    protected String getValue(Map<String, byte[]> commandData, String key) {
        byte[] bytes = commandData.get(key);
        if (bytes == null) {
            return null;
        }
        return new String(bytes);
    }

    protected void createFile(Map<String, byte[]> commandData, String fileName, String inputDir, String outputDir) {
        byte[] data = commandData.get("DATA");
        if (!(data instanceof byte[])) {
            return;
        }
        byte[] dataBytes = data;
        File file = new File(outputDir, fileName);
        FileIOUtil.bytesToFile((File)file, (byte[])dataBytes);
    }

    public static class FilenamePair {
        public String servername;
        public String clientname;

        public FilenamePair(String servername, String clientname) {
            this.servername = servername;
            this.clientname = clientname;
        }
    }
}

