/*
 * Decompiled with CFR 0.152.
 */
package nethome.servlet;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.kitec.lib.dao.ObjectFolderDao;
import jp.kitec.lib.io.FileUtil;
import jp.kitec.lib.util.ObjectFolderUtil;
import jp.kitec.lib.util.StringUtil;
import jp.kitec.lib.util.tree.ObjectFolder;
import jp.kitec.lib.util.tree.ObjectNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractFileIOServlet
extends HttpServlet {
    private static final Log mLog = LogFactory.getLog(AbstractFileIOServlet.class);
    protected static String mContextRootRealDir;
    protected static String mFileOutputDirName;
    protected static ObjectFolder mConfigFolder;

    protected abstract String configFileType();

    public void init(ServletConfig config) {
        try {
            super.init(config);
            if (mContextRootRealDir == null) {
                mContextRootRealDir = this.getServletContext().getRealPath("");
            }
        }
        catch (Exception e) {
            mLog.error((Object)"", (Throwable)e);
        }
        ObjectFolderDao dao = new ObjectFolderDao();
        dao.setInput(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("nethome.xml"));
        mConfigFolder = dao.load();
        String fileType = this.configFileType();
        if (!StringUtil.isEmpty((String)fileType)) {
            mFileOutputDirName = this.createFileOutputDirName(mConfigFolder, mContextRootRealDir, fileType);
        }
    }

    protected String createFileOutputDirName(ObjectFolder configFolder, String contextRootRealDir, String fileType) {
        File file;
        ObjectFolder fileTypeFolder;
        Collection outputDirFolders;
        String result = null;
        String outputDir = null;
        Collection fileTypeFolders = ObjectFolderUtil.findChildFolders((ObjectFolder)configFolder, (String)fileType);
        if (!fileTypeFolders.isEmpty() && !(outputDirFolders = ObjectFolderUtil.findChildFolders((ObjectFolder)(fileTypeFolder = (ObjectFolder)fileTypeFolders.iterator().next()), (String)"outputDir")).isEmpty()) {
            ObjectFolder outputDirFolder = (ObjectFolder)outputDirFolders.iterator().next();
            ObjectNode valueNode = outputDirFolder.findNode("value");
            outputDir = ObjectNode.getNodeString((ObjectNode)valueNode);
        }
        if (!StringUtil.isEmpty(outputDir) && (file = new File(outputDir)).exists()) {
            result = outputDir;
        }
        if (result == null) {
            String defaultFileOutputDir = FileUtil.concatPath((String)contextRootRealDir, (String)("WEB-INF/" + fileType));
            File file2 = new File(defaultFileOutputDir);
            if (!file2.exists()) {
                file2.mkdir();
            }
            result = defaultFileOutputDir;
        }
        mLog.info((Object)("fileOutputDir[" + result + "]"));
        return result;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    protected abstract void process(HttpServletRequest var1, HttpServletResponse var2);

    protected boolean isValidFileName(String name) {
        return name != null && name.indexOf("..") == -1 && name.indexOf("\\") == -1 && name.indexOf(File.separator) == -1;
    }

    protected void processInvalidFileName(HttpServletRequest request, HttpServletResponse response) {
    }
}

