/*
 * Decompiled with CFR 0.152.
 */
package nethome.servlet;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.kitec.lib.io.FileIOUtil;
import jp.kitec.lib.util.ObjectFolderUtil;
import jp.kitec.lib.util.StringUtil;
import jp.kitec.lib.util.UniqueNameUtil;
import jp.kitec.lib.util.tree.ObjectFolder;
import nethome.servlet.AbstractFileIOServlet;
import nethome.util.NethomeXmlUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileGetServlet
extends AbstractFileIOServlet {
    private static final Log mLog = LogFactory.getLog(FileGetServlet.class);

    @Override
    protected String configFileType() {
        return null;
    }

    @Override
    protected void process(HttpServletRequest request, HttpServletResponse response) {
        Object[] paths = this.parsePath(request);
        String fileName = this.createFileName(request, paths);
        if (!this.isValidFileName(fileName)) {
            this.processInvalidFileName(request, response);
            return;
        }
        String fileType = null;
        String fileOutputDirName = null;
        if (StringUtil.isEmpty((String)this.configFileType())) {
            fileType = request.getParameter("suffix");
            fileType = StringUtil.emptyToZeroString((String)fileType).replaceFirst("\\.", "");
            fileOutputDirName = this.createFileOutputDirName(mConfigFolder, mContextRootRealDir, fileType);
        } else {
            fileType = this.configFileType();
            fileType = StringUtil.emptyToZeroString((String)fileType).replaceFirst("\\.", "");
            fileOutputDirName = mFileOutputDirName;
        }
        String headerFileName = this.createHeaderFileName(request, paths);
        this.settingResponseHeader(request, response, headerFileName, fileType);
        String filePath = fileOutputDirName + "/" + fileName;
        mLog.info((Object)("filePath[" + filePath + "]"));
        this.outputFile(response, filePath);
        if (!StringUtil.isEmpty((String)fileName)) {
            this.remove(fileName, mFileOutputDirName, fileType);
        }
    }

    protected String createFileName(HttpServletRequest request, Object[] paths) {
        String prefix = (String)paths[0];
        String seed = (String)paths[1];
        String suffix = (String)paths[2];
        return UniqueNameUtil.createUniqueName((String)prefix, null, (String)seed, (String)suffix);
    }

    protected String createHeaderFileName(HttpServletRequest request, Object[] paths) {
        String prefix = (String)paths[0];
        String seed = (String)paths[1];
        String suffix = (String)paths[2];
        return UniqueNameUtil.createUniqueName((String)prefix, null, null, (String)suffix);
    }

    protected Object[] parsePath(HttpServletRequest request) {
        String path = null;
        try {
            path = request.getPathInfo();
            String[] paths = path.split("/");
            if (paths.length != 3) {
                throw new RuntimeException();
            }
            String fileName = paths[2];
            int suffixStartIdx = fileName.indexOf(46);
            Object[] result = new Object[4];
            result[0] = fileName.substring(0, suffixStartIdx);
            result[1] = paths[1];
            result[2] = fileName.substring(suffixStartIdx);
            return result;
        }
        catch (Exception e) {
            throw new IllegalStateException("path parse failure. path[" + path + "]");
        }
    }

    protected void settingResponseHeader(HttpServletRequest request, HttpServletResponse response, String fileName, String fileType) {
        String userAgent = request.getHeader("User-Agent");
        mLog.info((Object)("User-Agent[" + userAgent + "] fileType[" + fileType + "]"));
        Collection fileTypeFolders = ObjectFolderUtil.findChildFolders((ObjectFolder)mConfigFolder, (String)fileType);
        if (fileTypeFolders.isEmpty()) {
            return;
        }
        ObjectFolder fileTypeFolder = (ObjectFolder)fileTypeFolders.iterator().next();
        Collection downloadFolders = ObjectFolderUtil.findChildFolders((ObjectFolder)fileTypeFolder, (String)"download");
        if (downloadFolders.isEmpty()) {
            return;
        }
        ObjectFolder downloadFolder = (ObjectFolder)downloadFolders.iterator().next();
        ObjectFolder matchedResponseFolder = null;
        Collection responseFolders = ObjectFolderUtil.findChildFolders((ObjectFolder)downloadFolder, (String)"response");
        for (ObjectFolder responseFolder : responseFolders) {
            if (!NethomeXmlUtil.matchUserAgent(responseFolder, userAgent)) continue;
            matchedResponseFolder = responseFolder;
            break;
        }
        if (matchedResponseFolder == null) {
            throw new IllegalStateException(userAgent + "'s response not found.");
        }
        NethomeXmlUtil.settingContentType(matchedResponseFolder, response);
        NethomeXmlUtil.settingHeader(matchedResponseFolder, response, fileName);
    }

    protected void outputFile(HttpServletResponse res, String filePath) {
        ServletOutputStream outputStream = null;
        try {
            File file = new File(filePath);
            outputStream = res.getOutputStream();
            FileIOUtil.read((File)file, (OutputStream)outputStream);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                FileIOUtil.close(outputStream);
                throw throwable;
            }
        }
        FileIOUtil.close((OutputStream)outputStream);
    }

    protected void remove(String fileName, String outputDir, String fileType) {
        Collection fileTypeFolders = ObjectFolderUtil.findChildFolders((ObjectFolder)mConfigFolder, (String)fileType);
        if (fileTypeFolders.isEmpty()) {
            return;
        }
        ObjectFolder fileTypeFolder = (ObjectFolder)fileTypeFolders.iterator().next();
        Collection downloadFolders = ObjectFolderUtil.findChildFolders((ObjectFolder)fileTypeFolder, (String)"download");
        if (downloadFolders.isEmpty()) {
            return;
        }
        ObjectFolder downloadFolder = (ObjectFolder)downloadFolders.iterator().next();
        boolean remove = false;
        Collection afterActionFolders = ObjectFolderUtil.findChildFolders((ObjectFolder)downloadFolder, (String)"afterAction");
        for (ObjectFolder afterActionFolder : afterActionFolders) {
            if (!NethomeXmlUtil.matchRemove(afterActionFolder)) continue;
            remove = true;
            break;
        }
        if (!remove) {
            return;
        }
        try {
            File file = new File(outputDir, fileName);
            file.delete();
            mLog.info((Object)("remove outputDir[" + outputDir + "] fileName[" + fileName + "]"));
        }
        catch (Exception e) {
            mLog.info((Object)"", (Throwable)e);
        }
    }
}

