/*
 * Decompiled with CFR 0.152.
 */
package nethome.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.kitec.lib.io.AbstFile;
import jp.kitec.lib.io.FileSystem;
import jp.kitec.lib.io.FileSystemUtil;
import jp.kitec.lib.servlet.BaseServlet;
import jp.kitec.lib.util.tree.ObjectFolder;
import jp.kitec.lib.util.tree.ObjectNode;
import jp.kitec.lib.util.xml.XMLManager;

public class NethomeLibrary
extends BaseServlet {
    private String mHomeDir;

    public void init(ServletConfig config) {
        try {
            super.init(config);
            this.mHomeDir = this.getServletContext().getRealPath("");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        resp.setContentType("text/html; charset=UTF-8");
        PrintWriter out = resp.getWriter();
        out.println("<html>");
        out.println("<head><title>NethomeLibrary</title></head>");
        out.println("<body>");
        out.println("REQ URI:" + req.getRequestURI() + "<br>");
        out.println("</body>");
        out.println("</html>");
        out.flush();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Object recData = this.recieveData(req);
        byte[] retData = null;
        if (recData != null && recData instanceof byte[]) {
            Object o;
            byte[] data = (byte[])recData;
            AbstFile af = new AbstFile();
            af.setData(data);
            XMLManager man = new XMLManager();
            man.load(af);
            ObjectFolder of = man.getTree();
            String libdir = null;
            String subdir = null;
            String[] filter = null;
            boolean cacheFile = false;
            ObjectNode on = of.getNode("libdir");
            if (on != null) {
                o = on.getObject();
                if (o != null && o instanceof String) {
                    libdir = (String)o;
                }
                if (libdir == null || !libdir.matches("^lib[a-zA-Z0-9]*$")) {
                    throw new IllegalArgumentException(libdir);
                }
            }
            if ((on = of.getNode("subdir")) != null && (o = on.getObject()) != null && o instanceof String) {
                subdir = (String)o;
            }
            if ((on = of.getNode("filters")) != null && (o = on.getObject()) != null && o instanceof String) {
                String filtersString = o.toString();
                StringTokenizer st = new StringTokenizer(filtersString, ",");
                filter = new String[st.countTokens()];
                int count = 0;
                while (st.hasMoreElements()) {
                    String ext = st.nextToken();
                    if (ext.startsWith(".")) {
                        ext = ext.substring(1);
                    }
                    filter[count++] = ext;
                }
            }
            if ((on = of.getNode("cachefile")) != null && (o = on.getObject()) != null && o instanceof String) {
                try {
                    cacheFile = Integer.valueOf((String)o) != 0;
                }
                catch (NumberFormatException e) {
                    cacheFile = false;
                }
            }
            retData = this.getFileSystem(libdir, subdir, filter, cacheFile);
        }
        this.returnData(res, retData);
        retData = null;
    }

    private byte[] getFileSystem(String libdir, String file, String[] ext, boolean cachefile) {
        String baseDir = String.valueOf(this.mHomeDir) + "/" + libdir;
        FileSystem fs = new FileSystem();
        FileSystemUtil.addFileSystem((FileSystem)fs, (String)baseDir, (String)file, (boolean)cachefile, (String[])ext);
        byte[] data = fs.getTransData();
        fs.releaseFileSystem();
        fs = null;
        return data;
    }
}

