/*
 * Decompiled with CFR 0.152.
 */
package nethome.servlet;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.kitec.lib.io.FileIOUtil;
import jp.kitec.lib.util.CompressData;
import jp.kitec.lib.util.HttpIOUtil;
import jp.kitec.lib.util.StringUtil;
import jp.kitec.lib.util.UniqueNameUtil;
import nethome.servlet.AbstractFileIOServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileCreateServlet
extends AbstractFileIOServlet {
    private static final Log mLog = LogFactory.getLog(FileCreateServlet.class);

    @Override
    protected String configFileType() {
        return null;
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        out.println("<html><head><title>CHECK</title></head><body>REQ_ URI:" + request.getRequestURI() + "<br></body></html>");
        out.flush();
    }

    @Override
    protected void process(HttpServletRequest request, HttpServletResponse response) {
        Object recieveData = HttpIOUtil.recvData((HttpServletRequest)request);
        recieveData = CompressData.decompress((Object)recieveData);
        Object sendData = null;
        Map<?, ?> commandData = this.extractCommandData(recieveData);
        if (commandData != null) {
            String fileType = null;
            String fileOutputDirName = null;
            if (StringUtil.isEmpty((String)this.configFileType())) {
                fileType = (String)commandData.get("suffix");
                fileType = StringUtil.emptyToZeroString((String)fileType).replaceAll("\\.", "");
                fileOutputDirName = this.createFileOutputDirName(mConfigFolder, mContextRootRealDir, fileType);
            } else {
                fileType = this.configFileType();
                fileType = StringUtil.emptyToZeroString((String)fileType).replaceFirst("\\.", "");
                fileOutputDirName = mFileOutputDirName;
            }
            String fileName = this.createFileName(commandData);
            if (!this.isValidFileName(fileName)) {
                this.processInvalidFileName(request, response);
                return;
            }
            sendData = this.createFile(commandData, fileName, mContextRootRealDir, fileOutputDirName);
        }
        sendData = CompressData.compress(sendData);
        HttpIOUtil.sendData((HttpServletResponse)response, (Object)sendData);
    }

    protected Map<?, ?> extractCommandData(Object recieveData) {
        Object[] recieveDataArray;
        Map commandData = null;
        if (recieveData != null && recieveData instanceof Object[] && (recieveDataArray = (Object[])recieveData).length == 1 && recieveDataArray[0] instanceof Map) {
            commandData = (Map)recieveDataArray[0];
        }
        mLog.debug((Object)("commandData[" + commandData + "]"));
        return commandData;
    }

    protected String createFileName(Map<?, ?> commandData) {
        String prefix = (String)commandData.get("prefix");
        Long epoch = (Long)commandData.get("epoch");
        String seed = (String)commandData.get("seed");
        String suffix = (String)commandData.get("suffix");
        return UniqueNameUtil.createUniqueName((String)prefix, (Long)epoch, (String)seed, (String)suffix);
    }

    protected synchronized Object createFile(Map<?, ?> commandData, String fileName, String inputDir, String outputDir) {
        Object data = commandData.get("DATA");
        if (!(data instanceof byte[])) {
            return null;
        }
        byte[] dataBytes = (byte[])data;
        File file = new File(outputDir, fileName);
        FileIOUtil.bytesToFile((File)file, (byte[])dataBytes);
        return fileName;
    }
}

