/*
 * Decompiled with CFR 0.152.
 */
package nethome5.ui.mini;

import java.util.HashMap;
import java.util.Map;
import jp.kitec.lib.io.FileSystem;
import nethome5.doc.Document;
import nethome5.doc.Project;
import nethome5.lib.ObjectLibrary;
import nethome5.ui.ApplicationCore;
import nethome5.ui.INethomeRuntime;

public class ThreadLocalRuntime
implements INethomeRuntime {
    public static final int SHARE_NODE = 0;
    public static final int SHARE_APPLICATION = 1;
    public static final int SHARE_LIBRARY = 2;
    public static final int SHARE_FILESYSTEM = 4;
    private boolean mShareApplication;
    private boolean mShareLibrary;
    private boolean mShareFileSystem;
    private Map<String, ObjectLibrary> mLibrary;
    private ThreadLocal<Map<String, ObjectLibrary>> mLibraryTLS;
    private FileSystem mFileSystem;
    private ThreadLocal<FileSystem> mFileSystemTLS;
    private ApplicationCore mApp;
    private ThreadLocal<ApplicationCore> mAppTLS;
    private ThreadLocal<Document> mDocTLS;

    public ThreadLocalRuntime(int mode) {
        this.mShareApplication = (mode & 1) != 0;
        this.mShareLibrary = (mode & 2) != 0;
        boolean bl = this.mShareFileSystem = (mode & 4) != 0;
        if (!this.mShareApplication) {
            this.mAppTLS = new ThreadLocal();
        }
        if (this.mShareLibrary) {
            this.mLibrary = new HashMap<String, ObjectLibrary>();
        } else {
            this.mLibraryTLS = new ThreadLocal();
        }
        if (!this.mShareFileSystem) {
            this.mFileSystemTLS = new ThreadLocal();
        }
        this.mDocTLS = new ThreadLocal();
    }

    public void setActiveDocument(Document doc) {
        this.mDocTLS.set(doc);
    }

    public Document getActiveDocument() {
        return this.mDocTLS.get();
    }

    public Project getActiveProject() {
        if (this.mDocTLS.get() == null) {
            return null;
        }
        return this.mDocTLS.get().getProject();
    }

    public ApplicationCore getApplication() {
        if (this.mShareApplication) {
            return this.mApp;
        }
        return this.mAppTLS.get();
    }

    public void setApplication(ApplicationCore app) {
        if (this.mShareApplication) {
            this.mApp = app;
        } else {
            this.mAppTLS.set(app);
        }
    }

    public void setFileSystem(FileSystem fs) {
        if (this.mShareFileSystem) {
            this.mFileSystem = fs;
        } else {
            this.mFileSystemTLS.set(fs);
        }
    }

    public FileSystem getFileSystem() {
        if (this.mShareFileSystem) {
            return this.mFileSystem;
        }
        return this.mFileSystemTLS.get();
    }

    public void registerLibrary(String key, ObjectLibrary lib) {
        if (key != null && lib != null) {
            if (this.mShareLibrary) {
                this.mLibrary.put(key, lib);
            } else {
                if (this.mLibraryTLS.get() == null) {
                    this.mLibraryTLS.set(new HashMap());
                }
                this.mLibraryTLS.get().put(key, lib);
            }
        }
    }

    public ObjectLibrary getLibrary(String key) {
        ObjectLibrary o;
        if (this.mShareLibrary) {
            o = this.mLibrary.get(key);
        } else {
            if (this.mLibraryTLS.get() == null) {
                this.mLibraryTLS.set(new HashMap());
            }
            o = this.mLibraryTLS.get().get(key);
        }
        if (o != null && o instanceof ObjectLibrary) {
            return o;
        }
        return null;
    }

    public Map<String, ObjectLibrary> getLibraries() {
        if (this.mShareLibrary) {
            return this.mLibrary;
        }
        if (this.mLibraryTLS.get() == null) {
            this.mLibraryTLS.set(new HashMap());
        }
        return this.mLibraryTLS.get();
    }
}

