/*
 * Decompiled with CFR 0.152.
 */
package nethome5.util;

import java.util.List;
import javax.vecmath.Point2d;
import jp.kitec.lib.util.Item;
import jp.kitec.lib.util.RefList;
import nethome5.util.ToolMath;
import nethome5.util.ToolMathEx;

public class ToolPolygon {
    public static final int POLY_NO_RELATION = 0;
    public static final int POLY_A_INCLUDE_B = 1;
    public static final int POLY_B_INCLUDE_A = 2;
    private static RefList<Point2d> triaList = new RefList();

    static {
        triaList.addElement((Object)new Point2d());
        triaList.addElement((Object)new Point2d());
        triaList.addElement((Object)new Point2d());
    }

    public static double getArea(RefList<? extends Point2d> polygon, Point2d cgp) {
        double cgx = 0.0;
        double cgy = 0.0;
        double area = 0.0;
        double xbase = ((Point2d)polygon.lastElement()).x;
        double ybase = ((Point2d)polygon.lastElement()).y;
        double xold = ((Point2d)polygon.elementAt((int)0)).x;
        double yold = ((Point2d)polygon.elementAt((int)0)).y;
        int i = 1;
        while (i < polygon.size()) {
            double x = ((Point2d)polygon.elementAt((int)i)).x;
            double y = ((Point2d)polygon.elementAt((int)i)).y;
            double areatria = ((xbase - x) * (yold - ybase) + (xold - xbase) * (y - ybase)) / 2.0;
            cgx += areatria * (x + xold);
            cgy += areatria * (y + yold);
            area += areatria;
            xold = x;
            yold = y;
            ++i;
        }
        if (cgp != null) {
            cgp.x = (cgx / area + xbase) / 3.0;
            cgp.y = (cgy / area + ybase) / 3.0;
        }
        if (area < (double)0.001f) {
            return 0.0;
        }
        return area;
    }

    public static boolean isInnerPolygon(RefList<? extends Point2d> polygon, double x, double y) {
        double sum = 0.0;
        int i = 0;
        while (i < polygon.size()) {
            Point2d pa = (Point2d)polygon.elementAt(i);
            Point2d pb = (Point2d)polygon.elementAt(i + 1);
            if (ToolMath.isOnLimitLinePoint2D((double)x, (double)y, (double)pa.x, (double)pa.y, (double)pb.x, (double)pb.y)) {
                return true;
            }
            double k = ToolMath.getAngle2D((double)x, (double)y, (double)pb.x, (double)pb.y) - ToolMath.getAngle2D((double)x, (double)y, (double)pa.x, (double)pa.y);
            if (k < -Math.PI) {
                k += Math.PI * 2;
            } else if (k > Math.PI) {
                k -= Math.PI * 2;
            }
            sum += k;
            ++i;
        }
        return Math.abs((sum = Math.abs(sum)) - Math.PI * 2) < 0.001;
    }

    public static boolean isInnerPolygon(List<? extends Point2d> polygon, double x, double y) {
        double sum = 0.0;
        int size = polygon.size();
        int i = 0;
        while (i < size) {
            Point2d pa = polygon.get(i);
            Point2d pb = polygon.get((i + 1) % size);
            if (ToolMath.isOnLimitLinePoint2D((double)x, (double)y, (double)pa.x, (double)pa.y, (double)pb.x, (double)pb.y)) {
                return true;
            }
            double k = ToolMath.getAngle2D((double)x, (double)y, (double)pb.x, (double)pb.y) - ToolMath.getAngle2D((double)x, (double)y, (double)pa.x, (double)pa.y);
            if (k < -Math.PI) {
                k += Math.PI * 2;
            } else if (k > Math.PI) {
                k -= Math.PI * 2;
            }
            sum += k;
            ++i;
        }
        return Math.abs((sum = Math.abs(sum)) - Math.PI * 2) < 0.001;
    }

    public static <T extends Point2d> boolean isOnLinePolygon(RefList<T> polygon, double x1, double y1, double x2, double y2) {
        Item it = null;
        int i = 0;
        while (i < polygon.size()) {
            Point2d p2;
            Point2d p1;
            Point2d p0 = (Point2d)polygon.elementAt(i - 1);
            if (!ToolMathEx.isParallel2D(p0, p1 = (Point2d)polygon.elementAt(i), p1, p2 = (Point2d)polygon.elementAt(i + 1))) {
                it = polygon.itemAt(i);
                break;
            }
            ++i;
        }
        if (it == null) {
            return false;
        }
        Item start = it;
        do {
            Point2d pc;
            Point2d pa = (Point2d)it.getObject();
            Point2d pb = (Point2d)it.nextItem.getObject();
            while ((it = it.nextItem) != start && ToolMathEx.isParallel2D(pa, pb, pb, pc = (Point2d)it.nextItem.getObject())) {
                pb = pc;
            }
            if (!ToolMath.isOnLimitLinePoint2D((double)x1, (double)y1, (double)pa.x, (double)pa.y, (double)pb.x, (double)pb.y) || !ToolMath.isOnLimitLinePoint2D((double)x2, (double)y2, (double)pa.x, (double)pa.y, (double)pb.x, (double)pb.y)) continue;
            return true;
        } while (it != start);
        return false;
    }

    public static boolean isCorrectRotation(RefList<Point2d> polygon) {
        Item n2nd = polygon.itemAt(0);
        double minx = ((Point2d)n2nd.getObject()).x;
        Item node = polygon.itemAt((int)0).nextItem;
        while (node != polygon.itemAt(0)) {
            if (((Point2d)node.getObject()).x < minx) {
                minx = ((Point2d)node.getObject()).x;
                n2nd = node;
            }
            node = node.nextItem;
        }
        Item n1st = n2nd.prevItem;
        Item n3rd = null;
        node = n2nd.nextItem;
        Point2d p1 = (Point2d)n1st.getObject();
        Point2d p2 = (Point2d)n2nd.getObject();
        do {
            Point2d p3 = (Point2d)node.getObject();
            if (ToolMath.isParallel2D((double)p2.x, (double)p2.y, (double)p1.x, (double)p1.y, (double)p2.x, (double)p2.y, (double)p3.x, (double)p3.y)) continue;
            n3rd = node;
            break;
        } while ((node = node.nextItem) != n2nd);
        if (n3rd == null) {
            return false;
        }
        double angle = ToolMath.getAngle2D((double)((Point2d)n1st.getObject()).x, (double)((Point2d)n1st.getObject()).y, (double)((Point2d)n2nd.getObject()).x, (double)((Point2d)n2nd.getObject()).y);
        double[] chkcoord = new double[2];
        ToolMath.rotation2D((double)((Point2d)n1st.getObject()).x, (double)((Point2d)n1st.getObject()).y, (double)(-angle), (double)((Point2d)n3rd.getObject()).x, (double)((Point2d)n3rd.getObject()).y, (double[])chkcoord);
        return chkcoord[1] > ((Point2d)n1st.getObject()).y;
    }

    public static RefList<Point2d> getHatchingLine(RefList<? extends Point2d> polygon, double x1, double y1, double x2, double y2) {
        RefList r = new RefList();
        double[] res = new double[2];
        int j = 0;
        while (j < polygon.size()) {
            Point2d p1 = (Point2d)polygon.elementAt(j);
            Point2d p2 = (Point2d)polygon.elementAt(j + 1);
            if (ToolPolygon.isInnerPolygon(polygon, x1, y1)) {
                r.addElement((Object)new Point2d(x1, y1));
            }
            if (ToolPolygon.isInnerPolygon(polygon, x2, y2)) {
                r.addElement((Object)new Point2d(x2, y2));
            }
            if (!ToolMath.isParallel2D((double)x1, (double)y1, (double)x2, (double)y2, (double)p1.x, (double)p1.y, (double)p2.x, (double)p2.y) && ToolMath.isCrossSegment((double)x1, (double)y1, (double)x2, (double)y2, (double)p1.x, (double)p1.y, (double)p2.x, (double)p2.y, (double[])res)) {
                r.addElement((Object)new Point2d(res[0], res[1]));
            }
            ++j;
        }
        if (r.size() == 0) {
            return null;
        }
        ToolPolygon.removeOverlapNode(r);
        if (r.size() == 0) {
            return null;
        }
        return r;
    }

    public static <T extends Point2d> void removeOverlapNode(RefList<T> r) {
        Item it1 = r.itemAt(0);
        int i = 0;
        while (i < r.size() - 1) {
            Item it2 = it1.nextItem;
            int count = r.size();
            int j = i + 1;
            while (j < count) {
                Item it2next = it2.nextItem;
                if (ToolMath.isSame2D((double)((Point2d)it1.getObject()).x, (double)((Point2d)it1.getObject()).y, (double)((Point2d)it2.getObject()).x, (double)((Point2d)it2.getObject()).y)) {
                    r.removeItemAt(it2);
                }
                it2 = it2next;
                ++j;
            }
            it1 = it1.nextItem;
            ++i;
        }
    }

    public static void removeOverlapNode2(RefList<? extends Point2d> r) {
        int i = 0;
        while (i < r.size()) {
            Point2d p1 = (Point2d)r.elementAt(i);
            Point2d p2 = (Point2d)r.elementAt(i + 1);
            if (ToolMath.isSame2D((double)p1.x, (double)p1.y, (double)p2.x, (double)p2.y)) {
                r.removeElement((Object)p2);
                --i;
            }
            ++i;
        }
    }

    public static <T extends Point2d> void removeParaNodes(RefList<T> r) {
        int count = r.size();
        Item it = r.itemAt(0);
        int i = 0;
        while (i < count) {
            Item itnext = it.nextItem;
            Point2d p1 = (Point2d)it.prevItem.getObject();
            Point2d p2 = (Point2d)it.getObject();
            Point2d p3 = (Point2d)it.nextItem.getObject();
            if (ToolMath.isOnLine((double)p1.x, (double)p1.y, (double)p2.x, (double)p2.y, (double)p2.x, (double)p2.y, (double)p3.x, (double)p3.y)) {
                r.removeItemAt(it);
            }
            it = itnext;
            ++i;
        }
    }

    public static boolean isOnEdge(RefList<? extends Point2d> polygon, double x, double y) {
        int i = 0;
        while (i < polygon.size()) {
            Point2d p1 = (Point2d)polygon.elementAt(i);
            Point2d p2 = (Point2d)polygon.elementAt(i + 1);
            if (ToolMath.isOnLimitLinePoint2D((double)x, (double)y, (double)p1.x, (double)p1.y, (double)p2.x, (double)p2.y)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isOverlap(RefList<? extends Point2d> pa, RefList<? extends Point2d> pb) {
        Point2d p;
        int i = 0;
        while (i < pa.size()) {
            p = (Point2d)pa.elementAt(i);
            if (ToolPolygon.isInnerPolygon(pb, p.x, p.y)) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < pb.size()) {
            p = (Point2d)pb.elementAt(i);
            if (ToolPolygon.isInnerPolygon(pa, p.x, p.y)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isHasCross(RefList<? extends Point2d> pa, RefList<? extends Point2d> pb) {
        int i = 0;
        while (i < pa.size()) {
            Point2d p1 = (Point2d)pa.elementAt(i);
            Point2d p2 = (Point2d)pa.elementAt(i + 1);
            int j = 0;
            while (j < pb.size()) {
                Point2d p4;
                Point2d p3 = (Point2d)pb.elementAt(j);
                if (ToolMathEx.isLimitLineCross2D(p1, p2, p3, p4 = (Point2d)pb.elementAt(j + 1), null)) {
                    return true;
                }
                if (ToolMathEx.isOnLimitLinePoint2D(p1, p3, p4) || ToolMathEx.isOnLimitLinePoint2D(p3, p1, p2)) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public static boolean isCompleteCrossLine(Point2d p1, Point2d p2, Point2d p3, Point2d p4) {
        double[] tmpf = new double[2];
        return ToolMath.isCrossSegment((double)p3.x, (double)p3.y, (double)p4.x, (double)p4.y, (double)p1.x, (double)p1.y, (double)p2.x, (double)p2.y, (double[])tmpf) && !ToolMath.isOnLine((double)p3.x, (double)p3.y, (double)p4.x, (double)p4.y, (double)p1.x, (double)p1.y, (double)p2.x, (double)p2.y) && !ToolMath.isSame2D((double)tmpf[0], (double)tmpf[1], (double)p3.x, (double)p3.y) && !ToolMath.isSame2D((double)tmpf[0], (double)tmpf[1], (double)p4.x, (double)p4.y) && !ToolMath.isSame2D((double)tmpf[0], (double)tmpf[1], (double)p1.x, (double)p1.y) && !ToolMath.isSame2D((double)tmpf[0], (double)tmpf[1], (double)p2.x, (double)p2.y);
    }

    public static boolean checkInclude(RefList<Point2d> A, RefList<Point2d> B) {
        RefList a = A.getCopy();
        RefList b = B.getCopy();
        ToolPolygon.intersect((RefList<Point2d>)a, (RefList<Point2d>)b);
        int i = 0;
        while (i < a.size()) {
            Point2d p1 = (Point2d)a.elementAt(i);
            Point2d p2 = (Point2d)a.elementAt(i + 1);
            double x = (p1.x + p2.x) / 2.0;
            double y = (p1.y + p2.y) / 2.0;
            if (!ToolPolygon.isInnerPolygon((RefList<? extends Point2d>)b, x, y)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isHasSelfCross(RefList<? extends Point2d> r) {
        double[] tmpf = new double[2];
        int i = 0;
        while (i < r.size() - 1) {
            int j = i + 1;
            while (j < r.size()) {
                Point2d pb;
                Point2d pa;
                Point2d p2;
                Point2d p1 = (Point2d)r.elementAt(i);
                if (ToolMathEx.isLimitLineCross2D(p1, p2 = (Point2d)r.elementAt(i + 1), pa = (Point2d)r.elementAt(j), pb = (Point2d)r.elementAt(j + 1), tmpf) && !ToolMath.isSame2D((double)p1.x, (double)p1.y, (double)tmpf[0], (double)tmpf[1]) && !ToolMath.isSame2D((double)p2.x, (double)p2.y, (double)tmpf[0], (double)tmpf[1])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private static void intersect(RefList<Point2d> a, RefList<Point2d> b) {
        int j;
        int i = 0;
        while (i < a.size()) {
            Point2d pa1 = (Point2d)a.elementAt(i);
            j = 0;
            while (j < b.size()) {
                Point2d pb1 = (Point2d)b.elementAt(j);
                Point2d pb2 = (Point2d)b.elementAt(j + 1);
                if (ToolMath.isOnLimitLinePoint2D((double)pa1.x, (double)pa1.y, (double)pb1.x, (double)pb1.y, (double)pb2.x, (double)pb2.y) && !ToolMath.isSame2D((double)pa1.x, (double)pa1.y, (double)pb1.x, (double)pb1.y) && !ToolMath.isSame2D((double)pa1.x, (double)pa1.y, (double)pb2.x, (double)pb2.y)) {
                    b.insertElementAt((Object)new Point2d(pa1.x, pa1.y), j);
                    break;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < b.size()) {
            Point2d pb1 = (Point2d)b.elementAt(i);
            j = 0;
            while (j < a.size()) {
                Point2d pa1 = (Point2d)b.elementAt(j);
                Point2d pa2 = (Point2d)b.elementAt(j + 1);
                if (ToolMath.isOnLimitLinePoint2D((double)pb1.x, (double)pb1.y, (double)pa1.x, (double)pa1.y, (double)pa2.x, (double)pa2.y) && !ToolMath.isSame2D((double)pb1.x, (double)pb1.y, (double)pa1.x, (double)pa1.y) && !ToolMath.isSame2D((double)pb1.x, (double)pb1.y, (double)pa2.x, (double)pa2.y)) {
                    a.insertElementAt((Object)new Point2d(pb1.x, pb1.y), j);
                    break;
                }
                ++j;
            }
            ++i;
        }
        double[] res = new double[2];
        Item ita = a.itemAt(0);
        do {
            Item itb = b.itemAt(0);
            do {
                Point2d atmp = (Point2d)ita.getObject();
                Point2d atmpn = (Point2d)ita.nextItem.getObject();
                Point2d btmp = (Point2d)itb.getObject();
                Point2d btmpn = (Point2d)itb.nextItem.getObject();
                if (ToolMath.isOnLine((double)atmp.x, (double)atmp.y, (double)atmpn.x, (double)atmpn.y, (double)btmp.x, (double)btmp.y, (double)btmpn.x, (double)btmpn.y) || !ToolMath.isCrossSegment((double)atmp.x, (double)atmp.y, (double)atmpn.x, (double)atmpn.y, (double)btmp.x, (double)btmp.y, (double)btmpn.x, (double)btmpn.y, (double[])res)) continue;
                if (!ToolMath.isSame2D((double)atmp.x, (double)atmp.y, (double)res[0], (double)res[1]) && !ToolMath.isSame2D((double)atmpn.x, (double)atmpn.y, (double)res[0], (double)res[1])) {
                    a.insertElementAt((Object)new Point2d(res[0], res[1]), ita);
                }
                if (ToolMath.isSame2D((double)btmp.x, (double)btmp.y, (double)res[0], (double)res[1]) || ToolMath.isSame2D((double)btmpn.x, (double)btmpn.y, (double)res[0], (double)res[1])) continue;
                b.insertElementAt((Object)new Point2d(res[0], res[1]), itb);
            } while ((itb = itb.nextItem) != b.itemAt(0));
        } while ((ita = ita.nextItem) != a.itemAt(0));
    }

    public boolean crossCheckArea(RefList<? extends Point2d> a, RefList<? extends Point2d> b) {
        Point2d p;
        double xa1 = Double.MAX_VALUE;
        double ya1 = Double.MAX_VALUE;
        double xa2 = -1.7976931348623157E308;
        double ya2 = -1.7976931348623157E308;
        double xb1 = Double.MAX_VALUE;
        double yb1 = Double.MAX_VALUE;
        double xb2 = -1.7976931348623157E308;
        double yb2 = -1.7976931348623157E308;
        int i = 0;
        while (i < a.size()) {
            p = (Point2d)a.elementAt(i);
            if (i == 0) {
                xa1 = xa2 = p.x;
                ya1 = ya2 = p.y;
            } else {
                xa1 = p.x < xa1 ? p.x : xa1;
                ya1 = p.y < ya1 ? p.y : ya1;
                xa2 = p.x > xa2 ? p.x : xa2;
                ya2 = p.y > ya2 ? p.y : ya2;
            }
            ++i;
        }
        i = 0;
        while (i < b.size()) {
            p = (Point2d)b.elementAt(i);
            if (i == 0) {
                xb1 = xb2 = p.x;
                yb1 = yb2 = p.y;
            } else {
                xb1 = p.x < xb1 ? p.x : xb1;
                yb1 = p.y < yb1 ? p.y : yb1;
                xb2 = p.x > xb2 ? p.x : xb2;
                yb2 = p.y > yb2 ? p.y : yb2;
            }
            ++i;
        }
        if (xb1 > xa2) {
            return false;
        }
        if (yb1 > ya2) {
            return false;
        }
        if (xa1 > xb2) {
            return false;
        }
        return !(ya1 > yb2);
    }

    public static boolean isHasCommonEdge(RefList<Point2d> a, RefList<Point2d> b) {
        ToolPolygon.intersect(a, b);
        ToolPolygon.intersect(b, a);
        int i = 0;
        while (i < a.size()) {
            Point2d p1 = (Point2d)a.elementAt(i);
            Point2d p2 = (Point2d)a.elementAt(i + 1);
            int j = 0;
            while (j < b.size()) {
                Point2d pa = (Point2d)b.elementAt(j);
                Point2d pb = (Point2d)b.elementAt(j + 1);
                if (ToolMath.isSameLine((double)p1.x, (double)p1.y, (double)p2.x, (double)p2.y, (double)pa.x, (double)pa.y, (double)pb.x, (double)pb.y)) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public static void removeOnLinePoint(RefList<? extends Point2d> pol) {
        int i = 0;
        while (i < pol.size()) {
            block6: {
                block4: {
                    Point2d p3;
                    Point2d p2;
                    Point2d p1;
                    block5: {
                        block3: {
                            p1 = (Point2d)pol.elementAt(i);
                            p2 = (Point2d)pol.elementAt(i + 1);
                            p3 = (Point2d)pol.elementAt(i + 2);
                            if (!ToolMathEx.isSame2D(p1, p2)) break block3;
                            pol.removeElement((Object)p2);
                            break block4;
                        }
                        if (!ToolMathEx.isOnLimitLinePoint2D(p1, p2, p3)) break block5;
                        pol.removeElement((Object)p2);
                        break block4;
                    }
                    if (!ToolMathEx.isOnLimitLinePoint2D(p3, p1, p2)) break block6;
                    pol.removeElement((Object)p2);
                }
                --i;
            }
            ++i;
        }
    }

    public static double getMinX(RefList<? extends Point2d> r) {
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < r.size()) {
            Point2d p = (Point2d)r.elementAt(i);
            min = p.x > min ? min : p.x;
            ++i;
        }
        return min;
    }

    public static double getMaxX(RefList<? extends Point2d> r) {
        double max = -1.7976931348623157E308;
        int i = 0;
        while (i < r.size()) {
            Point2d p = (Point2d)r.elementAt(i);
            max = p.x < max ? max : p.x;
            ++i;
        }
        return max;
    }

    public static double getMinY(RefList<? extends Point2d> r) {
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < r.size()) {
            Point2d p = (Point2d)r.elementAt(i);
            min = p.y > min ? min : p.y;
            ++i;
        }
        return min;
    }

    public static double getMaxY(RefList<? extends Point2d> r) {
        double max = -1.7976931348623157E308;
        int i = 0;
        while (i < r.size()) {
            Point2d p = (Point2d)r.elementAt(i);
            max = p.y < max ? max : p.y;
            ++i;
        }
        return max;
    }

    public static void getMinMax(RefList<? extends Point2d> r, double[] min, double[] max) {
        min[0] = Double.POSITIVE_INFINITY;
        min[1] = Double.POSITIVE_INFINITY;
        max[0] = Double.NEGATIVE_INFINITY;
        max[1] = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < r.size()) {
            Point2d p = (Point2d)r.elementAt(i);
            min[0] = Math.min(p.x, min[0]);
            min[1] = Math.min(p.y, min[1]);
            max[0] = Math.max(p.x, max[0]);
            max[1] = Math.max(p.y, max[1]);
            ++i;
        }
    }

    public static int check2PolygonRelation(RefList<Point2d> pa, RefList<Point2d> pb, boolean protectOrg) {
        Point2d p;
        RefList b;
        RefList a;
        if (protectOrg) {
            a = new RefList();
            int i = 0;
            while (i < pa.size()) {
                a.addElement((Object)((Point2d)pa.elementAt(i)));
                ++i;
            }
            b = new RefList();
            i = 0;
            while (i < pb.size()) {
                b.addElement((Object)((Point2d)pb.elementAt(i)));
                ++i;
            }
        } else {
            a = pa;
            b = pb;
        }
        double minx1 = Double.MAX_VALUE;
        double miny1 = Double.MAX_VALUE;
        double maxx1 = -1.7976931348623157E308;
        double maxy1 = -1.7976931348623157E308;
        double minx2 = Double.MAX_VALUE;
        double miny2 = Double.MAX_VALUE;
        double maxx2 = -1.7976931348623157E308;
        double maxy2 = -1.7976931348623157E308;
        int i = 0;
        while (i < a.size()) {
            p = (Point2d)a.elementAt(i);
            minx1 = minx1 < p.x ? minx1 : p.x;
            miny1 = miny1 < p.y ? miny1 : p.y;
            maxx1 = maxx1 > p.x ? maxx1 : p.x;
            maxy1 = maxy1 > p.y ? maxy1 : p.y;
            ++i;
        }
        i = 0;
        while (i < b.size()) {
            p = (Point2d)b.elementAt(i);
            minx2 = minx2 < p.x ? minx2 : p.x;
            miny2 = miny2 < p.y ? miny2 : p.y;
            maxx2 = maxx2 > p.x ? maxx2 : p.x;
            maxy2 = maxy2 > p.y ? maxy2 : p.y;
            ++i;
        }
        if (maxx1 < minx2 || maxx2 < minx1 || maxy1 < miny2 || maxy2 < miny1) {
            return 0;
        }
        if (ToolPolygon.checkInclude((RefList<Point2d>)a, (RefList<Point2d>)b)) {
            return 2;
        }
        if (ToolPolygon.checkInclude((RefList<Point2d>)b, (RefList<Point2d>)a)) {
            return 1;
        }
        return -1;
    }

    public static boolean isAddPolylineToPoint(RefList<? extends Point2d> r, double x, double y) {
        if (r.size() > 0) {
            Point2d p = (Point2d)r.lastElement();
            if (ToolMath.isSame2D((double)x, (double)y, (double)p.x, (double)p.y)) {
                return false;
            }
        }
        int i = 1;
        while (i < r.size()) {
            Point2d p = (Point2d)r.elementAt(i);
            if (ToolMath.isSame2D((double)x, (double)y, (double)p.x, (double)p.y)) {
                return false;
            }
            ++i;
        }
        if (r.size() < 3) {
            return true;
        }
        Point2d ps = (Point2d)r.elementAt(0);
        Point2d pe = (Point2d)r.lastElement();
        double[] tmpf = new double[2];
        int i2 = 0;
        while (i2 < r.size() - 1) {
            Point2d p1 = (Point2d)r.elementAt(i2);
            Point2d p2 = (Point2d)r.elementAt(i2 + 1);
            if (ToolMath.isSame2D((double)pe.x, (double)pe.y, (double)x, (double)y)) {
                return false;
            }
            if (ToolMath.isCrossSegment((double)p1.x, (double)p1.y, (double)p2.x, (double)p2.y, (double)pe.x, (double)pe.y, (double)x, (double)y, (double[])tmpf) && !ToolMath.isSame2D((double)pe.x, (double)pe.y, (double)tmpf[0], (double)tmpf[1]) && !ToolMath.isSame2D((double)ps.x, (double)ps.y, (double)tmpf[0], (double)tmpf[1])) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public static boolean getTriaRotation(double x1, double y1, double x2, double y2, double x3, double y3) {
        ((Point2d)triaList.elementAt(0)).set(x1, y1);
        ((Point2d)triaList.elementAt(1)).set(x2, y2);
        ((Point2d)triaList.elementAt(2)).set(x3, y3);
        return ToolPolygon.isCorrectRotation(triaList);
    }
}

