/*
 * Decompiled with CFR 0.152.
 */
package nethome5.util;

import javax.vecmath.Point2d;
import nethome5.util.ToolMath;

public class ToolMathEx
extends ToolMath {
    public static double getAngle2Lines(Point2d p1, Point2d p2, Point2d p3) {
        return ToolMathEx.getAngle2Lines((double)p1.x, (double)p1.y, (double)p2.x, (double)p2.y, (double)p3.x, (double)p3.y);
    }

    public static double getAngle2D(Point2d p1, Point2d p2) {
        return ToolMathEx.getAngle2D((double)p1.x, (double)p1.y, (double)p2.x, (double)p2.y);
    }

    public static void getSort(Point2d[] pts, Point2d p1) {
        double len2;
        double len1;
        if (pts[0] != null && pts[1] != null && (len1 = ToolMathEx.getLength2D((double)p1.x, (double)p1.y, (double)pts[0].x, (double)pts[0].y)) < (len2 = ToolMathEx.getLength2D((double)p1.x, (double)p1.y, (double)pts[1].x, (double)pts[1].y))) {
            Point2d tmp = pts[0];
            pts[0] = pts[1];
            pts[1] = tmp;
        }
    }

    public static double getLength2D(Point2d p1, Point2d p2) {
        return ToolMathEx.getLength2D((double)p1.x, (double)p1.y, (double)p2.x, (double)p2.y);
    }

    public static boolean isSame2D(Point2d p1, Point2d p2) {
        return ToolMathEx.isSame2D((double)p1.x, (double)p1.y, (double)p2.x, (double)p2.y);
    }

    public static boolean isSameLine(Point2d p1, Point2d p2, Point2d pa, Point2d pb) {
        return ToolMathEx.isSameLine((double)p1.x, (double)p1.y, (double)p2.x, (double)p2.y, (double)pa.x, (double)pa.y, (double)pb.x, (double)pb.y);
    }

    public static boolean inIncludeLine(Point2d p1, Point2d p2, Point2d p3, Point2d p4) {
        return ToolMathEx.inIncludeLine((double)p1.x, (double)p1.y, (double)p2.x, (double)p2.y, (double)p3.x, (double)p3.y, (double)p4.x, (double)p4.y);
    }

    public static double distanceLimitLineToPoint2D(double px, double py, Point2d p1, Point2d p2) {
        return ToolMathEx.getLengthLimitLineToPoint2D((double)px, (double)py, (double)p1.x, (double)p1.y, (double)p2.x, (double)p2.y);
    }

    public static boolean verticalLimitlessLineToPoint2D(double px, double py, Point2d p1, Point2d p2, double[] res) {
        return ToolMathEx.isCrossPointVertLimitlessLineToPoint2D((double)px, (double)py, (double)p1.x, (double)p1.y, (double)p2.x, (double)p2.y, (double[])res);
    }

    public static double distanceLimitlessLineToPoint2D(Point2d p, Point2d p1, Point2d p2) {
        return ToolMathEx.getLengthLimitlessLineToPoint2D((double)p.x, (double)p.y, (double)p1.x, (double)p1.y, (double)p2.x, (double)p2.y);
    }

    public static boolean isPointPickUporDown(double px, double py, Point2d p1, Point2d p2) {
        return ToolMathEx.isPointPickUporDown((double)px, (double)py, (double)p1.x, (double)p1.y, (double)p2.x, (double)p2.y);
    }

    public static void getOffsetPoint2D(Point2d p1, Point2d p2, double ofsx, double ofsy, double[] res) {
        ToolMathEx.getOffsetPoint2D((double)p1.x, (double)p1.y, (double)p2.x, (double)p2.y, (double)ofsx, (double)ofsy, (double[])res);
    }

    public static Point2d getOffsetPoint2D(Point2d p1, Point2d p2, double ofsx, double ofsy) {
        double[] tmpf = new double[2];
        ToolMathEx.getOffsetPoint2D((double)p1.x, (double)p1.y, (double)p2.x, (double)p2.y, (double)ofsx, (double)ofsy, (double[])tmpf);
        return new Point2d(tmpf[0], tmpf[1]);
    }

    public static boolean isLimitLineCross2D(Point2d p1, Point2d p2, Point2d pa, Point2d pb, double[] res) {
        return ToolMathEx.isCrossSegment((double)p1.x, (double)p1.y, (double)p2.x, (double)p2.y, (double)pa.x, (double)pa.y, (double)pb.x, (double)pb.y, (double[])res);
    }

    public static boolean isOnLine(Point2d ap1, Point2d ap2, Point2d bp1, Point2d bp2) {
        return ToolMathEx.isOnLine((double)ap1.x, (double)ap1.y, (double)ap2.x, (double)ap2.y, (double)bp1.x, (double)bp1.y, (double)bp2.x, (double)bp2.y);
    }

    public static boolean isOnLimitLinePoint2D(Point2d p, Point2d p1, Point2d p2) {
        return ToolMathEx.isOnLimitLinePoint2D((double)p.x, (double)p.y, (double)p1.x, (double)p1.y, (double)p2.x, (double)p2.y);
    }

    public static boolean isParallel2D(Point2d p1, Point2d p2, Point2d pa, Point2d pb) {
        return ToolMathEx.isParallel2D((double)p1.x, (double)p1.y, (double)p2.x, (double)p2.y, (double)pa.x, (double)pa.y, (double)pb.x, (double)pb.y);
    }

    public static boolean get2LineOffsetCross(double cx, double cy, double r, double s, double e, double x1, double y1, double x3, double y3, double ofs1, double ofs2, double[] tmp) {
        r += ofs1;
        ToolMathEx.getOffsetPoint2D((double)x1, (double)y1, (double)x3, (double)y3, (double)0.0, (double)ofs2, (double[])tmp);
        double p1x = ToolMathEx.norm((double)tmp[0]);
        double p1y = ToolMathEx.norm((double)tmp[1]);
        ToolMathEx.getOffsetPoint2D((double)x3, (double)y3, (double)x1, (double)y1, (double)0.0, (double)(-ofs2), (double[])tmp);
        double p3x = ToolMathEx.norm((double)tmp[0]);
        double p3y = ToolMathEx.norm((double)tmp[1]);
        ToolMathEx.isCrossArcAndLine(p1x, p1y, p3x, p3y, cx, cy, r, s, e);
        return false;
    }

    public static Point2d[] isCrossArcAndLine(double p1x, double p1y, double p2x, double p2y, double cx, double cy, double r, double s, double e) {
        Point2d[] pt = ToolMathEx.isCrossCircleAndLine(p1x, p1y, p2x, p2y, cx, cy, r);
        if (pt == null) {
            return null;
        }
        int i = 0;
        while (i < 2) {
            double angl;
            if (pt[i] != null && !ToolMath.isInnerAngl2PI((double)s, (double)e, (double)(angl = ToolMathEx.getAngl360((double)(ToolMathEx.getAngle2D((double)cx, (double)cy, (double)pt[i].x, (double)pt[i].y) * 180.0 / Math.PI))))) {
                pt[i] = null;
            }
            ++i;
        }
        if (pt[0] == null && pt[1] == null) {
            return null;
        }
        return pt;
    }

    public static Point2d[] isCrossCircleAndLine(double p1x, double p1y, double p2x, double p2y, double cx, double cy, double r) {
        Point2d[] pts = ToolMathEx.isCrossCircleAndLineNoLimit(p1x, p1y, p2x, p2y, cx, cy, r);
        if (pts == null) {
            return null;
        }
        if (pts[0] != null && !ToolMathEx.isOnLimitLinePoint2D((double)pts[0].x, (double)pts[0].y, (double)p1x, (double)p1y, (double)p2x, (double)p2y)) {
            pts[0] = null;
        }
        if (pts[1] != null && !ToolMathEx.isOnLimitLinePoint2D((double)pts[1].x, (double)pts[1].y, (double)p1x, (double)p1y, (double)p2x, (double)p2y)) {
            pts[1] = null;
        }
        if (pts[0] == null && pts[1] == null) {
            return null;
        }
        if (pts[0] == null) {
            pts[0] = pts[1];
            pts[1] = null;
        }
        return pts;
    }

    public static Point2d[] isCross2Circle(double x1, double y1, double r1, double x2, double y2, double r2) {
        double rksq = r1 * r1;
        double rlsq = r2 * r2;
        double xlk = x2 - x1;
        double ylk = y2 - y1;
        double distsq = xlk * xlk + ylk * ylk;
        if (distsq < (double)0.001f) {
            return null;
        }
        double sumrsq = rksq + rlsq;
        double delrsq = rlsq - rksq;
        double root = 2.0 * sumrsq * distsq - distsq * distsq - delrsq * delrsq;
        if (root < (double)-0.001f) {
            return null;
        }
        double dstinv = 0.5 / distsq;
        double scl = 0.5 - delrsq * dstinv;
        double x = xlk * scl + x1;
        double y = ylk * scl + y1;
        if (root < (double)0.001f) {
            return new Point2d[]{new Point2d(x, y)};
        }
        root = dstinv * Math.sqrt(root);
        double xfac = xlk * root;
        double yfac = ylk * root;
        return new Point2d[]{new Point2d(x - yfac, y + xfac), new Point2d(x + yfac, y - xfac)};
    }

    public static Point2d[] isCrossCircleAndLineNoLimit(double p1x, double p1y, double p2x, double p2y, double cx, double cy, double r) {
        double g;
        double gsq;
        double len = ToolMathEx.getLength2D((double)p1x, (double)p1y, (double)p2x, (double)p2y);
        double f = (p2x - p1x) / len;
        double fsq = f * f;
        double fgsq = fsq + (gsq = (g = (p2y - p1y) / len) * g);
        if (fgsq < -r / 100.0) {
            return null;
        }
        double yjo = cy - p1y;
        double xjo = cx - p1x;
        double fygx = f * yjo - g * xjo;
        double root = r * r * fgsq - fygx * fygx;
        if (root < -r / 100.0) {
            return null;
        }
        Point2d[] pts = new Point2d[2];
        double fxgy = f * xjo + g * yjo;
        if (root < (double)0.001f) {
            pts[0] = new Point2d();
            double t = fxgy / fgsq;
            pts[0].x = p1x + f * t;
            pts[0].y = p1y + g * t;
        } else {
            root = Math.sqrt(root);
            double t1 = (fxgy - root) / fgsq;
            double t2 = (fxgy + root) / fgsq;
            pts[0] = new Point2d();
            pts[1] = new Point2d();
            pts[0].x = p1x + f * t1;
            pts[0].y = p1y + g * t1;
            pts[1].x = p1x + f * t2;
            pts[1].y = p1y + g * t2;
        }
        return pts;
    }

    public static Point2d[] isCrossArc(double ckx, double cky, double ckr, double cks, double cke, double clx, double cly, double clr, double cls, double cle) {
        double al;
        double ak;
        Point2d[] pts = ToolMathEx.isCrossCircle(ckx, cky, ckr, clx, cly, clr);
        if (pts == null) {
            return null;
        }
        if (pts[0] != null) {
            ak = ToolMathEx.getAngle2D((double)ckx, (double)cky, (double)pts[0].x, (double)pts[0].y) * 180.0 / Math.PI;
            al = ToolMathEx.getAngle2D((double)clx, (double)cly, (double)pts[0].x, (double)pts[0].y) * 180.0 / Math.PI;
            if (!ToolMathEx.isInnerAngl2PI((double)cks, (double)cke, (double)ak) || !ToolMathEx.isInnerAngl2PI((double)cls, (double)cle, (double)al)) {
                pts[0] = null;
            }
        }
        if (pts[1] != null) {
            ak = ToolMathEx.getAngle2D((double)ckx, (double)cky, (double)pts[1].x, (double)pts[1].y) * 180.0 / Math.PI;
            al = ToolMathEx.getAngle2D((double)clx, (double)cly, (double)pts[1].x, (double)pts[1].y) * 180.0 / Math.PI;
            if (!ToolMathEx.isInnerAngl2PI((double)cks, (double)cke, (double)ak) || !ToolMathEx.isInnerAngl2PI((double)cls, (double)cle, (double)al)) {
                pts[1] = null;
            }
        }
        if (pts[0] == null && pts[1] == null) {
            return null;
        }
        if (pts[0] == null) {
            pts[0] = pts[1];
            pts[1] = null;
        }
        return pts;
    }

    public static Point2d[] isCrossCircle(double ckx, double cky, double ckr, double clx, double cly, double clr) {
        double rksq = ckr * ckr;
        double rlsq = clr * clr;
        double xlk = clx - ckx;
        double ylk = cly - cky;
        double distsq = xlk * xlk + ylk * ylk;
        if (distsq < (double)0.001f) {
            return null;
        }
        double sumrsq = rksq + rlsq;
        double delrsq = rlsq - rksq;
        double root = 2.0 * sumrsq * distsq - distsq * distsq - delrsq * delrsq;
        if (root < (double)-0.001f) {
            return null;
        }
        Point2d[] pts = new Point2d[2];
        double dstinv = 0.5 / distsq;
        double scl = 0.5 - delrsq * dstinv;
        double x = xlk * scl + ckx;
        double y = ylk * scl + cky;
        if (root < (double)0.001f) {
            pts[0] = new Point2d(x, y);
        } else {
            root = dstinv * Math.sqrt(root);
            double xfac = xlk * root;
            double yfac = ylk * root;
            pts[0] = new Point2d(x - yfac, y + xfac);
            pts[1] = new Point2d(x + yfac, y - xfac);
        }
        return pts;
    }
}

