/*
 * Decompiled with CFR 0.152.
 */
package nethome5.util;

import java.util.Vector;
import javax.vecmath.Point2d;
import jp.kitec.lib.util.Item;
import jp.kitec.lib.util.RefList;
import nethome5.util.LinkedPoint2Df;
import nethome5.util.ToolMath;
import nethome5.util.ToolPolygon;
import nethome5.util.TotsuHou;

public class ToolBooleanPolygon {
    private static final int SHARED = 0;
    private static final int INSIDE = 1;
    private static final int OUTSIDE = 2;

    public static RefList<LinkedPoint2Df> culcAdd(RefList<? extends Point2d> a, RefList<? extends Point2d> b) {
        RefList<LinkedPoint2Df> A = ToolBooleanPolygon.createLinkedList(a);
        RefList<LinkedPoint2Df> B = ToolBooleanPolygon.createLinkedList(b);
        RefList<LinkedPoint2Df> result = null;
        if (ToolBooleanPolygon.preCulcBoolean(A, B)) {
            result = ToolBooleanPolygon.addition(A, B);
        }
        A.removeAllElements();
        B.removeAllElements();
        return result;
    }

    public static RefList<RefList<LinkedPoint2Df>> culcSub(RefList<? extends Point2d> a, RefList<? extends Point2d> b) {
        RefList<LinkedPoint2Df> A = ToolBooleanPolygon.createLinkedList(a);
        RefList<LinkedPoint2Df> B = ToolBooleanPolygon.createLinkedList(b);
        RefList res = null;
        if (ToolBooleanPolygon.preCulcBoolean(A, B)) {
            res = ToolBooleanPolygon.subtraction(A, B);
        } else {
            boolean AincludeB = ToolBooleanPolygon.checkInclude(A, B, false);
            boolean BincludeA = ToolBooleanPolygon.checkInclude(B, A, false);
            if (AincludeB && BincludeA) {
                res = null;
            } else if (!AincludeB && !BincludeA || AincludeB) {
                res = new RefList();
                res.addElement(A);
            } else if (BincludeA) {
                res = null;
            }
        }
        return res;
    }

    private static boolean checkInclude(RefList<LinkedPoint2Df> a, RefList<LinkedPoint2Df> b, boolean flag) {
        int i = 0;
        while (i < a.size()) {
            Point2d pa = (Point2d)a.elementAt(i);
            Point2d pb = (Point2d)a.elementAt(i + 1);
            double x = (pa.x + pb.x) / 2.0;
            double y = (pa.y + pb.y) / 2.0;
            if (!ToolPolygon.isInnerPolygon(b, x, y)) {
                return false;
            }
            if (flag && ToolBooleanPolygon.checkOnEdge(b, x, y)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean checkOnEdge(RefList<LinkedPoint2Df> l, double x, double y) {
        int i = 0;
        while (i < l.size()) {
            Point2d p1 = (Point2d)l.elementAt(i);
            Point2d p2 = (Point2d)l.elementAt(i + 1);
            if (ToolMath.isOnLimitLinePoint2D((double)x, (double)y, (double)p1.x, (double)p1.y, (double)p2.x, (double)p2.y)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isSame(Object p1, Object p2) {
        if (p1 != null && p2 != null && p1 instanceof Point2d && p2 instanceof Point2d) {
            Point2d gp1 = (Point2d)p1;
            Point2d gp2 = (Point2d)p2;
            return ToolMath.isSame2D((double)gp1.x, (double)gp1.y, (double)gp2.x, (double)gp2.y);
        }
        return false;
    }

    private static RefList<LinkedPoint2Df> createLinkedList(RefList<? extends Point2d> r) {
        RefList ll = new RefList();
        int i = 0;
        while (i < r.size()) {
            Point2d gp = (Point2d)r.elementAt(i);
            ll.addElement((Object)new LinkedPoint2Df(gp.x, gp.y));
            ++i;
        }
        return ll;
    }

    private static boolean preCulcBoolean(RefList<LinkedPoint2Df> a, RefList<LinkedPoint2Df> b) {
        ToolPolygon.removeOverlapNode(a);
        ToolPolygon.removeOverlapNode(b);
        ToolBooleanPolygon.initializePolygon(a);
        ToolBooleanPolygon.initializePolygon(b);
        ToolBooleanPolygon.addLink(a, b);
        if (!ToolBooleanPolygon.checkLink(a)) {
            return false;
        }
        ToolBooleanPolygon.setNodeState(a, b);
        ToolBooleanPolygon.setNodeState(b, a);
        return true;
    }

    private static void initializePolygon(RefList<LinkedPoint2Df> list) {
        Item cur = list.itemAt(0);
        do {
            ((LinkedPoint2Df)((Object)cur.getObject())).flag = -1;
            ((LinkedPoint2Df)((Object)cur.getObject())).mLink = null;
        } while ((cur = cur.nextItem) != list.itemAt(0));
    }

    private static boolean checkLink(RefList<LinkedPoint2Df> a) {
        int count = 0;
        int i = 0;
        while (i < a.size()) {
            if (((LinkedPoint2Df)((Object)a.elementAt((int)i))).mLink != null) {
                ++count;
            }
            ++i;
        }
        return count > 1;
    }

    private static void addLink(RefList<LinkedPoint2Df> a, RefList<LinkedPoint2Df> b) {
        Item ita = a.itemAt(0);
        do {
            Item itb = b.itemAt(0);
            do {
                LinkedPoint2Df atmp = (LinkedPoint2Df)((Object)ita.getObject());
                LinkedPoint2Df btmp = (LinkedPoint2Df)((Object)itb.getObject());
                if (!(ToolMath.getLength2D((double)atmp.x, (double)atmp.y, (double)btmp.x, (double)btmp.y) < (double)0.001f)) continue;
                atmp.mLink = itb;
                btmp.mLink = ita;
            } while ((itb = itb.nextItem) != b.itemAt(0));
        } while ((ita = ita.nextItem) != a.itemAt(0));
    }

    private static void setNodeState(RefList<LinkedPoint2Df> a, RefList<LinkedPoint2Df> b) {
        Item head = null;
        int i = 0;
        while (i < a.size()) {
            if (((LinkedPoint2Df)((Object)a.elementAt((int)i))).mLink != null) {
                head = a.itemAt(i);
                break;
            }
            ++i;
        }
        if (head == null) {
            return;
        }
        Item cur = head;
        int prev = -1;
        do {
            if (((LinkedPoint2Df)((Object)cur.getObject())).flag != 2 && ((LinkedPoint2Df)((Object)cur.getObject())).flag >= 0) continue;
            Item<LinkedPoint2Df> b1 = ((LinkedPoint2Df)((Object)cur.getObject())).mLink;
            Item<LinkedPoint2Df> b2 = ((LinkedPoint2Df)((Object)cur.nextItem.getObject())).mLink;
            if (b1 != null && b2 != null && (b1.nextItem == b2 || b2.nextItem == b1)) {
                prev = 0;
                ((LinkedPoint2Df)((Object)cur.getObject())).flag = 0;
                continue;
            }
            if (b1 != null) {
                LinkedPoint2Df pc = (LinkedPoint2Df)((Object)cur.getObject());
                LinkedPoint2Df pn = (LinkedPoint2Df)((Object)cur.nextItem.getObject());
                LinkedPoint2Df pa = (LinkedPoint2Df)((Object)b1.prevItem.getObject());
                LinkedPoint2Df pb = (LinkedPoint2Df)((Object)b1.nextItem.getObject());
                double angl1 = ToolMath.getAngle2D((double)pc.x, (double)pc.y, (double)pb.x, (double)pb.y);
                double angl2 = ToolMath.getAngle2D((double)pc.x, (double)pc.y, (double)pn.x, (double)pn.y);
                double angl3 = ToolMath.getAngle2D((double)pc.x, (double)pc.y, (double)pa.x, (double)pa.y);
                if ((angl2 = ToolMath.getAngl2PI((double)(angl2 - angl1))) <= (angl3 = ToolMath.getAngl2PI((double)(angl3 - angl1)))) {
                    prev = 1;
                    ((LinkedPoint2Df)((Object)cur.getObject())).flag = 1;
                    continue;
                }
                prev = 2;
                ((LinkedPoint2Df)((Object)cur.getObject())).flag = 2;
                continue;
            }
            ((LinkedPoint2Df)((Object)cur.getObject())).flag = prev;
        } while ((cur = cur.nextItem) != head);
    }

    private static boolean isIncludeNode(RefList<RefList<LinkedPoint2Df>> resultAll, LinkedPoint2Df lp) {
        if (resultAll.size() == 0) {
            return false;
        }
        Item it = resultAll.itemAt(0);
        int i = 0;
        while (i < resultAll.size()) {
            RefList lpl = (RefList)it.getObject();
            Item it2 = lpl.itemAt(0);
            int j = 0;
            while (j < lpl.size()) {
                if (ToolBooleanPolygon.isSame((Object)lp, it2.getObject())) {
                    return true;
                }
                it2 = it2.nextItem;
                ++j;
            }
            it = it.nextItem;
            ++i;
        }
        return false;
    }

    private static RefList<LinkedPoint2Df> addition(RefList<LinkedPoint2Df> a, RefList<LinkedPoint2Df> b) {
        Item<LinkedPoint2Df> it = ToolBooleanPolygon.serchHead(a, b);
        if (it == null) {
            return null;
        }
        RefList<LinkedPoint2Df> res = ToolBooleanPolygon.gatherAdd(it, a.size() + b.size());
        if (res != null) {
            ToolPolygon.removeOverlapNode(res);
        }
        return res;
    }

    private static RefList<RefList<LinkedPoint2Df>> subtraction(RefList<LinkedPoint2Df> a, RefList<LinkedPoint2Df> b) {
        RefList resultAll = new RefList();
        Item it = a.itemAt(0);
        int i = 0;
        while (i < a.size()) {
            LinkedPoint2Df lp = (LinkedPoint2Df)((Object)it.getObject());
            if (lp.flag == 2 && !ToolBooleanPolygon.isIncludeNode((RefList<RefList<LinkedPoint2Df>>)resultAll, lp)) {
                RefList<LinkedPoint2Df> res = ToolBooleanPolygon.gatherSub((Item<LinkedPoint2Df>)it, a.size() + b.size());
                if (res != null) {
                    ToolPolygon.removeOverlapNode(res);
                    resultAll.addElement(res);
                } else {
                    System.out.println("*** fatal err ***");
                }
            }
            it = it.nextItem;
            ++i;
        }
        if (resultAll.size() != 0) {
            return resultAll;
        }
        return null;
    }

    private static RefList<LinkedPoint2Df> gatherAdd(Item<LinkedPoint2Df> start, int size) {
        Item<LinkedPoint2Df> cur = start;
        RefList result = new RefList();
        result.addElement((Object)new LinkedPoint2Df((LinkedPoint2Df)((Object)start.getObject())));
        do {
            Item<LinkedPoint2Df> cn = cur;
            if (((LinkedPoint2Df)((Object)cn.getObject())).flag == 0 && ((LinkedPoint2Df)((Object)cn.getObject())).mLink.nextItem == ((LinkedPoint2Df)((Object)cn.nextItem.getObject())).mLink) {
                ((LinkedPoint2Df)((Object)((LinkedPoint2Df)((Object)cn.getObject())).mLink.getObject())).flag = 0;
            }
            cur = cur.nextItem;
            if (((LinkedPoint2Df)((Object)cur.getObject())).mLink != null) {
                if (((LinkedPoint2Df)((Object)((LinkedPoint2Df)((Object)cur.getObject())).mLink.prevItem.getObject())).flag == 1) {
                    cur = ((LinkedPoint2Df)((Object)cur.getObject())).mLink;
                } else if (((LinkedPoint2Df)((Object)((LinkedPoint2Df)((Object)cur.getObject())).mLink.getObject())).flag == 2 || ((LinkedPoint2Df)((Object)((LinkedPoint2Df)((Object)cur.getObject())).mLink.getObject())).flag == 0) {
                    cur = ((LinkedPoint2Df)((Object)cur.getObject())).mLink;
                }
            }
            if (!ToolBooleanPolygon.isSame(cur.getObject(), start.getObject())) {
                result.addElement((Object)new LinkedPoint2Df((LinkedPoint2Df)((Object)cur.getObject())));
            }
            if (result.size() <= size) continue;
            return null;
        } while (!ToolBooleanPolygon.isSame(cur.getObject(), start.getObject()));
        return result;
    }

    private static RefList<LinkedPoint2Df> gatherSub(Item<LinkedPoint2Df> start, int size) {
        Item<LinkedPoint2Df> cur = start;
        boolean flag = true;
        RefList result = new RefList();
        LinkedPoint2Df gp = (LinkedPoint2Df)((Object)start.getObject());
        LinkedPoint2Df startl = new LinkedPoint2Df(gp.x, gp.y);
        startl.flagObj = gp.flagObj;
        result.addElement((Object)startl);
        do {
            Item<LinkedPoint2Df> cn;
            Item<LinkedPoint2Df> item = cn = flag ? cur : cur.prevItem;
            if (((LinkedPoint2Df)((Object)cn.getObject())).flag == 0 && ((LinkedPoint2Df)((Object)cn.getObject())).mLink.nextItem == ((LinkedPoint2Df)((Object)cn.nextItem.getObject())).mLink) {
                ((LinkedPoint2Df)((Object)((LinkedPoint2Df)((Object)cn.getObject())).mLink.getObject())).flag = 0;
            }
            Item<LinkedPoint2Df> item2 = cur = flag ? cur.nextItem : cur.prevItem;
            if (!flag && ((LinkedPoint2Df)((Object)cur.prevItem.getObject())).flagObj != null) {
                ((LinkedPoint2Df)((Object)cur.getObject())).flagObj = ((LinkedPoint2Df)((Object)cur.prevItem.getObject())).flagObj;
            }
            if (((LinkedPoint2Df)((Object)cur.getObject())).mLink != null) {
                if (flag) {
                    if (((LinkedPoint2Df)((Object)((LinkedPoint2Df)((Object)cur.getObject())).mLink.prevItem.getObject())).flag == 1) {
                        flag = false;
                        cur = ((LinkedPoint2Df)((Object)cur.getObject())).mLink;
                        LinkedPoint2Df lpc = (LinkedPoint2Df)((Object)cur.getObject());
                        LinkedPoint2Df lpp = (LinkedPoint2Df)((Object)cur.prevItem.getObject());
                        if (lpp.flagObj != null) {
                            lpc.flagObj = lpp.flagObj;
                            lpp.flagObj = null;
                        }
                    }
                } else if (((LinkedPoint2Df)((Object)((LinkedPoint2Df)((Object)cur.getObject())).mLink.getObject())).flag == 2 || ((LinkedPoint2Df)((Object)((LinkedPoint2Df)((Object)cur.getObject())).mLink.getObject())).flag == 0) {
                    flag = true;
                    cur = ((LinkedPoint2Df)((Object)cur.getObject())).mLink;
                }
            }
            if (!ToolBooleanPolygon.isSame(cur.getObject(), start.getObject())) {
                result.addElement((Object)new LinkedPoint2Df((LinkedPoint2Df)((Object)cur.getObject())));
            }
            if (result.size() <= size) continue;
            return null;
        } while (!ToolBooleanPolygon.isSame(cur.getObject(), start.getObject()));
        return result;
    }

    private static Item<LinkedPoint2Df> serchHead(RefList<LinkedPoint2Df> a, RefList<LinkedPoint2Df> b) {
        Vector<Point2d> v = new Vector<Point2d>();
        Item it = b.itemAt(0);
        int i = 0;
        while (i < b.size()) {
            Point2d gp = (Point2d)it.getObject();
            v.addElement(new Point2d(gp.x, gp.y));
            it = it.nextItem;
            ++i;
        }
        it = a.itemAt(0);
        i = 0;
        while (i < a.size()) {
            Point2d p1 = (Point2d)it.getObject();
            boolean same = false;
            Item it2 = b.itemAt(0);
            int j = 0;
            while (j < b.size()) {
                Point2d p2 = (Point2d)it2.getObject();
                if (ToolBooleanPolygon.isSame(p1, p2)) {
                    same = true;
                    break;
                }
                it2 = it2.nextItem;
                ++j;
            }
            if (!same) {
                Point2d gp = (Point2d)it.getObject();
                v.addElement(new Point2d(gp.x, gp.y));
            }
            it = it.nextItem;
            ++i;
        }
        Vector<Point2d> res = TotsuHou.getTotshuhou(v);
        if (res == null) {
            return null;
        }
        int i2 = 0;
        while (i2 < res.size()) {
            it = a.itemAt(0);
            int j = 0;
            while (j < a.size()) {
                if (ToolBooleanPolygon.isSame(res.elementAt(i2), it.getObject()) && ((LinkedPoint2Df)((Object)it.getObject())).flag == 2) {
                    return it;
                }
                it = it.nextItem;
                ++j;
            }
            it = b.itemAt(0);
            j = 0;
            while (j < b.size()) {
                if (ToolBooleanPolygon.isSame(res.elementAt(i2), it.getObject()) && ((LinkedPoint2Df)((Object)it.getObject())).flag == 2) {
                    return it;
                }
                it = it.nextItem;
                ++j;
            }
            ++i2;
        }
        return null;
    }
}

