/*
 * Decompiled with CFR 0.152.
 */
package nethome5.presentation.primitive.draw;

import javax.vecmath.Point2d;
import jp.kitec.lib.kwt.IRichGraphics;
import jp.kitec.lib.kwt.KColor;
import jp.kitec.lib.kwt.KFill;
import jp.kitec.lib.kwt.KLineType;
import nethome5.presentation.LocalAxis2Df;
import nethome5.presentation.primitive.DrawParameters;
import nethome5.presentation.primitive.GLine;
import nethome5.presentation.primitive.GPoint2Df;
import nethome5.presentation.primitive.draw.AbstractCustomDrawer;

public class GLineDrawer
extends AbstractCustomDrawer<GLine> {
    @Override
    public void drawHighLight(IRichGraphics d, DrawParameters params, boolean outline) {
        if (outline) {
            this.draw(d, params);
        }
        Point2d pA = ((GLine)this.mGeom).getA();
        Point2d pB = ((GLine)this.mGeom).getB();
        GPoint2Df.drawHighLight(d, params, pA.x, pA.y);
        GPoint2Df.drawHighLight(d, params, pB.x, pB.y);
    }

    @Override
    public void doDraw(IRichGraphics d, DrawParameters params) {
        double y2;
        double x2;
        double y1;
        double x1;
        KColor fore = params.get(DrawParameters.KEY_DRAW_COLOR, ((GLine)this.mGeom).getGeomColor());
        LocalAxis2Df la = params.get(DrawParameters.KEY_LOCAL_AXIS, null);
        KLineType lineType = params.get(DrawParameters.KEY_LINE_TYPE, ((GLine)this.mGeom).getLineType());
        Point2d pA = ((GLine)this.mGeom).getA();
        Point2d pB = ((GLine)this.mGeom).getB();
        if (la != null) {
            x1 = la.getGlobalX(pA.x, pA.y);
            y1 = la.getGlobalY(pA.x, pA.y);
            x2 = la.getGlobalX(pB.x, pB.y);
            y2 = la.getGlobalY(pB.x, pB.y);
        } else {
            x1 = pA.x;
            y1 = pA.y;
            x2 = pB.x;
            y2 = pB.y;
        }
        d.setColor((KFill)fore);
        d.drawLine(x1, y1, x2, y2, lineType);
    }
}

