/*
 * Decompiled with CFR 0.152.
 */
package nethome5.presentation.primitive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Point2d;
import jp.kitec.lib.kwt.KArea;
import jp.kitec.lib.kwt.KColor;
import jp.kitec.lib.util.RefList;
import jp.kitec.lib.util.tree.ObjectFolder;
import jp.kitec.lib.util.tree.ObjectNode;
import jp.kitec.vecmath.KPoint2d;
import nethome5.presentation.GeomName;
import nethome5.presentation.GeomParser;
import nethome5.presentation.primitive.GCurve;
import nethome5.presentation.primitive.Geometry;
import nethome5.util.ToolMath;
import nethome5.util.ToolPolygon;

@GeomName(name="RECT")
public class GRect
extends GCurve {
    protected List<KPoint2d> mPoints;

    public GRect() {
        this(0.0, 0.0, 0.0, 0.0, false);
    }

    public GRect(double x1, double y1, double x2, double y2, boolean fill) {
        this(x1, y1, x2, y1, x2, y2, x1, y2, fill);
    }

    public GRect(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4, boolean fill) {
        this.mGeomColor = KColor.BLACK;
        this.mFillColor = KColor.BLACK;
        this.mFill = fill;
        this.mPoints = new ArrayList<KPoint2d>();
        this.mPoints.add(new KPoint2d(x1, y1));
        this.mPoints.add(new KPoint2d(x2, y2));
        this.mPoints.add(new KPoint2d(x3, y3));
        this.mPoints.add(new KPoint2d(x4, y4));
    }

    public Point2d getP1() {
        return (Point2d)this.mPoints.get(0);
    }

    public Point2d getP2() {
        return (Point2d)this.mPoints.get(2);
    }

    @Override
    public boolean isClosed() {
        return true;
    }

    public List<KPoint2d> getPoints() {
        return Collections.unmodifiableList(this.mPoints);
    }

    public void setRect(double x1, double y1, double x2, double y2) {
        double xa = x1 < x2 ? x1 : x2;
        double ya = y1 < y2 ? y1 : y2;
        double xb = x1 > x2 ? x1 : x2;
        double yb = y1 > y2 ? y1 : y2;
        int i = 0;
        while (i < 4) {
            Point2d p = (Point2d)this.mPoints.get(i);
            p.x = i == 0 || i == 3 ? xa : xb;
            p.y = i == 0 || i == 1 ? ya : yb;
            ++i;
        }
    }

    @Override
    public void updateMinMax(KArea area) {
        int i = 0;
        while (i < this.mPoints.size()) {
            Point2d p = (Point2d)this.mPoints.get(i);
            area.updateMinMax(p.x, p.y);
            ++i;
        }
    }

    @Override
    public GRect copy() {
        return this.copyTo(new GRect());
    }

    @Override
    protected GRect copyTo(Geometry g) {
        if (g == null || !(g instanceof GRect)) {
            return null;
        }
        GRect pl = (GRect)g;
        super.copyTo(pl);
        double x1 = this.mPoints.get((int)0).x;
        double y1 = this.mPoints.get((int)0).y;
        double x3 = this.mPoints.get((int)2).x;
        double y3 = this.mPoints.get((int)2).y;
        pl.setRect(x1, y1, x3, y3);
        pl.setFillMode(this.mFill);
        pl.setFillColor(this.mFillColor);
        return pl;
    }

    @Override
    public double getDistanceToPoint(double x, double y) {
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < this.mPoints.size()) {
            Point2d p1 = (Point2d)this.mPoints.get(i);
            Point2d p2 = (Point2d)this.mPoints.get((i + 1) % this.mPoints.size());
            double len = ToolMath.getLengthLimitLineToPoint2D((double)x, (double)y, (double)p1.x, (double)p1.y, (double)p2.x, (double)p2.y);
            if (len >= 0.0 && len < min) {
                min = len;
            }
            ++i;
        }
        return min;
    }

    @Override
    public boolean isInner(double minx, double miny, double maxx, double maxy) {
        int i = 0;
        while (i < this.mPoints.size()) {
            Point2d p1 = (Point2d)this.mPoints.get(i);
            if (!(p1.x > minx && p1.x < maxx && p1.y > miny && p1.y < maxy)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean isInner(RefList<Point2d> v) {
        int i = 0;
        while (i < this.mPoints.size()) {
            Point2d p1 = (Point2d)this.mPoints.get(i);
            Point2d p2 = (Point2d)this.mPoints.get((i + 1) % this.mPoints.size());
            boolean b1 = ToolPolygon.isInnerPolygon(v, p1.x, p1.y);
            boolean b2 = ToolPolygon.isInnerPolygon(v, p2.x, p2.y);
            if (!b1 || !b2) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void save(ObjectFolder savenode) {
        if (savenode == null) {
            return;
        }
        super.save(savenode);
        int i = 0;
        while (i < this.mPoints.size()) {
            Point2d p = (Point2d)this.mPoints.get(i);
            savenode.addChild(new ObjectNode("x" + (i + 1), (Object)Double.toString(p.x)));
            savenode.addChild(new ObjectNode("y" + (i + 1), (Object)Double.toString(p.y)));
            ++i;
        }
    }

    public static void readData(ObjectFolder of, Geometry g, GeomParser ps) throws Exception {
        GRect gp = null;
        if (!(g instanceof GRect)) {
            return;
        }
        GCurve.readData(of, g, ps);
        gp = (GRect)g;
        gp.mPoints = new ArrayList<KPoint2d>();
        int i = 0;
        while (i < 4) {
            double x = 0.0;
            double y = 0.0;
            ObjectNode on = of.getNode("x" + (i + 1));
            if (on != null) {
                x = Double.valueOf((String)on.getObject());
            }
            if ((on = of.getNode("y" + (i + 1))) != null) {
                y = Double.valueOf((String)on.getObject());
            }
            gp.mPoints.add(new KPoint2d(x, y));
            ++i;
        }
    }

    protected void updateShape() {
        Point2d p1 = (Point2d)this.mPoints.get(0);
        Point2d p2 = (Point2d)this.mPoints.get(1);
        Point2d p3 = (Point2d)this.mPoints.get(2);
        Point2d p4 = (Point2d)this.mPoints.get(3);
        p2.x = p3.x;
        p2.y = p1.y;
        p4.x = p1.x;
        p4.y = p3.y;
    }
}

