/*
 * Decompiled with CFR 0.152.
 */
package nethome5.presentation.pick;

import java.io.Serializable;
import java.util.List;
import nethome5.presentation.pick.GeometryPicker;
import nethome5.presentation.primitive.GGroup;
import nethome5.presentation.primitive.Geometry;

public abstract class AbstractGeometryPicker
implements GeometryPicker,
Serializable {
    protected Object searchKey;
    protected Object traverseKey;

    public AbstractGeometryPicker() {
        this(null, null);
    }

    public AbstractGeometryPicker(Object searchKey, Object traverseKey) {
        this.searchKey = searchKey;
        this.traverseKey = traverseKey;
    }

    @Override
    public void pick(double x, double y, Geometry g, List<Geometry> list) {
        GGroup group;
        if (g instanceof GGroup && (group = (GGroup)g).isTraverseChildren()) {
            if (this.traverseKey != null && group.getUserProperty(this.traverseKey) == null) {
                return;
            }
            int n = group.getChildCount();
            int i = 0;
            while (i < n) {
                this.pick(x, y, group.getChild(i), list);
                ++i;
            }
            return;
        }
        if (this.searchKey != null && g.getUserProperty(this.searchKey) == null) {
            return;
        }
        if (this.isNear(g, x, y)) {
            list.add(g);
        }
    }

    protected abstract boolean isNear(Geometry var1, double var2, double var4);
}

