/*
 * Decompiled with CFR 0.152.
 */
package nethome5.presentation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Point2d;
import jp.kitec.lib.kwt.KArea;
import jp.kitec.lib.util.Vector2;
import jp.kitec.vecmath.KPoint2d;

public class WorkSheet
implements Serializable {
    public static final int NEAR_GRID2_THRESHOLD_DIVIDE = 30;
    public static final int DEF_NEAR_GRID_DIVIDE = 50;
    private String mName;
    private double mModule;
    private final KArea mArea = new KArea();
    private int mGridDiv = 1;
    private double mGridCenterX;
    private double mGridCenterY;
    private Vector2<Double> mExtraGridX;
    private Vector2<Double> mExtraGridY;
    private final List<KPoint2d> mAreaPolygon = new ArrayList<KPoint2d>();

    public WorkSheet getCopy() {
        WorkSheet ws = new WorkSheet();
        ws.setName(this.getName());
        ws.setArea(this.mArea.minX, this.mArea.minY, this.mArea.maxX, this.mArea.maxY);
        ws.mGridDiv = this.mGridDiv;
        ws.mModule = this.mModule;
        ws.mGridCenterX = this.mGridCenterX;
        ws.mGridCenterY = this.mGridCenterY;
        return ws;
    }

    public void setName(String s) {
        this.mName = s;
    }

    public String getName() {
        return this.mName;
    }

    public void setArea(double minx, double miny, double maxx, double maxy) {
        this.mArea.maximize();
        this.mArea.updateMinMax(minx, miny);
        this.mArea.updateMinMax(maxx, maxy);
        this.mAreaPolygon.clear();
        this.mAreaPolygon.add(new KPoint2d(minx, miny));
        this.mAreaPolygon.add(new KPoint2d(maxx, miny));
        this.mAreaPolygon.add(new KPoint2d(maxx, maxy));
        this.mAreaPolygon.add(new KPoint2d(minx, maxy));
    }

    public KArea getArea() {
        return this.mArea;
    }

    public void updateArea() {
        this.mArea.maximize();
        int i = 0;
        while (i < this.mAreaPolygon.size()) {
            Point2d p = (Point2d)this.mAreaPolygon.get(i);
            this.mArea.updateMinMax(p.x, p.y);
            ++i;
        }
    }

    public List<KPoint2d> getAreaPolygon() {
        return Collections.unmodifiableList(this.mAreaPolygon);
    }

    public double getModule() {
        return this.mModule;
    }

    public void setModule(double f) {
        if (f < 0.0) {
            throw new IllegalArgumentException();
        }
        this.mModule = f;
    }

    public void setGridDivide(int i) {
        if (i <= 0) {
            throw new IllegalArgumentException();
        }
        this.mGridDiv = i;
    }

    public int getGridDivide() {
        return this.mGridDiv;
    }

    public double getCurrentGrid() {
        return this.mModule / (double)this.mGridDiv;
    }

    public void setGridCenter(double x, double y) {
        this.mGridCenterX = x;
        this.mGridCenterY = y;
    }

    public double getGridCenterX() {
        return this.mGridCenterX;
    }

    public double getGridCenterY() {
        return this.mGridCenterY;
    }

    public double getNearGridX(double x, boolean extra) {
        return this.getNearGrid(x, extra, this.getCurrentGrid(), this.getGridCenterX(), this.mExtraGridX);
    }

    public double getNearGridY(double y, boolean extra) {
        return this.getNearGrid(y, extra, this.getCurrentGrid(), this.getGridCenterY(), this.mExtraGridY);
    }

    private double getNearGrid(double v, boolean extra, double currentGrid, double gridCenter, Vector2<Double> extraGrid) {
        double len;
        if (currentGrid == 0.0) {
            return v;
        }
        double near = Double.MAX_VALUE;
        int step = v <= gridCenter ? -1 : 1;
        int c = (int)Math.floor((v - gridCenter) / currentGrid * (double)step);
        while (near > (len = Math.abs(v - (gridCenter + currentGrid * (double)c * (double)step)))) {
            near = len;
            ++c;
        }
        double gridcandidate = (double)(step * (c - 1)) * currentGrid + gridCenter;
        if (extra && extraGrid != null) {
            int i = 0;
            while (i < extraGrid.size()) {
                double f = (Double)extraGrid.elementAt(i);
                double len2 = Math.abs(v - f);
                if (len2 < near) {
                    gridcandidate = f;
                    near = len2;
                }
                ++i;
            }
        }
        return gridcandidate;
    }

    public double getDefNearGridX(double x) {
        double near = Double.MAX_VALUE;
        double div = this.getModule() / 50.0;
        int c = (int)((x - x % div) / div);
        int res = 0;
        int i = c - 1;
        while (i <= c + 1) {
            if (Math.abs(div * (double)i - x) < near) {
                near = Math.abs(div * (double)i - x);
                res = i;
            }
            ++i;
        }
        return (double)res * div;
    }

    public double getDefNearGridY(double y) {
        double near = Double.MAX_VALUE;
        double div = this.getModule() / 50.0;
        int c = (int)((y - y % div) / div);
        int res = 0;
        int i = c - 1;
        while (i <= c + 1) {
            if (Math.abs(div * (double)i - y) < near) {
                near = Math.abs(div * (double)i - y);
                res = i;
            }
            ++i;
        }
        return (double)res * div;
    }

    public boolean isOnGridX(double x) {
        double xx = this.getNearGridX(x, true);
        return Math.abs(xx - x) < (double)0.001f;
    }

    public boolean isOnGridY(double y) {
        double yy = this.getNearGridY(y, true);
        return Math.abs(yy - y) < (double)0.001f;
    }

    public boolean isOnBaseGridX(double x) {
        double c = Math.abs(x % this.mModule);
        return c < (double)0.001f || Math.abs(c - this.mModule) < (double)0.001f;
    }

    public boolean isOnBaseGridY(double y) {
        double c = Math.abs(y % this.mModule);
        return c < (double)0.001f || Math.abs(c - this.mModule) < (double)0.001f;
    }

    public double getNearGridX2(double x, boolean dir) {
        double candx2;
        double candx1;
        if (this.getCurrentGrid() == 0.0) {
            return x;
        }
        int ss = (int)Math.floor((x - this.getGridCenterX()) / this.getCurrentGrid());
        double candx = this.getGridCenterX() + (double)ss * this.getCurrentGrid();
        if (candx < x) {
            candx1 = candx;
            candx2 = this.getGridCenterX() + (double)(ss + 1) * this.getCurrentGrid();
        } else {
            candx1 = this.getGridCenterX() + (double)(ss - 1) * this.getCurrentGrid();
            candx2 = candx;
        }
        if (Math.abs(candx1 - x) < this.getCurrentGrid() / 30.0) {
            return candx1;
        }
        if (Math.abs(candx2 - x) < this.getCurrentGrid() / 30.0) {
            return candx2;
        }
        if (this.mExtraGridX != null) {
            int i = 0;
            while (i < this.mExtraGridX.size()) {
                double f = (Double)this.mExtraGridX.elementAt(i);
                if (Math.abs(f - x) < this.getCurrentGrid() / 30.0) {
                    return f;
                }
                if (candx1 < f && x > f) {
                    candx1 = f;
                }
                if (x < f && candx2 > f) {
                    candx2 = f;
                }
                ++i;
            }
        }
        if (dir) {
            return candx2;
        }
        return candx1;
    }

    public double getNearGridY2(double y, boolean dir) {
        double candy2;
        double candy1;
        if (this.getCurrentGrid() == 0.0) {
            return y;
        }
        int ss = (int)Math.floor((y - this.getGridCenterY()) / this.getCurrentGrid());
        double candy = this.getGridCenterY() + (double)ss * this.getCurrentGrid();
        if (candy < y) {
            candy1 = candy;
            candy2 = this.getGridCenterY() + (double)(ss + 1) * this.getCurrentGrid();
        } else {
            candy1 = this.getGridCenterY() + (double)(ss - 1) * this.getCurrentGrid();
            candy2 = candy;
        }
        if (Math.abs(candy1 - y) < this.getCurrentGrid() / 30.0) {
            return candy1;
        }
        if (Math.abs(candy2 - y) < this.getCurrentGrid() / 30.0) {
            return candy2;
        }
        if (this.mExtraGridY != null) {
            int i = 0;
            while (i < this.mExtraGridY.size()) {
                double f = (Double)this.mExtraGridY.elementAt(i);
                if (Math.abs(f - y) < this.getCurrentGrid() / 30.0) {
                    return f;
                }
                if (candy1 < f && y > f) {
                    candy1 = f;
                }
                if (y < f && candy2 > f) {
                    candy2 = f;
                }
                ++i;
            }
        }
        if (dir) {
            return candy2;
        }
        return candy1;
    }

    public int getNearNotExtraGrid(double x, double bx, double module) {
        double len;
        double near = Double.MAX_VALUE;
        int step = x <= bx ? -1 : 1;
        int c = (int)Math.floor((x - bx) / module * (double)step);
        while (near > (len = Math.abs(x - (bx + module * (double)c * (double)step)))) {
            near = len;
            ++c;
        }
        return step * (c - 1);
    }

    public Vector2<Double> getExtraGridX() {
        return this.mExtraGridX;
    }

    public Vector2<Double> getExtraGridY() {
        return this.mExtraGridY;
    }

    public boolean addExtraGridX(double x) {
        if (Math.abs(this.getNearGridX(x, true) - x) < (double)0.001f) {
            return false;
        }
        if (this.mExtraGridX == null) {
            this.mExtraGridX = new Vector2();
        }
        int i = 0;
        while (i < this.mExtraGridX.size()) {
            Double f = (Double)this.mExtraGridX.elementAt(i);
            if (f == x) {
                return false;
            }
            ++i;
        }
        this.mExtraGridX.addElement((Object)new Double(x));
        return true;
    }

    public boolean addExtraGridY(double y) {
        if (Math.abs(this.getNearGridY(y, true) - y) < (double)0.001f) {
            return false;
        }
        if (this.mExtraGridY == null) {
            this.mExtraGridY = new Vector2();
        }
        int i = 0;
        while (i < this.mExtraGridY.size()) {
            Double f = (Double)this.mExtraGridY.elementAt(i);
            if (Math.abs(f - y) < (double)0.001f) {
                return false;
            }
            ++i;
        }
        this.mExtraGridY.addElement((Object)new Double(y));
        return true;
    }
}

