/*
 * Decompiled with CFR 0.152.
 */
package nethome5.presentation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jp.kitec.lib.kwt.KArea;
import jp.kitec.lib.util.tree.ObjectFolder;
import jp.kitec.lib.util.tree.ObjectNode;
import nethome5.doc.Document;
import nethome5.presentation.WorkSheet;
import nethome5.presentation.pick.DistanceGeometryPicker;
import nethome5.presentation.pick.GeometryPicker;
import nethome5.presentation.primitive.Element;
import nethome5.presentation.primitive.GGroup;
import nethome5.presentation.primitive.Geometry;

public class PresentationLayer
implements Serializable {
    private String mName;
    private boolean mVisible;
    protected List<Geometry> mPrims;

    public PresentationLayer() {
        this(null, new WorkSheet());
    }

    public PresentationLayer(WorkSheet ws) {
        this(null, ws);
    }

    public PresentationLayer(String name, WorkSheet ws) {
        this.mName = name;
        this.mPrims = new ArrayList<Geometry>();
        this.mVisible = true;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public void renumberID() {
        int i = 0;
        while (i < this.mPrims.size()) {
            Element g = this.mPrims.get(i);
            g.setID(i + 1);
            ++i;
        }
    }

    public void save(ObjectFolder savenode) {
        savenode.setName("LAYER");
        savenode.addChild(new ObjectNode("TYPE", (Object)"LAYER"));
        int i = 0;
        while (i < this.mPrims.size()) {
            Element g = this.mPrims.get(i);
            ObjectFolder of = new ObjectFolder("");
            g.save(of);
            savenode.addChild((ObjectNode)of, true);
            ++i;
        }
    }

    public List<Geometry> getGeometries(double x, double y, double eps) {
        ArrayList<Geometry> list = new ArrayList<Geometry>();
        DistanceGeometryPicker defaultPicker = new DistanceGeometryPicker(eps);
        for (Geometry g : this.mPrims) {
            defaultPicker.pick(x, y, g, list);
        }
        return list;
    }

    public List<Geometry> getGeometries(double x, double y, GeometryPicker picker) {
        ArrayList<Geometry> list = new ArrayList<Geometry>();
        for (Geometry g : this.mPrims) {
            picker.pick(x, y, g, list);
        }
        return list;
    }

    public List<Geometry> getGeometriesIn(KArea area) {
        ArrayList<Geometry> list = new ArrayList<Geometry>();
        for (Geometry g : this.mPrims) {
            this.getGeometriesIn(area, g, list);
        }
        return list;
    }

    protected void getGeometriesIn(KArea area, Geometry g, List<Geometry> list) {
        GGroup group;
        if (g instanceof GGroup && (group = (GGroup)g).isTraverseChildren()) {
            int n = group.getChildCount();
            int i = 0;
            while (i < n) {
                this.getGeometriesIn(area, group.getChild(i), list);
                ++i;
            }
            return;
        }
        if (g.isInner(area.minX, area.minY, area.maxX, area.maxY)) {
            list.add(g);
        }
    }

    public void refresh() {
        this.mPrims.clear();
        this.mVisible = true;
    }

    public boolean isHasData() {
        return !this.mPrims.isEmpty();
    }

    public static Object readData(ObjectFolder of, Document doc, float version) throws Exception {
        return null;
    }

    public boolean isVisible() {
        return this.mVisible;
    }

    public void setVisible(boolean b) {
        this.mVisible = b;
    }

    public List<Geometry> getPrims() {
        return this.mPrims;
    }

    public void setPrims(List<? extends Geometry> v) {
        this.mPrims.clear();
        this.mPrims.addAll(v);
    }

    public void addPrimitive(Geometry p) {
        this.mPrims.add(p);
    }

    public void removePrimitive(Geometry p) {
        this.mPrims.remove(p);
    }

    public void deleteAll() {
        this.mPrims.clear();
    }
}

