/*
 * Decompiled with CFR 0.152.
 */
package nethome5.presentation;

import java.io.Serializable;
import jp.kitec.lib.geom.KLocalAxis;
import jp.kitec.lib.util.tree.ObjectFolder;
import jp.kitec.lib.util.tree.ObjectNode;
import nethome5.util.ToolMath;

public class LocalAxis2Df
implements KLocalAxis,
Serializable {
    public double mX;
    public double mY;
    public double mRot;
    private boolean mFlipX = false;
    private boolean mFlipY = false;
    private boolean scaleEnableX = false;
    private boolean scaleEnableY = false;
    private double mScaleX = 1.0;
    private double mScaleY = 1.0;

    public LocalAxis2Df() {
        this.mX = 0.0;
        this.mY = 0.0;
        this.mRot = 0.0;
        this.mFlipY = false;
        this.mFlipX = false;
    }

    public double getScaleX() {
        return this.mScaleX;
    }

    public double getScaleY() {
        return this.mScaleY;
    }

    public void setScaleX(double x, boolean aspect) {
        if (!this.scaleEnableX && !this.scaleEnableY) {
            this.mScaleY = 1.0;
            this.mScaleX = 1.0;
            return;
        }
        if (!this.scaleEnableX) {
            this.mScaleX = 1.0;
            return;
        }
        this.mScaleX = x;
        if (aspect) {
            this.mScaleY = x;
        }
    }

    public void setScaleY(double y, boolean aspect) {
        if (!this.scaleEnableX && !this.scaleEnableY) {
            this.mScaleY = 1.0;
            this.mScaleX = 1.0;
            return;
        }
        if (!this.scaleEnableY) {
            this.mScaleY = 1.0;
            return;
        }
        this.mScaleY = y;
        if (aspect) {
            this.mScaleX = y;
        }
    }

    public void setScale(double x, double y) {
        if (!this.scaleEnableX && !this.scaleEnableY) {
            this.mScaleY = 1.0;
            this.mScaleX = 1.0;
            return;
        }
        this.mScaleX = x;
        this.mScaleY = y;
    }

    public void setScaleEnable(boolean x, boolean y) {
        this.scaleEnableX = x;
        this.scaleEnableY = y;
    }

    public boolean isScaleEnableX() {
        return this.scaleEnableX;
    }

    public boolean isScaleEnableY() {
        return this.scaleEnableY;
    }

    public LocalAxis2Df(double x1, double y1, double x2, double y2) {
        this.mFlipY = false;
        this.mFlipX = false;
        this.scaleEnableY = false;
        this.scaleEnableX = false;
        this.setLocalCoordinates(x1, y1, x2, y2, this.mFlipX, this.mFlipY);
    }

    public LocalAxis2Df(LocalAxis2Df lc) {
        this.setLocalCoordinates(lc.mX, lc.mY, lc.mRot, lc.mFlipX, lc.mFlipY);
        this.setScale(lc.mScaleX, lc.mScaleY);
        this.setScaleEnable(lc.scaleEnableX, lc.scaleEnableY);
    }

    public static LocalAxis2Df readData(ObjectFolder of) throws Exception {
        double cx = 0.0;
        double cy = 0.0;
        double angl = 0.0;
        double scalex = 1.0;
        double scaley = 1.0;
        boolean fx = false;
        boolean fy = false;
        ObjectNode on = null;
        on = of.getNode("cx");
        if (on != null) {
            cx = Double.valueOf((String)on.getObject()).intValue();
        }
        if ((on = of.getNode("cy")) != null) {
            cy = Double.valueOf((String)on.getObject()).intValue();
        }
        if ((on = of.getNode("angl")) != null) {
            angl = Double.valueOf((String)on.getObject());
        }
        if ((on = of.getNode("fx")) != null) {
            fx = Boolean.valueOf((String)on.getObject());
        }
        if ((on = of.getNode("fy")) != null) {
            fy = Boolean.valueOf((String)on.getObject());
        }
        if ((on = of.getNode("scalex")) != null) {
            scalex = Double.valueOf((String)on.getObject());
        }
        if ((on = of.getNode("scaley")) != null) {
            scaley = Double.valueOf((String)on.getObject());
        }
        LocalAxis2Df la = new LocalAxis2Df();
        la.mX = cx;
        la.mY = cy;
        la.mRot = angl;
        la.mFlipX = fx;
        la.mFlipY = fy;
        la.mScaleX = scalex;
        la.mScaleY = scaley;
        return la;
    }

    public void save(ObjectFolder parent) {
        if (parent == null) {
            return;
        }
        parent.setName("AXIS");
        parent.addChild(new ObjectNode("cx", (Object)Double.toString(this.mX)));
        parent.addChild(new ObjectNode("cy", (Object)Double.toString(this.mY)));
        parent.addChild(new ObjectNode("angl", (Object)Double.toString(this.mRot)));
        parent.addChild(new ObjectNode("fx", (Object)Boolean.toString(this.mFlipX)));
        parent.addChild(new ObjectNode("fy", (Object)Boolean.toString(this.mFlipY)));
        parent.addChild(new ObjectNode("scalex", (Object)Double.toString(this.mScaleX)));
        parent.addChild(new ObjectNode("scaley", (Object)Double.toString(this.mScaleY)));
    }

    public void setLocalCoordinates(double x1, double y1, double x2, double y2, boolean fx, boolean fy) {
        this.setLocalCoordinates(x1, y1, ToolMath.getAngle2D((double)x1, (double)y1, (double)x2, (double)y2), fx, fy);
    }

    public void setLocalCoordinates(double x, double y, double rot, boolean fx, boolean fy) {
        this.mX = x;
        this.mY = y;
        this.mRot = rot;
        this.mFlipX = fx;
        this.mFlipY = fy;
    }

    public void setLocalCoordinates(LocalAxis2Df lc) {
        this.mX = lc.mX;
        this.mY = lc.mY;
        this.mRot = lc.mRot;
        this.mFlipX = lc.mFlipX;
        this.mFlipY = lc.mFlipY;
        this.mScaleX = lc.mScaleX;
        this.mScaleY = lc.mScaleY;
        this.scaleEnableX = lc.scaleEnableX;
        this.scaleEnableY = lc.scaleEnableY;
    }

    public boolean getFlipX() {
        return this.mFlipX;
    }

    public void setFlipX(boolean f) {
        this.mFlipX = f;
    }

    public boolean getFlipY() {
        return this.mFlipY;
    }

    public void setFlipY(boolean f) {
        this.mFlipY = f;
    }

    public double getGlobalX(double x, double y) {
        if (this.mFlipX) {
            x = -x;
        }
        if (this.mFlipY) {
            y = -y;
        }
        double val = x * Math.cos(this.mRot) - y * Math.sin(this.mRot) + this.mX;
        return val;
    }

    public double getGlobalY(double x, double y) {
        if (this.mFlipX) {
            x = -x;
        }
        if (this.mFlipY) {
            y = -y;
        }
        double val = x * Math.sin(this.mRot) + y * Math.cos(this.mRot) + this.mY;
        return val;
    }

    public double getScaledX(double x, double y, boolean keepaspect, boolean sx, boolean sy, double bx, double by) {
        double scalex = keepaspect ? (!this.scaleEnableX && !this.scaleEnableY ? 1.0 : (this.scaleEnableX && this.scaleEnableY ? Math.max(this.mScaleX, this.mScaleY) : (this.scaleEnableX ? this.mScaleX : this.mScaleY))) : (sx ? this.mScaleX : 1.0);
        double xx = (x - bx) * scalex;
        double val = xx + bx;
        return val;
    }

    public double getScaledY(double x, double y, boolean keepaspect, boolean sx, boolean sy, double bx, double by) {
        double scaley = keepaspect ? (!this.scaleEnableX && !this.scaleEnableY ? 1.0 : (this.scaleEnableX && this.scaleEnableY ? Math.max(this.mScaleX, this.mScaleY) : (this.scaleEnableX ? this.mScaleX : this.mScaleY))) : (sy ? this.mScaleY : 1.0);
        double yy = (y - by) * scaley;
        double val = yy + by;
        return val;
    }

    public double getGlobalX(double x, double y, boolean keepaspect, boolean sx, boolean sy, double bx, double by) {
        double scalex;
        double scaley;
        if (keepaspect) {
            if (!this.scaleEnableX && !this.scaleEnableY) {
                scaley = 1.0;
                scalex = 1.0;
            } else {
                scalex = this.scaleEnableX && this.scaleEnableY ? (scaley = Math.max(this.mScaleX, this.mScaleY)) : (this.scaleEnableX ? (scaley = this.mScaleX) : (scaley = this.mScaleY));
            }
        } else {
            scalex = sx ? this.mScaleX : 1.0;
            scaley = sy ? this.mScaleY : 1.0;
        }
        double xx = (x - bx) * scalex;
        double yy = (y - by) * scaley;
        if (this.mFlipX) {
            xx = -xx;
            bx = -bx;
        }
        if (this.mFlipY) {
            yy = -yy;
            by = -by;
        }
        double val = (xx + bx) * Math.cos(this.mRot) - (yy + by) * Math.sin(this.mRot) + this.mX;
        return val;
    }

    public double getGlobalY(double x, double y, boolean keepaspect, boolean sx, boolean sy, double bx, double by) {
        double scalex;
        double scaley;
        if (keepaspect) {
            if (!this.scaleEnableX && !this.scaleEnableY) {
                scaley = 1.0;
                scalex = 1.0;
            } else {
                scalex = this.scaleEnableX && this.scaleEnableY ? (scaley = Math.max(this.mScaleX, this.mScaleY)) : (this.scaleEnableX ? (scaley = this.mScaleX) : (scaley = this.mScaleY));
            }
        } else {
            scalex = sx ? this.mScaleX : 1.0;
            scaley = sy ? this.mScaleY : 1.0;
        }
        double xx = (x - bx) * scalex;
        double yy = (y - by) * scaley;
        if (this.mFlipX) {
            xx = -xx;
            bx = -bx;
        }
        if (this.mFlipY) {
            yy = -yy;
            by = -by;
        }
        double val = (xx + bx) * Math.sin(this.mRot) + (yy + by) * Math.cos(this.mRot) + this.mY;
        return val;
    }

    public double getGlobalLength(double len) {
        return len * this.mScaleX;
    }

    public double getLocalX(double x, double y) {
        double val = (x - this.mX) * Math.cos(-this.mRot) - (y - this.mY) * Math.sin(-this.mRot);
        if (this.mFlipX) {
            val = -val;
        }
        return val;
    }

    public double getLocalY(double x, double y) {
        double val = (x - this.mX) * Math.sin(-this.mRot) + (y - this.mY) * Math.cos(-this.mRot);
        if (this.mFlipY) {
            val = -val;
        }
        return val;
    }

    public double getGlobalAngl(double rad) {
        rad += this.mRot;
        if (this.mFlipX) {
            rad = Math.PI - rad;
        }
        if (this.mFlipY) {
            rad = -rad;
        }
        return ToolMath.getAngl2PI((double)rad);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mFlipX ? 1231 : 1237);
        result = 31 * result + (this.mFlipY ? 1231 : 1237);
        long bits = Double.doubleToLongBits(this.mRot);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = Double.doubleToLongBits(this.mScaleX);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = Double.doubleToLongBits(this.mScaleY);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = Double.doubleToLongBits(this.mX);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        bits = Double.doubleToLongBits(this.mY);
        result = 31 * result + (int)(bits ^ bits >>> 32);
        result = 31 * result + (this.scaleEnableX ? 1231 : 1237);
        result = 31 * result + (this.scaleEnableY ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocalAxis2Df other = (LocalAxis2Df)obj;
        if (this.mFlipX != other.mFlipX) {
            return false;
        }
        if (this.mFlipY != other.mFlipY) {
            return false;
        }
        if (Double.doubleToLongBits(this.mRot) != Double.doubleToLongBits(other.mRot)) {
            return false;
        }
        if (Double.doubleToLongBits(this.mScaleX) != Double.doubleToLongBits(other.mScaleX)) {
            return false;
        }
        if (Double.doubleToLongBits(this.mScaleY) != Double.doubleToLongBits(other.mScaleY)) {
            return false;
        }
        if (Double.doubleToLongBits(this.mX) != Double.doubleToLongBits(other.mX)) {
            return false;
        }
        if (Double.doubleToLongBits(this.mY) != Double.doubleToLongBits(other.mY)) {
            return false;
        }
        if (this.scaleEnableX != other.scaleEnableX) {
            return false;
        }
        return this.scaleEnableY == other.scaleEnableY;
    }
}

