/*
 * Decompiled with CFR 0.152.
 */
package nethome5.presentation.primitive.draw;

import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import jp.kitec.lib.kwt.IRichGraphics;
import jp.kitec.lib.kwt.KArcType;
import jp.kitec.lib.kwt.KColor;
import jp.kitec.lib.kwt.KFill;
import jp.kitec.lib.kwt.KLineType;
import nethome5.presentation.LocalAxis2Df;
import nethome5.presentation.primitive.DrawParameters;
import nethome5.presentation.primitive.GCircle;
import nethome5.presentation.primitive.GPoint2Df;
import nethome5.presentation.primitive.draw.AbstractCustomDrawer;

public class GCircleDrawer
extends AbstractCustomDrawer<GCircle> {
    @Override
    protected void doDraw(IRichGraphics d, DrawParameters params) {
        double e;
        double s;
        double y1;
        double x1;
        KColor fore = params.get(DrawParameters.KEY_DRAW_COLOR, ((GCircle)this.mGeom).getGeomColor());
        KFill back = params.get(DrawParameters.KEY_FILL_COLOR, ((GCircle)this.mGeom).getFillColor());
        boolean fill = params.get(DrawParameters.KEY_FILL, true) != false && ((GCircle)this.mGeom).isFillMode();
        LocalAxis2Df la = params.get(DrawParameters.KEY_LOCAL_AXIS, null);
        KLineType lineType = params.get(DrawParameters.KEY_LINE_TYPE, ((GCircle)this.mGeom).getLineType());
        double cx = ((GCircle)this.mGeom).getX();
        double cy = ((GCircle)this.mGeom).getY();
        double angle = ((GCircle)this.mGeom).getAngle();
        double start = ((GCircle)this.mGeom).getStart();
        double sweep = ((GCircle)this.mGeom).getSweep();
        double w = ((GCircle)this.mGeom).getRx();
        double h = ((GCircle)this.mGeom).getRy();
        KArcType arcType = ((GCircle)this.mGeom).getArcType();
        if (la == null) {
            x1 = cx;
            y1 = cy;
        } else {
            x1 = la.getGlobalX(cx, cy);
            y1 = la.getGlobalY(cx, cy);
            start = la.getGlobalAngl(start);
            angle = la.getGlobalAngl(angle);
            w = la.getGlobalLength(w);
            h = la.getGlobalLength(h);
        }
        if (sweep > 0.0) {
            s = start;
            e = start + sweep;
        } else {
            s = start + sweep;
            e = start;
        }
        if (Math.abs(w - h) < (double)0.001f && Math.abs(angle) < (double)0.001f) {
            double r = (w + h) / 2.0;
            if (fill && back != null) {
                d.setColor(back);
                d.drawFillCircle(x1, y1, r, s * 57.29577951308232, e * 57.29577951308232, arcType, null);
            }
            if (((GCircle)this.mGeom).isDrawLine()) {
                d.setColor((KFill)fore);
                d.drawCircle(x1, y1, r, s * 57.29577951308232, e * 57.29577951308232, arcType, lineType);
            }
        } else {
            if (fill && back != null) {
                d.setColor(back);
                d.pathInit(4096);
                this.pathArc(d, x1, y1, w, h, s, e, angle);
                if (arcType == KArcType.PIE && !((GCircle)this.mGeom).isClosed()) {
                    d.pathLineTo(x1, y1, null);
                }
                d.fillPath(null);
            }
            if (((GCircle)this.mGeom).isDrawLine()) {
                d.setColor((KFill)fore);
                d.pathInit(4096);
                this.pathArc(d, x1, y1, w, h, s, e, angle);
                if (arcType == KArcType.PIE && !((GCircle)this.mGeom).isClosed()) {
                    d.pathLineTo(x1, y1, null);
                }
                if (arcType == KArcType.CHORD || arcType == KArcType.PIE) {
                    d.pathClose();
                }
                d.drawPath(lineType);
            }
        }
    }

    @Override
    public void drawHighLight(IRichGraphics d, DrawParameters params, boolean outline) {
        if (outline) {
            DrawParameters p = new DrawParameters(params);
            p.put(DrawParameters.KEY_FILL, false);
            this.draw(d, p);
        }
        for (int i = 0; i < ((GCircle)this.mGeom).getMaxPts().size(); ++i) {
            Point2d pt = ((GCircle)this.mGeom).getMaxPts().get(i);
            GPoint2Df.drawHighLight(d, params, pt.x, pt.y);
        }
    }

    @Override
    public void draw(IRichGraphics d) {
        DrawParameters mNullParameter = new DrawParameters();
        this.draw(d, mNullParameter);
    }

    protected void pathArc(IRichGraphics d, double cx, double cy, double rx, double ry, double start, double end, double rot) {
        double div = 4.0;
        double ath = end - start;
        double theta = ath / div;
        double cos = Math.cos(theta);
        double sin = Math.sin(theta);
        double[] x = new double[4];
        double[] y = new double[4];
        x[1] = 1.0;
        x[0] = 1.0;
        y[0] = 0.0;
        x[3] = cos;
        y[3] = sin;
        x[2] = (8.0 * Math.cos(theta / 2.0) - (x[0] + 3.0 * x[1] + x[3])) / 3.0;
        y[2] = y[3] - (-x[2] + x[3]) / -Math.tan(theta);
        y[1] = (8.0 * Math.sin(theta / 2.0) - (y[0] + 3.0 * y[2] + y[3])) / 3.0;
        double scos = Math.cos(start);
        double ssin = Math.sin(start);
        for (int j = 0; j < 4; ++j) {
            double xtmp = x[j] * scos - y[j] * ssin;
            double ytmp = x[j] * ssin + y[j] * scos;
            x[j] = xtmp;
            y[j] = ytmp;
        }
        Vector2d dx = new Vector2d(Math.cos(rot), Math.sin(rot));
        Vector2d dy = new Vector2d(Math.cos(rot + 1.5707963267948966), Math.sin(rot + 1.5707963267948966));
        double x0 = rx * x[0];
        double y0 = ry * y[0];
        d.pathMoveTo(x0 * dx.x + y0 * dy.x + cx, x0 * dx.y + y0 * dy.y + cy, null);
        int i = 0;
        while ((double)i < div) {
            double x1 = rx * x[1];
            double y1 = ry * y[1];
            double x2 = rx * x[2];
            double y2 = ry * y[2];
            double x3 = rx * x[3];
            double y3 = ry * y[3];
            d.pathCurveTo(x1 * dx.x + y1 * dy.x + cx, x1 * dx.y + y1 * dy.y + cy, x2 * dx.x + y2 * dy.x + cx, x2 * dx.y + y2 * dy.y + cy, x3 * dx.x + y3 * dy.x + cx, x3 * dx.y + y3 * dy.y + cy, null);
            for (int j = 1; j < 4; ++j) {
                double xtmp = x[j] * cos - y[j] * sin;
                double ytmp = x[j] * sin + y[j] * cos;
                x[j] = xtmp;
                y[j] = ytmp;
            }
            ++i;
        }
    }
}

