/*
 * Decompiled with CFR 0.152.
 */
package nethome5.presentation.primitive.draw;

import javax.vecmath.Point2d;
import jp.kitec.lib.kwt.IRichGraphics;
import jp.kitec.lib.kwt.KArea;
import jp.kitec.lib.kwt.KColor;
import jp.kitec.lib.kwt.KFill;
import jp.kitec.lib.kwt.KFont;
import jp.kitec.lib.kwt.KFontMetrics;
import nethome5.NethomeCoreResource;
import nethome5.presentation.LocalAxis2Df;
import nethome5.presentation.primitive.DrawParameters;
import nethome5.presentation.primitive.GText;
import nethome5.presentation.primitive.draw.AbstractCustomDrawer;
import nethome5.util.ToolMath;

public class GTextDrawer
extends AbstractCustomDrawer<GText> {
    @Override
    public void drawHighLight(IRichGraphics d, DrawParameters params, boolean outline) {
    }

    @Override
    protected void doDraw(IRichGraphics d, DrawParameters params) {
        KColor fore = params.get(DrawParameters.KEY_DRAW_COLOR, ((GText)this.mGeom).getGeomColor());
        KFill back = params.get(DrawParameters.KEY_FILL_COLOR, ((GText)this.mGeom).getFillColor());
        LocalAxis2Df la = params.get(DrawParameters.KEY_LOCAL_AXIS, null);
        boolean mDir = ((GText)this.mGeom).isDir();
        Point2d mCp = ((GText)this.mGeom).getCenter();
        double mAngl = ((GText)this.mGeom).getAngle();
        float mSize = ((GText)this.mGeom).getSize();
        String mText = ((GText)this.mGeom).getText();
        ((GText)this.mGeom).update();
        KFont scaleFont = NethomeCoreResource.getScaleFont((String)((GText)this.mGeom).getScaleFontName());
        double scale = mSize / (float)NethomeCoreResource.SCALEFONTSIZE;
        KFontMetrics fontMetrics = scaleFont.getFontMetrics((Object)d);
        if (mDir) {
            double y;
            double x;
            double cx = mCp.x;
            double cy = mCp.y;
            double angl = mAngl;
            double textw = fontMetrics.stringWidth(mText) * scale;
            double size = mSize;
            double[] _tmpf = new double[2];
            if (la != null) {
                angl += la.mRot * 180.0 / Math.PI;
                double tx = la.getGlobalX(cx, cy);
                double ty = la.getGlobalY(cx, cy);
                cx = tx;
                cy = ty;
                size = (double)mSize * la.getScaleX();
                if (la.getFlipY()) {
                    angl += 180.0;
                }
                ToolMath.rotation2D((double)0.0, (double)0.0, (double)(angl * (Math.PI / 180)), (double)(-textw / 2.0), (double)(-((fontMetrics.getAscent() - fontMetrics.getDescent()) * scale) / 2.0 * 1.0), (double[])_tmpf);
                x = cx + _tmpf[0] * la.getScaleX();
                y = cy + _tmpf[1] * la.getScaleX();
            } else {
                ToolMath.rotation2D((double)0.0, (double)0.0, (double)(angl * (Math.PI / 180)), (double)(-textw / 2.0), (double)(-((fontMetrics.getAscent() - fontMetrics.getDescent()) * scale) / 2.0 * 1.0), (double[])_tmpf);
                x = cx + _tmpf[0];
                y = cy + _tmpf[1];
            }
            d.setColor((KFill)fore);
            d.drawText(mText, x, y, scaleFont.getName(), scaleFont.getStyle(), (double)((float)size), angl);
        } else {
            KArea area = new KArea();
            ((GText)this.mGeom).updateMinMax(area);
            for (int i = 0; i < mText.length(); ++i) {
                String ss = mText.substring(i, i + 1);
                double wid = fontMetrics.stringWidth(ss) * scale;
                double hei = fontMetrics.getHeight() * scale;
                double size = (fontMetrics.getDescent() + fontMetrics.getAscent()) * scale;
                double x1 = mCp.x - wid / 2.0;
                double y1 = area.maxY - size * (double)(i + 1);
                double x2 = x1 + wid;
                double y2 = y1 + hei;
                double cx = (x1 + x2) / 2.0;
                double cy = (y1 + y2) / 2.0;
                double ofs = fontMetrics.getDescent() * scale;
                d.setColor((KFill)fore);
                if (NethomeCoreResource.TATE_STRING.indexOf(ss) >= 0) {
                    d.drawText(ss, cx - hei / 2.0 + ofs, cy + wid / 2.0, scaleFont.getName(), scaleFont.getStyle(), (double)mSize, mAngl - 90.0);
                    continue;
                }
                d.drawText(ss, cx - wid / 2.0, cy - hei / 2.0 + ofs, scaleFont.getName(), scaleFont.getStyle(), (double)mSize, mAngl);
            }
        }
    }
}

