/*
 * Decompiled with CFR 0.152.
 */
package nethome5.presentation.primitive.draw;

import java.util.List;
import jp.kitec.lib.geom.KLocalAxis;
import jp.kitec.lib.geom.KPath2d;
import jp.kitec.lib.geom.KPathSegmentUtil;
import jp.kitec.lib.kwt.IRichGraphics;
import jp.kitec.lib.kwt.KColor;
import jp.kitec.lib.kwt.KFill;
import jp.kitec.lib.kwt.KLineType;
import nethome5.presentation.LocalAxis2Df;
import nethome5.presentation.primitive.DrawParameters;
import nethome5.presentation.primitive.GPathShape;
import nethome5.presentation.primitive.draw.AbstractCustomDrawer;

public class GPathShapeDrawer
extends AbstractCustomDrawer<GPathShape> {
    @Override
    protected void doDraw(IRichGraphics d, DrawParameters params) {
        this.draw(d, params, true);
    }

    public void draw(IRichGraphics d, DrawParameters params, boolean clear) {
        KColor fore = params.get(DrawParameters.KEY_DRAW_COLOR, ((GPathShape)this.mGeom).getGeomColor());
        KFill back = params.get(DrawParameters.KEY_FILL_COLOR, ((GPathShape)this.mGeom).getFillColor());
        boolean fill = params.get(DrawParameters.KEY_FILL, true) != false && ((GPathShape)this.mGeom).isFillMode();
        LocalAxis2Df la = params.get(DrawParameters.KEY_LOCAL_AXIS, null);
        KLineType lineType = params.get(DrawParameters.KEY_LINE_TYPE, ((GPathShape)this.mGeom).getLineType());
        int windingRule = ((GPathShape)this.mGeom).getWindingRule();
        List<KPath2d> mSegments = ((GPathShape)this.mGeom).getSegments();
        d.pathAdd(KPathSegmentUtil.iterator(mSegments, (int)windingRule), (KLocalAxis)la);
        KLineType lt = lineType;
        if (lt == null) {
            lt = IRichGraphics.LINE_1;
        }
        if (clear) {
            if (fill && back != null) {
                d.setColor(back);
                d.fillPath(lt);
            }
            if (((GPathShape)this.mGeom).isDrawLine()) {
                d.setColor((KFill)fore);
                d.drawPath(lt);
            }
            d.pathClear();
        }
    }
}

