/*
 * Decompiled with CFR 0.152.
 */
package nethome5.presentation.primitive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple2d;
import jp.kitec.lib.kwt.KArea;
import jp.kitec.lib.kwt.KColor;
import jp.kitec.lib.util.RefList;
import jp.kitec.lib.util.tree.ObjectFolder;
import jp.kitec.lib.util.tree.ObjectNode;
import jp.kitec.vecmath.KPoint2d;
import nethome5.presentation.GeomName;
import nethome5.presentation.GeomParser;
import nethome5.presentation.primitive.GCurve;
import nethome5.presentation.primitive.GLine;
import nethome5.presentation.primitive.Geometry;
import nethome5.util.ToolMath;
import nethome5.util.ToolPolygon;

@GeomName(name="POLYGON")
public class GPolygon
extends GCurve {
    protected List<KPoint2d> mPoints;
    public int mSmooth;
    protected boolean mClosed;

    public GPolygon() {
        this(new ArrayList(), 0);
    }

    public GPolygon(List<? extends KPoint2d> p1, int smooth) {
        this.mPoints = new ArrayList<KPoint2d>(p1);
        this.mSmooth = smooth;
        this.mGeomColor = KColor.BLACK;
    }

    public void setClosed(boolean closed) {
        this.mClosed = closed;
    }

    @Override
    public boolean isClosed() {
        return this.mClosed;
    }

    public void addPoint(KPoint2d p) {
        this.mPoints.add(p);
    }

    public void setPoint(int index, Point2d p) {
        this.mPoints.get(index).set((Tuple2d)p);
    }

    @Override
    public void updateMinMax(KArea area) {
        for (int i = 0; i < this.mPoints.size(); ++i) {
            Point2d p = (Point2d)this.mPoints.get(i);
            area.updateMinMax(p.x, p.y);
        }
    }

    @Override
    public GPolygon copy() {
        return this.copyTo(new GPolygon());
    }

    @Override
    protected GPolygon copyTo(Geometry g) {
        if (g == null || !(g instanceof GPolygon)) {
            return null;
        }
        GPolygon np = (GPolygon)g;
        super.copyTo(np);
        ArrayList<KPoint2d> v = new ArrayList<KPoint2d>();
        for (int i = 0; i < this.mPoints.size(); ++i) {
            v.add((KPoint2d)this.mPoints.get(i).clone());
        }
        np.mPoints = v;
        np.mFill = this.mFill;
        np.setFillColor(this.mFillColor);
        np.setGeomColor(this.mGeomColor);
        np.mSmooth = this.mSmooth;
        return np;
    }

    @Override
    public double getDistanceToPoint(double x, double y) {
        double min = Double.MAX_VALUE;
        for (int i = 0; i < this.mPoints.size(); ++i) {
            Point2d p1 = null;
            Point2d p2 = null;
            p1 = (Point2d)this.mPoints.get(i);
            double l = ToolMath.getLength2D((double)x, (double)y, (double)p1.x, (double)p1.y);
            if (l < min) {
                min = l;
            }
            if (i == this.mPoints.size() - 1) {
                if (!this.isClosed()) continue;
                p2 = (Point2d)this.mPoints.get(0);
            } else {
                p2 = (Point2d)this.mPoints.get(i + 1);
            }
            double len = ToolMath.getLengthLimitLineToPoint2D((double)x, (double)y, (double)p1.x, (double)p1.y, (double)p2.x, (double)p2.y);
            if (len < 0.0 || !(len < min)) continue;
            min = len;
        }
        return min;
    }

    @Override
    public boolean isInner(double minx, double miny, double maxx, double maxy) {
        for (int i = 0; i < this.mPoints.size(); ++i) {
            Point2d p1 = (Point2d)this.mPoints.get(i);
            Point2d p2 = i == this.mPoints.size() - 1 ? (Point2d)this.mPoints.get(0) : (Point2d)this.mPoints.get(i + 1);
            boolean b1 = false;
            boolean b2 = false;
            if (p1.x > minx && p1.x < maxx && p1.y > miny && p1.y < maxy) {
                b1 = true;
            }
            if (p2.x > minx && p2.x < maxx && p2.y > miny && p2.y < maxy) {
                b2 = true;
            }
            if (b1 && b2) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isInner(RefList<Point2d> v) {
        for (int i = 0; i < this.mPoints.size(); ++i) {
            Point2d p1 = (Point2d)this.mPoints.get(i);
            Point2d p2 = i == this.mPoints.size() - 1 ? (Point2d)this.mPoints.get(0) : (Point2d)this.mPoints.get(i + 1);
            boolean b1 = ToolPolygon.isInnerPolygon(v, p1.x, p1.y);
            boolean b2 = ToolPolygon.isInnerPolygon(v, p2.x, p2.y);
            if (b1 && b2) continue;
            return false;
        }
        return true;
    }

    public List<KPoint2d> getPoints() {
        return Collections.unmodifiableList(this.mPoints);
    }

    @Override
    public void save(ObjectFolder savenode) {
        if (savenode == null) {
            return;
        }
        super.save(savenode);
        savenode.addNode("smooth", this.mSmooth);
        savenode.addNode("pointsize", this.mPoints.size());
        for (int i = 0; i < this.mPoints.size(); ++i) {
            Point2d p = (Point2d)this.mPoints.get(i);
            savenode.addNode("x" + (i + 1), p.x);
            savenode.addNode("y" + (i + 1), p.y);
        }
    }

    public static void readData(ObjectFolder of, Geometry g, GeomParser ps) throws Exception {
        if (!(g instanceof GPolygon)) {
            return;
        }
        GCurve.readData(of, g, ps);
        GPolygon gp = (GPolygon)g;
        gp.mPoints = new ArrayList<KPoint2d>();
        int num = 0;
        ObjectNode on = of.getNode("smooth");
        if (on != null) {
            gp.mSmooth = on.getInt();
        }
        if ((on = of.getNode("pointsize")) != null) {
            num = on.getInt();
        }
        for (int i = 0; i < num; ++i) {
            double x = 0.0;
            double y = 0.0;
            on = of.getNode("x" + (i + 1));
            if (on != null) {
                x = on.getDouble();
            }
            if ((on = of.getNode("y" + (i + 1))) != null) {
                y = on.getDouble();
            }
            gp.mPoints.add(new KPoint2d(x, y));
        }
    }

    public GLine getNearAsLine(double x, double y) {
        double min = Double.MAX_VALUE;
        Point2d pa = null;
        Point2d pb = null;
        for (int i = 0; i < this.mPoints.size(); ++i) {
            Point2d p1 = (Point2d)this.mPoints.get(i);
            Point2d p2 = (Point2d)this.mPoints.get(i + 1);
            double len = ToolMath.getLengthLimitLineToPoint2D((double)x, (double)y, (double)p1.x, (double)p1.y, (double)p2.x, (double)p2.y);
            if (len < 0.0 || !(len < min)) continue;
            min = len;
            pa = p1;
            pb = p2;
        }
        if (pa != null && pb != null) {
            return new GLine(pa, pb);
        }
        return null;
    }
}

