/*
 * Decompiled with CFR 0.152.
 */
package nethome5.presentation.primitive;

import java.util.ArrayList;
import java.util.List;
import jp.kitec.lib.geom.KPath2d;
import jp.kitec.lib.geom.KPathSegmentUtil;
import nethome5.presentation.primitive.GCurveBuilder;
import nethome5.presentation.primitive.GPathShape;

public class GPathShapeBuilder<B extends GPathShapeBuilder<B>>
extends GCurveBuilder<B> {
    private int mWindingRule = 4096;
    protected ArrayList<KPath2d> mSegments = new ArrayList();
    protected boolean mLine = true;

    public B windingRule(int w) {
        this.mWindingRule = w;
        return (B)this;
    }

    public B drawLine(boolean b) {
        this.mLine = b;
        return (B)this;
    }

    public B segments(List<? extends KPath2d> seg) {
        this.mSegments.addAll(seg);
        return (B)this;
    }

    public B moveTo(double x, double y) {
        this.mSegments.add(KPathSegmentUtil.moveTo((double)x, (double)y));
        return (B)this;
    }

    public B lineTo(double x, double y) {
        this.mSegments.add(KPathSegmentUtil.lineTo((double)x, (double)y));
        return (B)this;
    }

    public B close() {
        this.mSegments.add(KPathSegmentUtil.close());
        return (B)this;
    }

    public B quadTo(double cx1, double cy1, double x1, double y1) {
        this.mSegments.add(KPathSegmentUtil.quadTo((double)cx1, (double)cy1, (double)x1, (double)y1));
        return (B)this;
    }

    public B cubicTo(double cx1, double cy1, double cx2, double cy2, double x1, double y1) {
        this.mSegments.add(KPathSegmentUtil.cubicTo((double)cx1, (double)cy1, (double)cx2, (double)cy2, (double)x1, (double)y1));
        return (B)this;
    }

    protected void applyTo(GPathShape g) {
        super.applyTo(g);
        g.setDrawLine(this.mLine);
        g.setWindingRule(this.mWindingRule);
        g.addSegments(this.mSegments);
    }

    public GPathShape build() {
        GPathShape l = new GPathShape();
        this.applyTo(l);
        return l;
    }

    public static GPathShapeBuilder<?> create() {
        return new GPathShapeBuilder();
    }
}

