/*
 * Decompiled with CFR 0.152.
 */
package nethome.presentation.primitive;

import javax.vecmath.Point2d;
import jp.kitec.lib.geom.K2DPathFigurePoint;
import jp.kitec.lib.kwt.IRichGraphics;
import jp.kitec.lib.kwt.KArea;
import jp.kitec.lib.kwt.KColor;
import jp.kitec.lib.kwt.KFill;
import jp.kitec.lib.util.tree.ObjectFolder;
import jp.kitec.lib.util.tree.ObjectNode;
import nethome.NethomeCoreResource;
import nethome.presentation.GeomName;
import nethome.presentation.primitive.DrawParameters;
import nethome.presentation.primitive.Geometry;
import nethome.util.ToolMath;

@GeomName(name="POINT")
public class GPoint2Df
extends Geometry
implements K2DPathFigurePoint {
    public double x;
    public double y;
    public transient Object flagObj;
    public transient short wideUseFlag;

    public GPoint2Df() {
    }

    public int getType() {
        return 0;
    }

    public GPoint2Df(double x, double y) {
        this();
        this.x = x;
        this.y = y;
    }

    public void setXY(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setXY(GPoint2Df p) {
        this.setXY(p.getX(), p.getY());
    }

    @Override
    public void updateMinMax(KArea area) {
        area.updateMinMax(this.x, this.y);
    }

    @Override
    public Geometry copy() {
        return this.copyTo(new GPoint2Df());
    }

    @Override
    protected Geometry copyTo(Geometry g) {
        if (g == null || !(g instanceof GPoint2Df)) {
            return null;
        }
        GPoint2Df p = (GPoint2Df)g;
        super.copyTo(p);
        p.setXY(this);
        return p;
    }

    @Override
    public double getDistanceToPoint(double x, double y) {
        return ToolMath.getLength2D((double)x, (double)y, (double)this.x, (double)this.y);
    }

    public static void offset(Point2d p, double dx, double dy) {
        p.x += dx;
        p.y += dy;
    }

    public static void rotate(Point2d p, double xc, double yc, double angl) {
        double[] tmpf = new double[2];
        ToolMath.rotation2D((double)xc, (double)yc, (double)angl, (double)p.x, (double)p.y, (double[])tmpf);
        tmpf[0] = Math.rint(tmpf[0] * 1000.0) / 1000.0;
        tmpf[1] = Math.rint(tmpf[1] * 1000.0) / 1000.0;
        p.x = tmpf[0];
        p.y = tmpf[1];
    }

    public static void flipx(Point2d p, double x, double ofsx) {
        p.x = x - (p.x - x) + ofsx;
    }

    public static void flipy(Point2d p, double y, double ofsy) {
        p.y = y - (p.y - y) + ofsy;
    }

    public static void rot(Point2d p, double x, double y, double ofsx, double ofsy) {
        double tmpx = p.x;
        double tmpy = p.y;
        p.x = x - (tmpy - y) + ofsy;
        p.y = y + (tmpx - x);
    }

    public static void drawHighLight(IRichGraphics d, DrawParameters params, Point2d p) {
        GPoint2Df.drawHighLight(d, params, p.x, p.y);
    }

    public static void drawHighLight(IRichGraphics d, DrawParameters params, double x, double y) {
        KColor c = params.get(DrawParameters.KEY_DRAW_COLOR);
        d.setColor((KFill)c);
        d.drawMark(x, y, (int)NethomeCoreResource.MARKER_SIZE, 3);
        d.setColor((KFill)KColor.BLACK);
        d.drawMark(x, y, (int)NethomeCoreResource.MARKER_SIZE, 2);
    }

    @Override
    public void save(ObjectFolder savenode) {
        if (savenode == null) {
            return;
        }
        super.save(savenode);
        savenode.setName("POINT");
        savenode.addChild(new ObjectNode("x", (Object)Double.toString(this.x)));
        savenode.addChild(new ObjectNode("y", (Object)Double.toString(this.y)));
    }
}

