/*
 * Decompiled with CFR 0.152.
 */
package nethome.presentation.primitive;

import java.io.Serializable;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple2d;
import jp.kitec.lib.geom.K2DPathFigureLine;
import jp.kitec.lib.kwt.KArea;
import jp.kitec.lib.kwt.KColor;
import jp.kitec.lib.kwt.KLineType;
import jp.kitec.lib.util.RefList;
import jp.kitec.lib.util.tree.ObjectFolder;
import jp.kitec.lib.util.tree.ObjectNode;
import nethome.presentation.GeomName;
import nethome.presentation.GeomParser;
import nethome.presentation.primitive.GCurve;
import nethome.presentation.primitive.Geometry;
import nethome.util.ToolMath;
import nethome.util.ToolMathEx;
import nethome.util.ToolPolygon;

@GeomName(name="LINE")
public class GLine
extends GCurve
implements K2DPathFigureLine,
Serializable {
    private Point2d pA;
    private Point2d pB;

    public GLine() {
        this(new Point2d(), new Point2d());
    }

    public GLine(Point2d p1, Point2d p2) {
        this(p1, p2, null);
    }

    public GLine(Point2d p1, Point2d p2, KLineType ltype) {
        this.mGeomColor = KColor.BLACK;
        this.pA = p1;
        this.pB = p2;
        this.mLineType = ltype;
    }

    public GLine(double x1, double y1, double x2, double y2) {
        this(new Point2d(x1, y1), new Point2d(x2, y2));
    }

    public Point2d getA() {
        return (Point2d)this.pA.clone();
    }

    public void setA(Point2d pA) {
        this.pA.set((Tuple2d)pA);
    }

    public Point2d getB() {
        return (Point2d)this.pB.clone();
    }

    public void setB(Point2d pB) {
        this.pB.set((Tuple2d)pB);
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public void updateMinMax(KArea area) {
        area.updateMinMax(this.pA.x, this.pA.y);
        area.updateMinMax(this.pB.x, this.pB.y);
    }

    @Override
    public GLine copy() {
        return this.copyTo(new GLine());
    }

    @Override
    protected GLine copyTo(Geometry g) {
        if (g == null || !(g instanceof GLine)) {
            return null;
        }
        GLine gl = (GLine)g;
        super.copyTo(gl);
        gl.pA.set((Tuple2d)this.pA);
        gl.pB.set((Tuple2d)this.pB);
        return gl;
    }

    @Override
    public double getDistanceToPoint(double x, double y) {
        double len = ToolMath.getLengthLimitLineToPoint2D((double)x, (double)y, (double)this.pA.x, (double)this.pA.y, (double)this.pB.x, (double)this.pB.y);
        if (len < 0.0) {
            double a = ToolMathEx.getLength2D((double)x, (double)y, (double)this.pA.x, (double)this.pA.y);
            double b = ToolMathEx.getLength2D((double)x, (double)y, (double)this.pB.x, (double)this.pB.y);
            return Math.min(a, b);
        }
        return len;
    }

    @Override
    public boolean isInner(double minx, double miny, double maxx, double maxy) {
        boolean p1 = false;
        boolean p2 = false;
        if (this.pA.x > minx && this.pA.x < maxx && this.pA.y > miny && this.pA.y < maxy) {
            p1 = true;
        }
        if (this.pB.x > minx && this.pB.x < maxx && this.pB.y > miny && this.pB.y < maxy) {
            p2 = true;
        }
        return p1 && p2;
    }

    @Override
    public boolean isInner(RefList<Point2d> v) {
        return ToolPolygon.isInnerPolygon(v, this.pA.x, this.pA.y) && ToolPolygon.isInnerPolygon(v, this.pB.x, this.pB.y);
    }

    @Override
    public void save(ObjectFolder savenode) {
        if (savenode == null) {
            return;
        }
        super.save(savenode);
        savenode.addChild(new ObjectNode("x1", (Object)Double.toString(this.pA.x)));
        savenode.addChild(new ObjectNode("y1", (Object)Double.toString(this.pA.y)));
        savenode.addChild(new ObjectNode("x2", (Object)Double.toString(this.pB.x)));
        savenode.addChild(new ObjectNode("y2", (Object)Double.toString(this.pB.y)));
    }

    public static void readData(ObjectFolder of, Geometry g, GeomParser ps) throws Exception {
        if (!(g instanceof GLine)) {
            return;
        }
        GLine gp = (GLine)g;
        GCurve.readData(of, g, ps);
        ObjectNode on = of.getNode("x1");
        if (on != null) {
            gp.pA.x = ObjectNode.getNodeDouble((ObjectNode)on);
        }
        if ((on = of.getNode("y1")) != null) {
            gp.pA.y = ObjectNode.getNodeDouble((ObjectNode)on);
        }
        if ((on = of.getNode("x2")) != null) {
            gp.pB.x = ObjectNode.getNodeDouble((ObjectNode)on);
        }
        if ((on = of.getNode("y2")) != null) {
            gp.pB.y = ObjectNode.getNodeDouble((ObjectNode)on);
        }
    }

    public int getType() {
        return 1;
    }

    public double getX1() {
        return this.pA.x;
    }

    public double getX2() {
        return this.pB.x;
    }

    public double getY1() {
        return this.pA.y;
    }

    public double getY2() {
        return this.pB.y;
    }

    public void setX1(double x) {
        this.pA.x = x;
    }

    public void setX2(double x) {
        this.pB.x = x;
    }

    public void setY1(double y) {
        this.pA.y = y;
    }

    public void setY2(double y) {
        this.pB.y = y;
    }
}

