/*
 * Decompiled with CFR 0.152.
 */
package nethome.presentation.primitive.draw;

import java.util.List;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import jp.kitec.lib.geom.KPath2d;
import jp.kitec.lib.geom.KPathSegmentUtil;
import jp.kitec.lib.kwt.IRichGraphics;
import jp.kitec.lib.kwt.KImage;
import nethome.presentation.LocalAxis2Df;
import nethome.presentation.primitive.DrawParameters;
import nethome.presentation.primitive.GImage;
import nethome.presentation.primitive.draw.ICustomDrawable;

public class GImageDrawer
implements ICustomDrawable {
    GImage mGeom;

    public void setGeom(GImage geom) {
        this.mGeom = geom;
    }

    @Override
    public void draw(IRichGraphics d, DrawParameters params) {
        d.save();
        try {
            List<KPath2d> clip = this.mGeom.getClipShape();
            if (clip != null) {
                d.clip(KPathSegmentUtil.iterator(clip, (int)4096));
            }
            this.doDraw(d, params);
        }
        finally {
            d.restore();
        }
    }

    protected void doDraw(IRichGraphics d, DrawParameters params) {
        boolean fill = params.get(DrawParameters.KEY_FILL, true);
        LocalAxis2Df la = params.get(DrawParameters.KEY_LOCAL_AXIS, null);
        KImage image = this.mGeom.getImage();
        Point2d center = this.mGeom.getCenter();
        Vector2d size = this.mGeom.getSize();
        double angle = this.mGeom.getAngle();
        double cx = center.x;
        double cy = center.y;
        double width = size.x;
        double height = size.y;
        if (la != null) {
            cx = la.getGlobalX(center.x, center.y);
            cy = la.getGlobalY(center.x, center.y);
            angle = la.getGlobalAngl(angle);
            width = la.getGlobalLength(size.x);
            height = la.getGlobalLength(size.y);
        }
        d.drawImage(image, cx, cy, width, height, angle / (Math.PI / 180));
    }

    @Override
    public void drawHighLight(IRichGraphics d, DrawParameters params, boolean outline) {
        if (outline) {
            DrawParameters p = new DrawParameters(params);
            p.put(DrawParameters.KEY_FILL, false);
            this.draw(d, p);
        }
    }

    public void draw(IRichGraphics d) {
        this.draw(d, DrawParameters.NULL_PARAMETER);
    }
}

