/*
 * Decompiled with CFR 0.152.
 */
package nethome.presentation.primitive.draw;

import java.util.List;
import jp.kitec.lib.geom.KPath2d;
import jp.kitec.lib.geom.KPathSegmentUtil;
import jp.kitec.lib.kwt.IRichGraphics;
import nethome.doc.IDrawable;
import nethome.presentation.primitive.DrawParameters;
import nethome.presentation.primitive.Geometry;
import nethome.presentation.primitive.draw.ICustomDrawable;

public abstract class AbstractCustomDrawer<T extends Geometry>
implements ICustomDrawable,
IDrawable {
    protected T mGeom;

    public void setGeom(T geom) {
        this.mGeom = geom;
    }

    @Override
    public void draw(IRichGraphics d, DrawParameters params) {
        d.save();
        try {
            List<KPath2d> clip = ((Geometry)this.mGeom).getClipShape();
            if (clip != null) {
                d.clip(KPathSegmentUtil.iterator(clip, (int)4096));
            }
            this.doDraw(d, params);
        }
        finally {
            d.restore();
        }
    }

    protected abstract void doDraw(IRichGraphics var1, DrawParameters var2);

    @Override
    public void drawHighLight(IRichGraphics d, DrawParameters params, boolean outline) {
        if (outline) {
            DrawParameters p = new DrawParameters(params);
            p.put(DrawParameters.KEY_FILL, false);
            this.draw(d, p);
        }
    }

    public void draw(IRichGraphics d) {
        this.draw(d, DrawParameters.NULL_PARAMETER);
    }
}

