/*
 * Decompiled with CFR 0.152.
 */
package nethome.presentation.primitive;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import jp.kitec.lib.kwt.KArcType;
import jp.kitec.lib.kwt.KArea;
import jp.kitec.lib.kwt.KRotatedArea;
import jp.kitec.lib.util.RefList;
import jp.kitec.lib.util.tree.ObjectFolder;
import jp.kitec.lib.util.tree.ObjectNode;
import nethome.presentation.GeomName;
import nethome.presentation.GeomParser;
import nethome.presentation.primitive.GCurve;
import nethome.presentation.primitive.Geometry;
import nethome.util.ToolMath;
import nethome.util.ToolPolygon;
import org.apache.commons.lang.NotImplementedException;

@GeomName(name="CIRCLE")
public class GCircle
extends GCurve
implements Serializable {
    protected KRotatedArea mArea = new KRotatedArea();
    protected double mStart;
    protected double mSweep;
    protected List<Point2d> mMaxPts;
    protected KArcType mArcType;

    private GCircle() {
        this(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, KArcType.OPEN);
    }

    public GCircle(double cx, double cy, double w, double h, double angle, double start, double sweep, KArcType arcType) {
        this.mArea.setCenter(new Point2d(cx, cy));
        this.mArea.setSize(new Vector2d(w, h));
        this.mArea.setRotation(angle);
        this.mStart = start;
        this.mSweep = sweep;
        this.mArcType = arcType;
        this.updateMaxPoints();
    }

    public static boolean isParallel(Geometry g1, Geometry g2) {
        throw new NotImplementedException();
    }

    public static Geometry merge(Geometry g1, Geometry g2) {
        throw new NotImplementedException();
    }

    public double getStart() {
        return this.mStart;
    }

    public void setStart(double f) {
        this.mStart = f;
        this.updateMaxPoints();
    }

    public double getSweep() {
        return this.mSweep;
    }

    public void setSweep(double sweep) {
        this.mSweep = sweep;
        this.updateMaxPoints();
    }

    public double getAngle() {
        return this.mArea.getRotation();
    }

    public void setAngle(double angle) {
        this.mArea.setRotation(angle);
    }

    public double getRx() {
        return this.mArea.getWidth();
    }

    public void setRx(double rx) {
        this.mArea.setSize(new Vector2d(rx, this.mArea.getHeight()));
        this.updateMaxPoints();
    }

    public double getRy() {
        return this.mArea.getHeight();
    }

    public void setRy(double ry) {
        this.mArea.setSize(new Vector2d(this.mArea.getWidth(), ry));
        this.updateMaxPoints();
    }

    public void setX(double x) {
        this.mArea.setCenter(new Point2d(x, this.mArea.getCY()));
        this.updateMaxPoints();
    }

    public void setY(double y) {
        this.mArea.setCenter(new Point2d(this.mArea.getCX(), y));
        this.updateMaxPoints();
    }

    public double getX() {
        return this.mArea.getCX();
    }

    public double getY() {
        return this.mArea.getCY();
    }

    public KArcType getArcType() {
        return this.mArcType;
    }

    public void setArcType(KArcType arcType) {
        this.mArcType = arcType;
    }

    @Override
    public boolean isClosed() {
        return this.mSweep >= Math.PI * 2;
    }

    @Override
    public GCircle copy() {
        return this.copyTo(new GCircle());
    }

    @Override
    protected GCircle copyTo(Geometry g) {
        if (g == null || !(g instanceof GCircle)) {
            return null;
        }
        GCircle gc = (GCircle)g;
        super.copyTo(gc);
        gc.mArea.set(this.mArea);
        gc.mStart = this.mStart;
        gc.mSweep = this.mSweep;
        gc.setFillMode(this.mFill);
        gc.setFillColor(this.mFillColor);
        gc.updateMaxPoints();
        return gc;
    }

    @Override
    public void updateMinMax(KArea area) {
        for (Point2d p : this.mMaxPts) {
            area.updateMinMax(p.x, p.y);
        }
    }

    public List<Point2d> getMaxPts() {
        return this.mMaxPts;
    }

    private void updateMaxPoints() {
        double e;
        double s;
        if (this.mSweep > 0.0) {
            s = this.mStart;
            e = this.mStart + this.mSweep;
        } else {
            s = this.mStart + this.mSweep;
            e = this.mStart;
        }
        while (e > s + Math.PI * 2 + (double)0.001f) {
            s -= Math.PI * 2;
        }
        int div = (int)Math.ceil((e - s) / Math.PI * 32.0);
        Vector2d dx = this.mArea.getDirX();
        Vector2d dy = this.mArea.getDirY();
        dx.scale(this.getRx());
        dy.scale(this.getRy());
        this.mMaxPts = new ArrayList<Point2d>();
        Point2d cp = this.mArea.getCenter();
        if (this.mArcType == KArcType.PIE) {
            this.mMaxPts.add(new Point2d(cp.x, cp.y));
        }
        int i = 0;
        while (i <= div) {
            double angle = s + (e - s) / (double)div * (double)i;
            double cos = Math.cos(angle);
            double sin = Math.sin(angle);
            double x = dx.x * cos + dy.x * sin;
            double y = dx.y * cos + dy.y * sin;
            this.mMaxPts.add(new Point2d(cp.x + x, cp.y + y));
            ++i;
        }
    }

    @Override
    public double getDistanceToPoint(double x, double y) {
        boolean closed = this.isClosed();
        if (closed && Math.abs(this.getRx() - this.getRy()) < (double)0.001f) {
            return Math.abs(this.getRx() - ToolMath.getLength2D((double)this.getX(), (double)this.getY(), (double)x, (double)y));
        }
        double min = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < this.mMaxPts.size()) {
            Point2d p1 = this.mMaxPts.get(i);
            min = Math.min(min, ToolMath.getLength2D((double)x, (double)y, (double)p1.x, (double)p1.y));
            if (i != this.mMaxPts.size() - 1 || !closed) {
                Point2d p2 = i == this.mMaxPts.size() - 1 ? this.mMaxPts.get(0) : this.mMaxPts.get(i - 1);
                min = Math.min(min, ToolMath.getLengthLimitLineToPoint2D((double)x, (double)y, (double)p1.x, (double)p1.y, (double)p2.x, (double)p2.y));
            }
            ++i;
        }
        return min;
    }

    @Override
    public boolean isInner(double minx, double miny, double maxx, double maxy) {
        int i = 0;
        while (i < this.mMaxPts.size()) {
            Point2d p = this.mMaxPts.get(i);
            if (p.x < minx || p.x > maxx || p.y < miny || p.y > maxy) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean isInner(RefList<Point2d> v) {
        int i = 0;
        while (i < this.mMaxPts.size()) {
            Point2d p = this.mMaxPts.get(i);
            if (!ToolPolygon.isInnerPolygon(v, p.x, p.y)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void save(ObjectFolder savenode) {
        if (savenode == null) {
            return;
        }
        super.save(savenode);
        savenode.addNode("cx", this.getX());
        savenode.addNode("cy", this.getY());
        savenode.addNode("rx", this.getRx());
        savenode.addNode("ry", this.getRy());
        savenode.addNode("angle", this.getAngle());
        savenode.addNode("start", this.mStart);
        savenode.addNode("sweep", this.mSweep);
    }

    public static void readData(ObjectFolder of, Geometry g, GeomParser ps) throws Exception {
        if (!(g instanceof GCircle)) {
            return;
        }
        GCurve.readData(of, g, ps);
        GCircle gp = (GCircle)g;
        double cx = 0.0;
        double cy = 0.0;
        double w = 0.0;
        double h = 0.0;
        double angle = 0.0;
        ObjectNode on = of.getNode("cx");
        if (on != null) {
            cx = ObjectNode.getNodeDouble((ObjectNode)on);
        }
        if ((on = of.getNode("cy")) != null) {
            cy = ObjectNode.getNodeDouble((ObjectNode)on);
        }
        if ((on = of.getNode("rx")) != null) {
            w = ObjectNode.getNodeDouble((ObjectNode)on);
        }
        if ((on = of.getNode("ry")) != null) {
            h = ObjectNode.getNodeDouble((ObjectNode)on);
        }
        if ((on = of.getNode("angle")) != null) {
            angle = ObjectNode.getNodeDouble((ObjectNode)on);
        }
        gp.mArea.setCenter(new Point2d(cx, cy));
        gp.mArea.setSize(new Vector2d(w, h));
        gp.mArea.setRotation(angle);
        on = of.getNode("start");
        if (on != null) {
            gp.mStart = ObjectNode.getNodeDouble((ObjectNode)on);
        }
        if ((on = of.getNode("sweep")) != null) {
            gp.mSweep = ObjectNode.getNodeDouble((ObjectNode)on);
        }
    }
}

