/*
 * Decompiled with CFR 0.152.
 */
package nethome.presentation;

import jp.kitec.lib.kwt.IRichGraphics;
import jp.kitec.lib.kwt.KArea;
import jp.kitec.lib.kwt.KColor;
import jp.kitec.lib.kwt.KFill;
import jp.kitec.lib.kwt.KViewPort;
import jp.kitec.lib.util.AdapterUtils;
import jp.kitec.lib.util.Vector2;
import nethome.doc.IDrawable;
import nethome.doc.Model;
import nethome.presentation.GeometryPresentation;
import nethome.presentation.IDrawablesProvider;
import nethome.presentation.PresentationLayer;
import nethome.presentation.WorkSheet;
import nethome.presentation.primitive.Geometry;
import nethome.presentation.primitive.GeometryRichGraphics;
import nethome.ui.CanvasDrawer;

public class DrawableGeometryPresentation
extends GeometryPresentation {
    protected CanvasDrawer<Model> mDrawer;

    public void setDrawer(CanvasDrawer<Model> drawer) {
        this.mDrawer = drawer;
    }

    public void update(Model m) {
        IDrawablesProvider l = (IDrawablesProvider)AdapterUtils.getAdapter((Object)m, IDrawablesProvider.class);
        if (l == null) {
            return;
        }
        PresentationLayer main = this.getLayer("MAIN");
        main.refresh();
        GeometryRichGraphics rg = new GeometryRichGraphics();
        for (IDrawable d : l.get()) {
            d.draw((IRichGraphics)rg);
        }
        for (Geometry g : rg.getGeoms()) {
            main.addPrimitive(g);
        }
    }

    public void refreshPresentation() {
        this.drawGrid(KColor.LIGHT_GRAY, KColor.MORELIGHT_GRAY, false);
    }

    protected void drawGrid(KColor mc, KColor sc, boolean dash) {
        Vector2<Double> exY;
        double ddd;
        PresentationLayer sheet = this.getLayer("SHEET");
        sheet.refresh();
        GeometryRichGraphics g = new GeometryRichGraphics();
        WorkSheet ws = this.mWorkSheet;
        KViewPort vp = new KViewPort();
        double module = this.mWorkSheet.getModule();
        KArea area = this.mWorkSheet.getArea();
        vp.resetViewPort(area, module);
        double minx = vp.devToRealX(this.mSize, 0.0);
        double miny = vp.devToRealY(this.mSize, 0.0);
        double maxx = vp.devToRealX(this.mSize, (double)this.mSize.width);
        double maxy = vp.devToRealY(this.mSize, (double)this.mSize.height);
        double xx = ws.getGridCenterX();
        double yy = ws.getGridCenterY();
        int minxc = ws.getNearNotExtraGrid(minx, xx, ws.getCurrentGrid()) - 1;
        int minyc = ws.getNearNotExtraGrid(maxy, yy, ws.getCurrentGrid()) - 1;
        int maxxc = ws.getNearNotExtraGrid(maxx, xx, ws.getCurrentGrid()) + 1;
        int maxyc = ws.getNearNotExtraGrid(miny, yy, ws.getCurrentGrid()) + 1;
        minx = Math.max(xx + (double)minxc * ws.getCurrentGrid(), area.minX);
        miny = Math.max(yy + (double)minyc * ws.getCurrentGrid(), area.minY);
        maxx = Math.min(xx + (double)maxxc * ws.getCurrentGrid(), area.maxX);
        maxy = Math.min(yy + (double)maxyc * ws.getCurrentGrid(), area.maxY);
        int i = minxc;
        while (i <= maxxc) {
            double x = xx + (double)i * ws.getCurrentGrid();
            if (area.isInner(x, area.minY)) {
                ddd = Math.abs((x - ws.getGridCenterX()) % ws.getModule());
                if (ddd < (double)0.001f || Math.abs(ddd - ws.getModule()) < (double)0.001f) {
                    g.setColor((KFill)mc);
                    if (!dash) {
                        g.drawLine(x, miny, x, maxy, IRichGraphics.LINE_1);
                    } else {
                        g.drawLine(x, miny, x, maxy, IRichGraphics.LINE_DASH_1);
                    }
                } else {
                    g.setColor((KFill)sc);
                    if (!dash) {
                        g.drawLine(x, miny, x, maxy, IRichGraphics.LINE_1);
                    } else {
                        g.drawLine(x, miny, x, maxy, IRichGraphics.LINE_DASH_1);
                    }
                }
            }
            ++i;
        }
        i = minyc;
        while (i <= maxyc) {
            double y = yy + (double)i * ws.getCurrentGrid();
            if (area.isInner(area.minX, y)) {
                ddd = Math.abs((y - ws.getGridCenterY()) % ws.getModule());
                if (ddd < (double)0.001f || Math.abs(ddd - ws.getModule()) < (double)0.001f) {
                    g.setColor((KFill)mc);
                    if (!dash) {
                        g.drawLine(minx, y, maxx, y, IRichGraphics.LINE_1);
                    } else {
                        g.drawLine(minx, y, maxx, y, IRichGraphics.LINE_DASH_1);
                    }
                } else {
                    g.setColor((KFill)sc);
                    if (!dash) {
                        g.drawLine(minx, y, maxx, y, IRichGraphics.LINE_1);
                    } else {
                        g.drawLine(minx, y, maxx, y, IRichGraphics.LINE_DASH_1);
                    }
                }
            }
            ++i;
        }
        Vector2<Double> exX = ws.getExtraGridX();
        if (exX != null) {
            g.setColor((KFill)mc);
            int i2 = 0;
            while (i2 < exX.size()) {
                double x = (Double)exX.elementAt(i2);
                if (x > minx && x < maxx) {
                    if (!dash) {
                        g.drawLine(x, miny, x, maxy, IRichGraphics.LINE_1);
                    } else {
                        g.drawLine(x, miny, x, maxy, IRichGraphics.LINE_DASH_1);
                    }
                }
                ++i2;
            }
        }
        if ((exY = ws.getExtraGridY()) != null) {
            g.setColor((KFill)mc);
            int i3 = 0;
            while (i3 < exY.size()) {
                double y = (Double)exY.elementAt(i3);
                if (y > miny && y < maxy) {
                    if (!dash) {
                        g.drawLine(minx, y, maxx, y, IRichGraphics.LINE_1);
                    } else {
                        g.drawLine(minx, y, maxx, y, IRichGraphics.LINE_DASH_1);
                    }
                }
                ++i3;
            }
        }
        g.setColor((KFill)KColor.BLACK);
        g.drawLine(area.minX, area.minY, area.maxX, area.minY, IRichGraphics.LINE_2);
        g.drawLine(area.minX, area.maxY, area.maxX, area.maxY, IRichGraphics.LINE_2);
        g.drawLine(area.minX, area.minY, area.minX, area.maxY, IRichGraphics.LINE_2);
        g.drawLine(area.maxX, area.minY, area.maxX, area.maxY, IRichGraphics.LINE_2);
        for (Geometry p : g.getGeoms()) {
            sheet.addPrimitive(p);
        }
    }
}

