/*
 * Decompiled with CFR 0.152.
 */
package nethome.util;

import java.util.Vector;
import javax.vecmath.Point2d;
import nethome.util.ToolMath;

public class TotsuHou {
    public static Vector<Point2d> getTotshuhou(Vector<? extends Point2d> points) {
        if (points.size() < 3) {
            return null;
        }
        TotsuHou.selectMin(points);
        TotsuHou.sortPoints(points);
        int[] stk = new int[points.size()];
        int top = 2;
        stk[0] = 0;
        stk[1] = 1;
        stk[2] = 2;
        int i = 3;
        while (i < points.size()) {
            Point2d p2 = points.elementAt(i);
            while (true) {
                Point2d p0 = points.elementAt(stk[top - 1]);
                Point2d p1 = points.elementAt(stk[top]);
                if (ToolMath.crossProduct((double)p0.x, (double)p0.y, (double)p1.x, (double)p1.y, (double)p2.x, (double)p2.y) >= 0.0) break;
                --top;
            }
            stk[++top] = i++;
        }
        Vector<Point2d> res = new Vector<Point2d>();
        for (int i2 = 0; i2 <= top; ++i2) {
            Point2d p = points.elementAt(stk[i2]);
            res.addElement(new Point2d(p.x, p.y));
        }
        return res;
    }

    private static void swapPoints(Point2d p1, Point2d p2) {
        double x = p1.x;
        double y = p1.y;
        p1.x = p2.x;
        p1.y = p2.y;
        p2.x = x;
        p2.y = y;
    }

    private static void selectMin(Vector<? extends Point2d> points) {
        double ym = points.elementAt((int)0).y;
        int m = 0;
        for (int i = 1; i < points.size(); ++i) {
            Point2d p = points.elementAt(i);
            Point2d pm = points.elementAt(m);
            if (!(ym > p.y) && (!(Math.abs(ym - p.y) < (double)0.001f) || !(pm.x > p.x))) continue;
            ym = p.y;
            m = i;
        }
        TotsuHou.swapPoints(points.elementAt(0), points.elementAt(m));
    }

    private static void sortPoints(Vector<? extends Point2d> points) {
        for (int i = 1; i < points.size() - 1; ++i) {
            for (int j = i + 1; j < points.size(); ++j) {
                Point2d p0 = points.elementAt(0);
                Point2d pi = points.elementAt(i);
                Point2d pj = points.elementAt(j);
                if (!(ToolMath.crossProduct((double)p0.x, (double)p0.y, (double)pi.x, (double)pi.y, (double)pj.x, (double)pj.y) < 0.0)) continue;
                TotsuHou.swapPoints(pi, pj);
            }
        }
    }
}

