/*
 * Decompiled with CFR 0.152.
 */
package nethome.presentation.primitive;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point2d;
import jp.kitec.kwt.KArea;
import jp.kitec.lib.geom.KPath2d;
import jp.kitec.lib.geom.KPathSegmentUtil;
import jp.kitec.lib.util.RefList;
import jp.kitec.lib.util.StringUtil;
import jp.kitec.lib.util.tree.ObjectFolder;
import jp.kitec.lib.util.tree.ObjectNode;
import nethome.presentation.GeomName;
import nethome.presentation.GeomParser;
import nethome.presentation.primitive.Element;
import org.eclipse.core.runtime.PlatformObject;

@GeomName(name="GEOMETRY")
public abstract class Geometry
extends PlatformObject
implements Serializable,
Element {
    protected int mGid;
    protected Map<Object, Object> mUserProps = null;
    protected List<KPath2d> mClipShape;

    public String getGeomName() {
        GeomName annotation = this.getClass().getAnnotation(GeomName.class);
        if (annotation == null) {
            return null;
        }
        return annotation.name();
    }

    @Override
    public void setID(int id) {
        this.mGid = id;
    }

    @Override
    public int getID() {
        return this.mGid;
    }

    public List<KPath2d> getClipShape() {
        return this.mClipShape;
    }

    public void setClipShape(List<KPath2d> clipShape) {
        this.mClipShape = clipShape;
    }

    public void updateMinMax(KArea area) {
    }

    public Geometry copy() {
        return null;
    }

    protected Geometry copyTo(Geometry g) {
        if (g == null) {
            return null;
        }
        g.mGid = this.mGid;
        return g;
    }

    protected Point2d getNearNode(double x, double y) {
        return null;
    }

    public double getDistanceToPoint(double x, double y) {
        return Double.POSITIVE_INFINITY;
    }

    public static void readData(ObjectFolder datanode, Geometry geom, GeomParser ps) throws Exception {
        ObjectNode on = datanode.getNode("id");
        if (on != null) {
            geom.mGid = on.getInt();
        }
        if ((on = datanode.getNode("clip")) != null) {
            String[] tokens = on.getString().split(" ");
            geom.mClipShape = new ArrayList<KPath2d>();
            geom.mClipShape.addAll(KPathSegmentUtil.read((String[])tokens));
        }
    }

    @Override
    public void save(ObjectFolder savenode) {
        if (savenode == null) {
            return;
        }
        savenode.setName(this.getGeomName());
        savenode.addNode("id", this.getID());
        if (this.mClipShape != null) {
            String[] segments = KPathSegmentUtil.write(this.mClipShape);
            ObjectFolder.addNodeString((ObjectFolder)savenode, (String)"clip", (String)StringUtil.concat((String[])segments, (String)" "));
        }
    }

    public boolean isInner(double minx, double miny, double maxx, double maxy) {
        return false;
    }

    public boolean isInner(RefList<Point2d> v) {
        return false;
    }

    public void putUserProperty(Object key, Object value) {
        if (this.mUserProps == null) {
            this.mUserProps = new HashMap<Object, Object>();
        }
        this.mUserProps.put(key, value);
    }

    public Object getUserProperty(Object key) {
        if (this.mUserProps == null) {
            return null;
        }
        return this.mUserProps.get(key);
    }

    public Object getAdapter(Class adapter) {
        return super.getAdapter(adapter);
    }
}

