/*
 * Decompiled with CFR 0.152.
 */
package nethome.presentation.primitive;

import jp.kitec.kwt.KColor;
import jp.kitec.kwt.KFill;
import jp.kitec.kwt.KFills;
import jp.kitec.kwt.KLineType;
import jp.kitec.lib.util.tree.ObjectFolder;
import jp.kitec.lib.util.tree.ObjectNode;
import nethome.presentation.GeomParser;
import nethome.presentation.primitive.Geometry;
import nethome.presentation.primitive.IFillableGeometry;

public abstract class GCurve
extends Geometry
implements IFillableGeometry {
    protected double mLineWidth;
    protected KLineType mLineType = null;
    protected double mLineStrokeOffest = 0.0;
    protected KColor mGeomColor = KColor.BLACK;
    protected boolean mFill = false;
    protected KFill mFillColor;
    protected boolean mDrawLine = true;

    public double getLineWidth() {
        return this.mLineWidth;
    }

    public void setLineWidth(double lineWidth) {
        this.mLineWidth = lineWidth;
    }

    public void setLineType(KLineType lt) {
        this.mLineType = lt;
    }

    public KLineType getLineType() {
        return this.mLineType;
    }

    public void setLineStrokeOffest(double lineStrokeOffest) {
        this.mLineStrokeOffest = lineStrokeOffest;
    }

    public double getLineStrokeOffest() {
        return this.mLineStrokeOffest;
    }

    @Override
    public void setFillMode(boolean b) {
        this.mFill = b;
    }

    @Override
    public boolean isFillMode() {
        return this.mFill;
    }

    public abstract boolean isClosed();

    public void setGeomColor(KColor c) {
        this.mGeomColor = c;
    }

    public KColor getGeomColor() {
        return this.mGeomColor;
    }

    @Override
    public KFill getFillColor() {
        return this.mFillColor;
    }

    @Override
    public void setFillColor(KFill fillColor) {
        this.mFillColor = fillColor;
    }

    @Override
    public void setDrawLine(boolean line) {
        this.mDrawLine = line;
    }

    @Override
    public boolean isDrawLine() {
        return this.mDrawLine;
    }

    @Override
    protected GCurve copyTo(Geometry g) {
        if (g == null || !(g instanceof GCurve)) {
            return null;
        }
        GCurve c = (GCurve)g;
        super.copyTo(c);
        c.mLineWidth = this.mLineWidth;
        c.mLineType = this.mLineType;
        c.mGeomColor = this.mGeomColor;
        c.mFill = this.mFill;
        c.mFillColor = this.mFillColor;
        c.mDrawLine = this.mDrawLine;
        return c;
    }

    @Override
    public void save(ObjectFolder savenode) {
        if (savenode == null) {
            return;
        }
        super.save(savenode);
        savenode.addChild(new ObjectNode("width", (Object)Double.toString(this.mLineWidth)));
        if (this.mLineType != null) {
            ObjectFolder ln = new ObjectFolder("");
            this.mLineType.save(ln);
            savenode.addChild((ObjectNode)ln);
        }
        if (this.mGeomColor != null) {
            savenode.addNode("forec", this.mGeomColor.encode());
        }
        if (this.mFillColor != null) {
            savenode.addNode("fillc", KFills.encode((KFill)this.mFillColor));
        }
        savenode.addNode("drawline", this.mDrawLine);
        savenode.addNode("fill", this.mFill);
    }

    public static void readData(ObjectFolder of, Geometry g, GeomParser ps) throws Exception {
        GCurve gp = null;
        if (!(g instanceof GCurve)) {
            return;
        }
        gp = (GCurve)g;
        Geometry.readData(of, gp, ps);
        ObjectNode on = of.getNode("width");
        if (on != null) {
            gp.mLineWidth = on.getDouble();
        }
        if ((on = of.getNode("LINETYPE")) != null && on instanceof ObjectFolder) {
            gp.mLineType = KLineType.readData((ObjectFolder)((ObjectFolder)on));
        }
        if ((on = of.getNode("forec")) != null) {
            gp.mGeomColor = KColor.decode((String)on.getString());
        }
        if ((on = of.getNode("fillc")) != null) {
            gp.mFillColor = KFills.decode((String)on.getString());
        }
        if ((on = of.getNode("fill")) != null) {
            gp.mFill = on.getBool();
        }
        if ((on = of.getNode("drawline")) != null) {
            gp.mDrawLine = on.getBool();
        }
    }
}

