/*
 * Decompiled with CFR 0.152.
 */
package nethome.util;

import jp.kitec.lib.util.RefList;
import nethome.presentation.primitive.GPoint2Df;
import nethome.util.ToolMath;

public class ToolTesse {
    private static final int FLAG_COMPLEX = 1;
    private static final int FLAG_DISABLE = 2;
    private static final int FLAG_EXCEPTION = 4;
    private static final int MAX_TRIANGLE = 256;
    private static final int MAX_INTERSECTIONTEST = 5;
    public static short[] mIndex = new short[1024];
    private static int mIndexPt = 0;
    private static short[] mSrc = new short[256];

    public static boolean culc(RefList<? extends GPoint2Df> pts) {
        int i;
        mIndexPt = 0;
        mSrc = new short[pts.size()];
        for (i = 0; i < pts.size(); ++i) {
            ((GPoint2Df)pts.elementAt((int)i)).wideUseFlag = 0;
            ToolTesse.mSrc[i] = (short)i;
        }
        for (i = 0; i < mIndex.length; ++i) {
            ToolTesse.mIndex[i] = 0;
        }
        return ToolTesse.tessellation(pts, mSrc, pts.size());
    }

    private static boolean tessellation(RefList<? extends GPoint2Df> vtx, short[] src, int length) {
        int i;
        if (length < 3) {
            return false;
        }
        if (length == 3) {
            ToolTesse.mIndex[ToolTesse.mIndexPt++] = (short)length;
            for (int i2 = 0; i2 < length; ++i2) {
                ToolTesse.mIndex[ToolTesse.mIndexPt++] = src[i2];
            }
            return false;
        }
        boolean complex = ToolTesse.checkComplex(vtx, src, length);
        for (i = 0; i < length; ++i) {
            if ((((GPoint2Df)vtx.elementAt((int)src[i])).wideUseFlag & 4) == 0) continue;
            for (int j = i; j < length - 1; ++j) {
                src[j] = src[j + 1];
            }
            --length;
            --i;
        }
        if (complex) {
            ToolTesse.division(vtx, src, length);
            return true;
        }
        ToolTesse.mIndex[ToolTesse.mIndexPt++] = (short)length;
        for (i = 0; i < length; ++i) {
            ToolTesse.mIndex[ToolTesse.mIndexPt++] = src[i];
        }
        return false;
    }

    private static boolean checkComplex(RefList<? extends GPoint2Df> vtx, short[] src, int length) {
        int complex = 0;
        for (int i = 0; i < length; ++i) {
            GPoint2Df v = (GPoint2Df)vtx.elementAt((int)src[i]);
            GPoint2Df v1 = (GPoint2Df)vtx.elementAt((int)src[i - 1 < 0 ? length - 1 : i - 1]);
            GPoint2Df v2 = (GPoint2Df)vtx.elementAt((int)src[i + 1 >= length ? 0 : i + 1]);
            float angl = (float)ToolMath.getAngle2Lines((double)v2.x, (double)v2.y, (double)v.x, (double)v.y, (double)v1.x, (double)v1.y);
            if (Math.abs((double)angl - Math.PI) < (double)0.001f) {
                v.wideUseFlag = (short)4;
                continue;
            }
            if ((double)angl <= Math.PI) {
                v.wideUseFlag = 0;
                continue;
            }
            v.wideUseFlag = 1;
            ++complex;
        }
        return complex != 0;
    }

    private static void division(RefList<? extends GPoint2Df> vtx, short[] src, int length) {
        GPoint2Df t;
        int i;
        for (i = 0; i < length && (((GPoint2Df)vtx.elementAt((int)src[i])).wideUseFlag & 1) <= 0; ++i) {
        }
        int base = i;
        GPoint2Df v1 = (GPoint2Df)vtx.elementAt((int)src[base]);
        GPoint2Df v2 = (GPoint2Df)vtx.elementAt((int)src[base - 1 < 0 ? length - 1 : base - 1]);
        GPoint2Df v3 = (GPoint2Df)vtx.elementAt((int)src[base + 1 >= length ? 0 : base + 1]);
        v1.wideUseFlag = (short)(v1.wideUseFlag | 2);
        v2.wideUseFlag = (short)(v2.wideUseFlag | 2);
        v3.wideUseFlag = (short)(v3.wideUseFlag | 2);
        float angl1 = (float)ToolMath.getAngle2Lines((double)v3.x, (double)v3.y, (double)v1.x, (double)v1.y, (double)v2.x, (double)v2.y);
        for (i = 0; i < length; ++i) {
            float angl2;
            t = (GPoint2Df)vtx.elementAt((int)src[i]);
            if ((t.wideUseFlag & 2) != 0 || !((angl2 = (float)ToolMath.getAngle2Lines((double)v3.x, (double)v3.y, (double)v1.x, (double)v1.y, (double)t.x, (double)t.y)) > angl1)) continue;
            t.wideUseFlag = (short)(t.wideUseFlag | 2);
        }
        if (length > 5) {
            block2: for (i = 0; i < length; ++i) {
                t = (GPoint2Df)vtx.elementAt((int)src[i]);
                if ((t.wideUseFlag & 2) != 0) continue;
                for (int j = 0; j < length; ++j) {
                    if (!ToolTesse.intersection(v1, t, (GPoint2Df)vtx.elementAt((int)src[j]), (GPoint2Df)vtx.elementAt((int)src[(j + 1) % length]))) continue;
                    t.wideUseFlag = (short)(t.wideUseFlag | 2);
                    continue block2;
                }
            }
        }
        float da = Float.MAX_VALUE;
        int target = -1;
        for (i = 0; i < length; ++i) {
            float angl2;
            float dat;
            GPoint2Df t2 = (GPoint2Df)vtx.elementAt((int)src[i]);
            if ((t2.wideUseFlag & 2) != 0 || !((dat = Math.abs(angl1 / 2.0f - (angl1 - (angl2 = (float)ToolMath.getAngle2Lines((double)v3.x, (double)v3.y, (double)v1.x, (double)v1.y, (double)t2.x, (double)t2.y))))) < da)) continue;
            da = dat;
            target = i;
        }
        if (target < 0) {
            return;
        }
        short[] dst = new short[length];
        int p = base;
        int c = 0;
        for (i = 0; i < length; ++i) {
            dst[i] = src[p];
            ++c;
            if (p == target) break;
            if (++p < length) continue;
            p = 0;
        }
        ToolTesse.tessellation(vtx, dst, c);
        c = 0;
        for (i = 0; i < length; ++i) {
            dst[i] = src[p];
            ++c;
            if (p == base) break;
            if (++p < length) continue;
            p = 0;
        }
        ToolTesse.tessellation(vtx, dst, c);
    }

    private static boolean intersection(GPoint2Df p1, GPoint2Df p2, GPoint2Df p3, GPoint2Df p4) {
        return ((p1.x - p2.x) * (p3.y - p1.y) + (p1.y - p2.y) * (p1.x - p3.x)) * ((p1.x - p2.x) * (p4.y - p1.y) + (p1.y - p2.y) * (p1.x - p4.x)) < 0.0 && ((p3.x - p4.x) * (p1.y - p3.y) + (p3.y - p4.y) * (p3.x - p1.x)) * ((p3.x - p4.x) * (p2.y - p3.y) + (p3.y - p4.y) * (p3.x - p2.x)) < 0.0;
    }
}

