/*
 * Decompiled with CFR 0.152.
 */
package nethome.presentation.primitive.draw;

import java.util.List;
import jp.kitec.kwt.IRichGraphics;
import jp.kitec.lib.geom.KPath2d;
import jp.kitec.lib.geom.KPathSegmentUtil;
import jp.kitec.lib.util.AdapterUtils;
import nethome.doc.IDrawable;
import nethome.presentation.primitive.DrawParameters;
import nethome.presentation.primitive.GGroup;
import nethome.presentation.primitive.Geometry;
import nethome.presentation.primitive.draw.ICustomDrawable;

public class GGroupDrawer
implements ICustomDrawable {
    GGroup mGeom;

    public void setGeom(GGroup geom) {
        this.mGeom = geom;
    }

    @Override
    public void drawHighLight(IRichGraphics d, DrawParameters params, boolean outline) {
        int n = this.mGeom.getChildCount();
        for (int i = 0; i < n; ++i) {
            Geometry g = this.mGeom.getChild(i);
            ICustomDrawable drawable = (ICustomDrawable)AdapterUtils.getAdapter((Object)g, ICustomDrawable.class);
            if (drawable == null) continue;
            drawable.drawHighLight(d, params, outline);
        }
    }

    public void draw(IRichGraphics d) {
        d.save();
        try {
            List<KPath2d> clip = this.mGeom.getClipShape();
            if (clip != null) {
                d.clip(KPathSegmentUtil.iterator(clip, (int)4096));
            }
            this.doDraw(d);
        }
        finally {
            d.restore();
        }
    }

    protected void doDraw(IRichGraphics d) {
        int n = this.mGeom.getChildCount();
        for (int i = 0; i < n; ++i) {
            Geometry g = this.mGeom.getChild(i);
            IDrawable drawable = (IDrawable)AdapterUtils.getAdapter((Object)g, IDrawable.class);
            if (drawable == null) continue;
            drawable.draw(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(IRichGraphics d, DrawParameters params) {
        d.save();
        try {
            List<KPath2d> clip = this.mGeom.getClipShape();
            if (clip != null) {
                d.clip(KPathSegmentUtil.iterator(clip, (int)4096));
            }
            this.doDraw(d, params);
        }
        finally {
            d.restore();
        }
    }

    protected void doDraw(IRichGraphics d, DrawParameters params) {
        int n = this.mGeom.getChildCount();
        for (int i = 0; i < n; ++i) {
            Geometry g = this.mGeom.getChild(i);
            ICustomDrawable drawable = (ICustomDrawable)AdapterUtils.getAdapter((Object)g, ICustomDrawable.class);
            if (drawable == null) continue;
            drawable.draw(d, params);
        }
    }
}

