/*
 * Decompiled with CFR 0.152.
 */
package nethome.presentation.primitive.draw;

import java.util.ArrayList;
import java.util.List;
import jp.kitec.kwt.IRichGraphics;
import jp.kitec.kwt.KColor;
import jp.kitec.kwt.KFill;
import jp.kitec.kwt.KLineType;
import jp.kitec.vecmath.KPoint2d;
import nethome.presentation.LocalAxis2Df;
import nethome.presentation.primitive.DrawParameters;
import nethome.presentation.primitive.GPolygon;
import nethome.presentation.primitive.draw.AbstractCustomDrawer;

public class GPolygonDrawer
extends AbstractCustomDrawer<GPolygon> {
    private transient List<KPoint2d> _pbuf = new ArrayList<KPoint2d>();

    @Override
    protected void doDraw(IRichGraphics d, DrawParameters params) {
        KColor fore = params.get(DrawParameters.KEY_DRAW_COLOR, ((GPolygon)this.mGeom).getGeomColor());
        KFill back = params.get(DrawParameters.KEY_FILL_COLOR, ((GPolygon)this.mGeom).getFillColor());
        boolean fill = params.get(DrawParameters.KEY_FILL, true) != false && ((GPolygon)this.mGeom).isFillMode();
        LocalAxis2Df la = params.get(DrawParameters.KEY_LOCAL_AXIS, null);
        KLineType lineType = params.get(DrawParameters.KEY_LINE_TYPE, ((GPolygon)this.mGeom).getLineType());
        List<KPoint2d> mPoints = ((GPolygon)this.mGeom).getPoints();
        List<KPoint2d> poly = null;
        if (this._pbuf != null) {
            this._pbuf.clear();
        } else {
            this._pbuf = new ArrayList<KPoint2d>();
        }
        if (la != null) {
            for (int i = 0; i < mPoints.size(); ++i) {
                KPoint2d p1 = mPoints.get(i);
                double x1 = la.getGlobalX(p1.x, p1.y);
                double y1 = la.getGlobalY(p1.x, p1.y);
                this._pbuf.add(new KPoint2d(x1, y1));
            }
            poly = this._pbuf;
        } else {
            poly = mPoints;
        }
        if (poly.size() > 1) {
            if (fill && back != null) {
                d.setColor(back);
                d.drawFillPolygon(poly, lineType);
            }
            if (fore != null && ((GPolygon)this.mGeom).isDrawLine()) {
                d.setColor((KFill)fore);
                d.drawPolygon(poly, lineType);
            }
        }
        this._pbuf.clear();
    }
}

